/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.il;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.utils.GUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockScheduler
implements Scheduler {
    private static final Log __log = LogFactory.getLog(MockScheduler.class);
    private Scheduler.JobProcessor _processor;
    private Timer _timer = new Timer(false);
    private ScheduledExecutorService _exec;
    private TransactionManager _txm;
    ThreadLocal<List<Synchronization>> _synchros = new ThreadLocal<List<Synchronization>>(){

        @Override
        protected List<Synchronization> initialValue() {
            return new ArrayList<Synchronization>();
        }
    };

    public MockScheduler(TransactionManager transactionManager) {
        this._txm = transactionManager;
        this._exec = Executors.newSingleThreadScheduledExecutor();
    }

    public String schedulePersistedJob(final Map<String, Object> map, Date date) throws ContextException {
        final Date date2 = date == null ? new Date() : date;
        this.registerSynchronizer(new Synchronization(){

            public void afterCompletion(int n) {
                long l = Math.max(0L, date2.getTime() - System.currentTimeMillis());
                MockScheduler.this._exec.schedule(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        Scheduler.JobInfo jobInfo = new Scheduler.JobInfo("job" + System.currentTimeMillis(), map, 0);
                        MockScheduler.this.doExecute(jobInfo);
                        return null;
                    }
                }, l, TimeUnit.MILLISECONDS);
            }

            public void beforeCompletion() {
            }
        });
        return new GUID().toString();
    }

    public void cancelJob(String string) throws ContextException {
    }

    public void start() {
    }

    public void stop() {
    }

    public void shutdown() {
    }

    private void registerSynchronizer(Synchronization synchronization) throws ContextException {
        try {
            this._txm.getTransaction().registerSynchronization(synchronization);
        }
        catch (Exception exception) {
            __log.error((Object)"Exception in mock scheduler sync registration.", (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    private void doExecute(Scheduler.JobInfo jobInfo) {
        Scheduler.JobProcessor jobProcessor = this._processor;
        if (jobProcessor == null) {
            throw new RuntimeException("No processor.");
        }
        try {
            jobProcessor.onScheduledJob(jobInfo);
        }
        catch (Exception exception) {
            throw new RuntimeException("Scheduled transaction failed unexpectedly: transaction will not be retried!.", exception);
        }
    }

    public void setJobProcessor(Scheduler.JobProcessor jobProcessor) throws ContextException {
        this._processor = jobProcessor;
    }

    public void jobCompleted(String string) {
    }
}

