/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.bulkbuilder.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.bulkbuilder.helper.BulkbuilderBase;
import org.eclipse.smila.bulkbuilder.helper.BulkbuilderTaskProvider;
import org.eclipse.smila.bulkbuilder.helper.MicroBulkbuilder;
import org.eclipse.smila.bulkbuilder.internal.BulkbuilderConfig;
import org.eclipse.smila.bulkbuilder.outputs.BulkType;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.utils.conversion.DataSizeParser;

public class Bulkbuilder
extends BulkbuilderBase {
    private final BulkbuilderConfig _bulkbuilderConfig;
    private final Log _log = LogFactory.getLog(this.getClass());

    public Bulkbuilder(BulkbuilderConfig config, ObjectStoreService objectStore, BulkbuilderTaskProvider taskProvider) throws BlackboardAccessException {
        super(objectStore, taskProvider, new MicroBulkbuilder(config.getMaxParallelMicroBulks()));
        this._bulkbuilderConfig = config;
    }

    @Override
    protected long getCommitTimeoutMillis(AnyMap taskParameters) {
        long result = this._bulkbuilderConfig.getLimitTimeMillis();
        if (taskParameters.containsKey((Object)"bulkLimitTime")) {
            try {
                result = taskParameters.getLongValue("bulkLimitTime") * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                this._log.warn((Object)("Invalid value '" + taskParameters.get((Object)"bulkLimitTime") + "' for task parameter '" + "bulkLimitTime" + "'."));
            }
        }
        return result;
    }

    @Override
    protected long getBulkSizeLimit(BulkType bulkType, AnyMap taskParameters) {
        long result = 0L;
        result = this._bulkbuilderConfig.getLimitSize();
        if (taskParameters.containsKey((Object)"bulkLimitSize")) {
            try {
                result = DataSizeParser.parse((String)taskParameters.getStringValue("bulkLimitSize"));
            }
            catch (Exception exception) {
                this._log.warn((Object)("Invalid value '" + taskParameters.get((Object)"bulkLimitSize") + "' for task parameter '" + "bulkLimitSize" + "'."));
            }
        }
        return result;
    }
}

