/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.httphandler;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.WorkflowProcessor;
import org.eclipse.smila.utils.http.NotFoundHTTPResult;

public class PipelineHandler
extends JsonRequestHandler {
    public static final String EXCEPTION_MESSAGE = "There is no definition for given pipeline";
    private final Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private WorkflowProcessor _processor;

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method) || "DELETE".equals(method);
    }

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        String workflowName = this.getWorkflowName(requestUri);
        if ("DELETE".equals(method)) {
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("Deleting pipeline: " + workflowName));
            }
            this._processor.deleteWorkflowDefinition(workflowName);
            return null;
        }
        AnyMap definitionAny = this._processor.getWorkflowDefinition(workflowName);
        if (definitionAny == null) {
            throw new DefinitionNotFoundException("There is no definition for given pipeline -" + workflowName + "-.");
        }
        return definitionAny;
    }

    private String getWorkflowName(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(0);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern " + this.getUriPattern());
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof ProcessingException) {
            return ((ProcessingException)((Object)ex)).isRecoverable() ? 500 : 400;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    public void setProcessor(WorkflowProcessor processor) {
        this._processor = processor;
    }

    public void unsetProcessor(WorkflowProcessor processor) {
        if (this._processor == processor) {
            this._processor = null;
        }
    }

    private static class DefinitionNotFoundException
    extends Exception
    implements NotFoundHTTPResult {
        private static final long serialVersionUID = 1L;

        public DefinitionNotFoundException(String message) {
            super(message);
        }
    }
}

