/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rapi;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.rapi.ProcessModel;

public class Serializer {
    public static final byte[] MAGIC_NUMBER_OFH_20040908 = new byte[]{85, 53, 83, 0, 79, 70, 72, 32, 4, 9, 8};
    public static final byte[] MAGIC_NUMBER_OFH_20061101 = new byte[]{85, 53, 83, 0, 79, 70, 72, 32, 6, 17, 1};
    public static final byte[] MAGIC_NUMBER = MAGIC_NUMBER_OFH_20061101;
    public static final short FORMAT_SERIALIZED_JAVA14 = 1;
    public final byte[] magic = new byte[MAGIC_NUMBER.length];
    public short format;
    public long compileTime;
    public final int numProcesses = 1;
    public InputStream _inputStream;
    public String guid;
    public QName type;

    public Serializer(long l) {
        System.arraycopy(MAGIC_NUMBER, 0, this.magic, 0, MAGIC_NUMBER.length);
        this.format = 1;
        this.compileTime = l;
    }

    public Serializer() {
    }

    public Serializer(InputStream inputStream) throws IOException {
        this._inputStream = inputStream;
        this.read(inputStream);
    }

    public void read(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[MAGIC_NUMBER.length];
        dataInputStream.read(byArray, 0, byArray.length);
        if (Arrays.equals(MAGIC_NUMBER_OFH_20040908, byArray)) {
            ProcessModel processModel;
            this.format = dataInputStream.readShort();
            this.compileTime = dataInputStream.readLong();
            dataInputStream.readInt();
            CustomObjectInputStream customObjectInputStream = new CustomObjectInputStream(this._inputStream);
            try {
                processModel = (ProcessModel)customObjectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("DataStream Error");
            }
            this.type = processModel.getQName();
            this.guid = "OLD-FORMAT-NO-GUID";
            return;
        }
        if (Arrays.equals(MAGIC_NUMBER, byArray)) {
            this.format = dataInputStream.readShort();
            this.compileTime = dataInputStream.readLong();
            this.guid = dataInputStream.readUTF();
            String string = dataInputStream.readUTF();
            String string2 = dataInputStream.readUTF();
            this.type = new QName(string, string2);
            return;
        }
        throw new IOException("Unrecognized file format (bad magic number).");
    }

    public void writePModel(ProcessModel processModel, OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.write(MAGIC_NUMBER);
        dataOutputStream.writeShort(this.format);
        dataOutputStream.writeLong(this.compileTime);
        dataOutputStream.writeUTF(processModel.getGuid());
        dataOutputStream.writeUTF(processModel.getQName().getNamespaceURI());
        dataOutputStream.writeUTF(processModel.getQName().getLocalPart());
        dataOutputStream.flush();
        CustomObjectOutputStream customObjectOutputStream = new CustomObjectOutputStream(outputStream);
        customObjectOutputStream.writeObject(processModel);
        customObjectOutputStream.flush();
    }

    public ProcessModel readPModel() throws IOException, ClassNotFoundException {
        ProcessModel processModel;
        CustomObjectInputStream customObjectInputStream = new CustomObjectInputStream(this._inputStream);
        try {
            processModel = (ProcessModel)customObjectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("DataStream Error");
        }
        return processModel;
    }

    public String getGuid() {
        return this.guid;
    }

    public QName getType() {
        return this.type;
    }

    static class OQName
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final String local;
        final String uri;
        final String prefix;

        OQName(String string, String string2, String string3) {
            this.uri = string;
            this.local = string2;
            this.prefix = string3;
        }
    }

    static class CustomObjectInputStream
    extends ObjectInputStream {
        public CustomObjectInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
            this.enableResolveObject(true);
        }

        protected Object resolveObject(Object object) throws IOException {
            if (object instanceof OQName) {
                OQName oQName = (OQName)object;
                return new QName(oQName.uri, oQName.local, oQName.prefix);
            }
            return super.resolveObject(object);
        }

        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            ObjectStreamClass objectStreamClass = super.readClassDescriptor();
            if (objectStreamClass.getName().startsWith("org.apache.ode.bpel.o.Serializer")) {
                return ObjectStreamClass.lookup(Class.forName(objectStreamClass.getName().replace("org.apache.ode.bpel.o.Serializer", Serializer.class.getName())));
            }
            if (objectStreamClass.getName().startsWith("org.apache.ode.bpel.elang.xpath20.o.")) {
                return ObjectStreamClass.lookup(Class.forName(objectStreamClass.getName().replace("org.apache.ode.bpel.elang.xpath20.o.", "org.apache.ode.bpel.rtrep.v1.xpath20.")));
            }
            if (objectStreamClass.getName().startsWith("org.apache.ode.bpel.o.")) {
                return ObjectStreamClass.lookup(Class.forName(objectStreamClass.getName().replace("org.apache.ode.bpel.o.", "org.apache.ode.bpel.rtrep.v1.")));
            }
            return objectStreamClass;
        }
    }

    static class CustomObjectOutputStream
    extends ObjectOutputStream {
        public CustomObjectOutputStream(OutputStream outputStream) throws IOException {
            super(outputStream);
            this.enableReplaceObject(true);
        }

        protected Object replaceObject(Object object) throws IOException {
            if (object instanceof QName) {
                QName qName = (QName)object;
                return new OQName(qName.getNamespaceURI(), qName.getLocalPart(), qName.getPrefix());
            }
            return super.replaceObject(object);
        }
    }
}

