/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.access;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.store.access.DiskHashtable;
import org.apache.derby.iapi.store.access.KeyHasher;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.CloneableObject;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.PropertyUtil;

public class BackingStoreHashtable {
    private TransactionController tc;
    private HashMap hash_table;
    private int[] key_column_numbers;
    private boolean remove_duplicates;
    private boolean skipNullKeyColumns;
    private Properties auxillary_runtimestats;
    private RowSource row_source;
    private long max_inmemory_rowcnt;
    private long inmemory_rowcnt;
    private long max_inmemory_size;
    private boolean keepAfterCommit;
    private static final int ARRAY_LIST_SIZE = ClassSize.estimateBaseFromCatalog(ArrayList.class);
    private DiskHashtable diskHashtable;

    private BackingStoreHashtable() {
    }

    public BackingStoreHashtable(TransactionController tc, RowSource row_source, int[] key_column_numbers, boolean remove_duplicates, long estimated_rowcnt, long max_inmemory_rowcnt, int initialCapacity, float loadFactor, boolean skipNullKeyColumns, boolean keepAfterCommit) throws StandardException {
        this.key_column_numbers = key_column_numbers;
        this.remove_duplicates = remove_duplicates;
        this.row_source = row_source;
        this.skipNullKeyColumns = skipNullKeyColumns;
        this.max_inmemory_rowcnt = max_inmemory_rowcnt;
        this.max_inmemory_size = max_inmemory_rowcnt > 0L ? Long.MAX_VALUE : Runtime.getRuntime().totalMemory() / 100L;
        this.tc = tc;
        this.keepAfterCommit = keepAfterCommit;
        if (initialCapacity != -1) {
            this.hash_table = loadFactor == -1.0f ? new HashMap(initialCapacity) : new HashMap(initialCapacity, loadFactor);
        } else {
            HashMap hashMap = estimated_rowcnt <= 0L || row_source == null ? new HashMap() : (this.hash_table = estimated_rowcnt < this.max_inmemory_size ? new HashMap((int)estimated_rowcnt) : null);
        }
        if (row_source != null) {
            DataValueDescriptor[] row;
            boolean needsToClone = row_source.needsToClone();
            while ((row = this.getNextRowFromRowSource()) != null) {
                if (this.hash_table == null) {
                    double rowUsage = this.getEstimatedMemUsage(row);
                    this.hash_table = new HashMap((int)((double)this.max_inmemory_size / rowUsage));
                }
                this.add_row_to_hash_table(row, needsToClone);
            }
        }
        if (this.hash_table == null) {
            this.hash_table = new HashMap();
        }
    }

    private DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        DataValueDescriptor[] row = this.row_source.getNextRowFromRowSource();
        if (this.skipNullKeyColumns) {
            while (row != null) {
                int index;
                for (index = 0; index < this.key_column_numbers.length && !row[this.key_column_numbers[index]].isNull(); ++index) {
                }
                if (index == this.key_column_numbers.length) {
                    return row;
                }
                row = this.row_source.getNextRowFromRowSource();
            }
        }
        return row;
    }

    private static DataValueDescriptor[] cloneRow(DataValueDescriptor[] old_row) throws StandardException {
        DataValueDescriptor[] new_row = new DataValueDescriptor[old_row.length];
        for (int i = 0; i < old_row.length; ++i) {
            if (old_row[i] == null) continue;
            new_row[i] = old_row[i].getClone();
        }
        return new_row;
    }

    static DataValueDescriptor[] shallowCloneRow(DataValueDescriptor[] old_row) throws StandardException {
        DataValueDescriptor[] new_row = new DataValueDescriptor[old_row.length];
        for (int i = 0; i < old_row.length; ++i) {
            if (old_row[i] == null) continue;
            new_row[i] = (DataValueDescriptor)((CloneableObject)((Object)old_row[i])).cloneObject();
        }
        return new_row;
    }

    private void add_row_to_hash_table(DataValueDescriptor[] row, boolean needsToClone) throws StandardException {
        if (this.spillToDisk(row)) {
            return;
        }
        if (needsToClone) {
            row = BackingStoreHashtable.cloneRow(row);
        }
        Object key = KeyHasher.buildHashKey(row, this.key_column_numbers);
        DataValueDescriptor[] duplicate_value = null;
        duplicate_value = this.hash_table.put(key, row);
        if (duplicate_value == null) {
            this.doSpaceAccounting(row, false);
        } else if (!this.remove_duplicates) {
            List<DataValueDescriptor[]> row_vec;
            if (duplicate_value instanceof List) {
                this.doSpaceAccounting(row, false);
                row_vec = (List)duplicate_value;
            } else {
                row_vec = new ArrayList<DataValueDescriptor[]>(2);
                row_vec.add(duplicate_value);
                this.doSpaceAccounting(row, true);
            }
            row_vec.add(row);
            this.hash_table.put(key, row_vec);
        }
        row = null;
    }

    private void doSpaceAccounting(DataValueDescriptor[] row, boolean firstDuplicate) {
        ++this.inmemory_rowcnt;
        if (this.max_inmemory_rowcnt <= 0L) {
            this.max_inmemory_size -= this.getEstimatedMemUsage(row);
            if (firstDuplicate) {
                this.max_inmemory_size -= (long)ARRAY_LIST_SIZE;
            }
        }
    }

    private boolean spillToDisk(DataValueDescriptor[] row) throws StandardException {
        Object key;
        Object duplicateValue;
        if (this.diskHashtable == null) {
            if (this.max_inmemory_rowcnt > 0L ? this.inmemory_rowcnt < this.max_inmemory_rowcnt : this.max_inmemory_size > this.getEstimatedMemUsage(row)) {
                return false;
            }
            this.diskHashtable = new DiskHashtable(this.tc, row, null, this.key_column_numbers, this.remove_duplicates, this.keepAfterCommit);
        }
        if ((duplicateValue = this.hash_table.get(key = KeyHasher.buildHashKey(row, this.key_column_numbers))) != null) {
            if (this.remove_duplicates) {
                return true;
            }
            if (duplicateValue instanceof List) {
                List duplicateVec = (List)duplicateValue;
                for (int i = duplicateVec.size() - 1; i >= 0; --i) {
                    Object[] dupRow = (DataValueDescriptor[])duplicateVec.get(i);
                    this.diskHashtable.put(key, dupRow);
                }
            } else {
                this.diskHashtable.put(key, (DataValueDescriptor[])duplicateValue);
            }
            this.hash_table.remove(key);
        }
        this.diskHashtable.put(key, row);
        return true;
    }

    private long getEstimatedMemUsage(DataValueDescriptor[] row) {
        long rowMem = 0L;
        for (int i = 0; i < row.length; ++i) {
            rowMem += (long)row[i].estimateMemoryUsage();
            rowMem += (long)ClassSize.refSize;
        }
        return rowMem += (long)ClassSize.refSize;
    }

    public void close() throws StandardException {
        this.hash_table = null;
        if (this.diskHashtable != null) {
            this.diskHashtable.close();
            this.diskHashtable = null;
        }
    }

    public Enumeration elements() throws StandardException {
        if (this.diskHashtable == null) {
            return Collections.enumeration(this.hash_table.values());
        }
        return new BackingStoreHashtableEnumeration();
    }

    public Object get(Object key) throws StandardException {
        Object obj = this.hash_table.get(key);
        if (this.diskHashtable == null || obj != null) {
            return obj;
        }
        return this.diskHashtable.get(key);
    }

    public void getAllRuntimeStats(Properties prop) throws StandardException {
        if (this.auxillary_runtimestats != null) {
            PropertyUtil.copyProperties(this.auxillary_runtimestats, prop);
        }
    }

    public Object remove(Object key) throws StandardException {
        Object obj = this.hash_table.remove(key);
        if (obj != null || this.diskHashtable == null) {
            return obj;
        }
        return this.diskHashtable.remove(key);
    }

    public void setAuxillaryRuntimeStats(Properties prop) throws StandardException {
        this.auxillary_runtimestats = prop;
    }

    public boolean putRow(boolean needsToClone, DataValueDescriptor[] row) throws StandardException {
        if (this.skipNullKeyColumns) {
            for (int index = 0; index < this.key_column_numbers.length; ++index) {
                if (!row[this.key_column_numbers[index]].isNull()) continue;
                return false;
            }
        }
        Object key = KeyHasher.buildHashKey(row, this.key_column_numbers);
        if (this.remove_duplicates && this.get(key) != null) {
            return false;
        }
        this.add_row_to_hash_table(row, needsToClone);
        return true;
    }

    public int size() throws StandardException {
        if (this.diskHashtable == null) {
            return this.hash_table.size();
        }
        return this.hash_table.size() + this.diskHashtable.size();
    }

    private class BackingStoreHashtableEnumeration
    implements Enumeration {
        private Iterator memoryIterator;
        private Enumeration diskEnumeration;

        BackingStoreHashtableEnumeration() {
            this.memoryIterator = BackingStoreHashtable.this.hash_table.values().iterator();
            if (BackingStoreHashtable.this.diskHashtable != null) {
                try {
                    this.diskEnumeration = BackingStoreHashtable.this.diskHashtable.elements();
                }
                catch (StandardException se) {
                    this.diskEnumeration = null;
                }
            }
        }

        public boolean hasMoreElements() {
            if (this.memoryIterator != null) {
                if (this.memoryIterator.hasNext()) {
                    return true;
                }
                this.memoryIterator = null;
            }
            if (this.diskEnumeration == null) {
                return false;
            }
            return this.diskEnumeration.hasMoreElements();
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.memoryIterator != null) {
                if (this.memoryIterator.hasNext()) {
                    return this.memoryIterator.next();
                }
                this.memoryIterator = null;
            }
            return this.diskEnumeration.nextElement();
        }
    }
}

