/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.heap;

import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.conglomerate.Conglomerate;
import org.apache.derby.iapi.store.access.conglomerate.ConglomerateFactory;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.heap.Heap;
import org.apache.derby.impl.store.access.heap.Heap_v10_2;

public class HeapConglomerateFactory
implements ConglomerateFactory,
ModuleControl,
ModuleSupportable {
    private static final String IMPLEMENTATIONID = "heap";
    private static final String FORMATUUIDSTRING = "D2976090-D9F5-11d0-B54D-00A024BF8878";
    private UUID formatUUID;

    public Properties defaultProperties() {
        return new Properties();
    }

    public boolean supportsImplementation(String implementationId) {
        return implementationId.equals(IMPLEMENTATIONID);
    }

    public String primaryImplementationType() {
        return IMPLEMENTATIONID;
    }

    public boolean supportsFormat(UUID formatid) {
        return formatid.equals(this.formatUUID);
    }

    public UUID primaryFormat() {
        return this.formatUUID;
    }

    public int getConglomerateFactoryId() {
        return 0;
    }

    public Conglomerate createConglomerate(TransactionManager xact_mgr, int segment, long input_containerid, DataValueDescriptor[] template, ColumnOrdering[] columnOrder, int[] collationIds, Properties properties, int temporaryFlag) throws StandardException {
        Heap heap = null;
        heap = xact_mgr.checkVersion(10, 3, null) ? new Heap() : new Heap_v10_2();
        heap.create(xact_mgr.getRawStoreXact(), segment, input_containerid, template, columnOrder, collationIds, properties, heap.getTypeFormatId(), temporaryFlag);
        return heap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conglomerate readConglomerate(TransactionManager xact_mgr, ContainerKey container_key) throws StandardException {
        ContainerHandle container = null;
        Page page = null;
        Object[] control_row = new DataValueDescriptor[1];
        try {
            container = xact_mgr.getRawStoreXact().openContainer(container_key, null, 0);
            if (container == null) {
                throw StandardException.newException("XSAI2.S", new Long(container_key.getContainerId()));
            }
            control_row[0] = new Heap();
            page = container.getPage(1L);
            RecordHandle rh = page.fetchFromSlot(null, 0, control_row, null, true);
            SanityManager.ASSERT(rh != null);
            SanityManager.ASSERT(rh.getId() == 6);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            if (container != null) {
                container.close();
            }
        }
        return (Conglomerate)control_row[0];
    }

    public boolean canSupport(Properties startParams) {
        String impl = startParams.getProperty("derby.access.Conglomerate.type");
        if (impl == null) {
            return false;
        }
        return this.supportsImplementation(impl);
    }

    public void boot(boolean create, Properties startParams) throws StandardException {
        UUIDFactory uuidFactory = Monitor.getMonitor().getUUIDFactory();
        this.formatUUID = uuidFactory.recreateUUID(FORMATUUIDSTRING);
    }

    public void stop() {
    }
}

