/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.definitions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.eclipse.smila.common.exceptions.InvalidDefinitionException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;

public enum JobRunMode {
    STANDARD("standard"),
    RUNONCE("runOnce");

    public static final List<JobRunMode> ALL_MODES;
    private final String _mode;

    static {
        ALL_MODES = Arrays.asList(STANDARD, RUNONCE);
    }

    private JobRunMode(String n2) {
        this._mode = n2;
    }

    public String toString() {
        return this._mode;
    }

    public static List<JobRunMode> parseModes(AnySeq modesAny) throws InvalidDefinitionException {
        if (modesAny == null || modesAny.isEmpty()) {
            return null;
        }
        ArrayList<JobRunMode> modes = new ArrayList<JobRunMode>(modesAny.size());
        for (Any any : modesAny) {
            if (any.isValue()) {
                String modeName = any.asValue().asString();
                try {
                    modes.add(JobRunMode.valueOf(modeName.toUpperCase(Locale.ENGLISH)));
                    continue;
                }
                catch (Exception exception) {
                    throw new InvalidDefinitionException("Modes list contains invalid value '" + modeName + "'");
                }
            }
            throw new InvalidDefinitionException("Modes list contains non-value objects.");
        }
        return modes;
    }

    public static AnySeq toAny(Collection<JobRunMode> modes) {
        AnySeq modesAny = DataFactory.DEFAULT.createAnySeq();
        for (JobRunMode mode : modes) {
            modesAny.add(mode.toString());
        }
        return modesAny;
    }
}

