/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.common.exceptions.InvalidDefinitionException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.ipc.IpcAnyReader;
import org.eclipse.smila.jobmanager.definitions.BucketDefinition;
import org.eclipse.smila.jobmanager.definitions.DataObjectTypeDefinition;
import org.eclipse.smila.jobmanager.definitions.DefinitionPersistence;
import org.eclipse.smila.jobmanager.definitions.JobDefinition;
import org.eclipse.smila.jobmanager.definitions.WorkerDefinition;
import org.eclipse.smila.jobmanager.definitions.WorkflowDefinition;
import org.eclipse.smila.jobmanager.exceptions.IllegalJobStateException;
import org.eclipse.smila.jobmanager.exceptions.InvalidConfigException;
import org.eclipse.smila.jobmanager.exceptions.JobManagerException;
import org.eclipse.smila.jobmanager.exceptions.PersistenceException;
import org.eclipse.smila.jobmanager.internal.DefinitionAccessor;
import org.eclipse.smila.jobmanager.internal.DefinitionValidator;
import org.eclipse.smila.jobmanager.persistence.PermanentStorage;
import org.eclipse.smila.jobmanager.persistence.RunStorage;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGeneratorProvider;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.eclipse.smila.utils.config.ConfigurationLoadException;

public class DefinitionPersistenceImpl
implements DefinitionPersistence {
    private static final String FILENAME_PREDEFINED_BUCKETS = "buckets.json";
    private static final String FILENAME_PREDEFINED_DATA_OBJECT_TYPES = "dataObjectTypes.json";
    private static final String FILENAME_PREDEFINED_WORKERS = "workers.json";
    private static final String FILENAME_PREDEFINED_WORKFLOWS = "workflows.json";
    private static final String FILENAME_PREDEFINED_JOBS = "jobs.json";
    private final Log _log = LogFactory.getLog(this.getClass());
    private final IpcAnyReader _anyReader = new IpcAnyReader();
    private DefinitionAccessor _definitionAccessor;
    private DefinitionValidator _definitionValidator;
    private RunStorage _runStorage;
    private PermanentStorage _permStorage;
    private TaskGeneratorProvider _taskGeneratorProvider;
    private ObjectStoreService _objectStore;
    private boolean _hasReadConfiguredJobs;

    protected void activate() {
        try {
            this._definitionAccessor = new DefinitionAccessor();
            this._definitionValidator = new DefinitionValidator(this._definitionAccessor, this._taskGeneratorProvider, this._objectStore);
            this.readConfiguredDataObjectTypeDefinitions();
            this.readConfiguredBucketDefinitions();
            this.readConfiguredWorkerDefinitions();
            this.readConfiguredWorkflowDefinitions();
            this._definitionAccessor.setStorage(this._permStorage);
        }
        catch (RuntimeException ex) {
            this._log.error((Object)"Activation of JobManager's DefinitionPersistence fails.", (Throwable)ex);
            System.exit(0);
            throw new IllegalStateException("Activation of JobManager's DefinitionPersistence fails: " + ex.toString(), ex);
        }
    }

    @Override
    public Collection<String> getDataObjectTypes() {
        return this._definitionAccessor.getDataObjectTypes();
    }

    @Override
    public DataObjectTypeDefinition getDataObjectType(String name) {
        return this._definitionAccessor.getDataObjectType(name);
    }

    @Override
    public Collection<String> getWorkers() {
        return this._definitionAccessor.getWorkers();
    }

    @Override
    public WorkerDefinition getWorker(String name) {
        return this._definitionAccessor.getWorker(name);
    }

    @Override
    public Collection<String> getBuckets() throws PersistenceException {
        return this._definitionAccessor.getBuckets();
    }

    @Override
    public BucketDefinition getBucket(String name) throws PersistenceException {
        return this._definitionAccessor.getBucket(name);
    }

    @Override
    public void addBucket(BucketDefinition bucketDefinition) throws PersistenceException, InvalidConfigException {
        this._definitionValidator.validateBucket(bucketDefinition);
        this._definitionValidator.validateBucketWorkflows(bucketDefinition);
        this._permStorage.addBucket(bucketDefinition);
    }

    @Override
    public void removeBucket(String name) throws PersistenceException, InvalidConfigException {
        this._definitionValidator.checkRemoveBucket(name);
        this._permStorage.removeBucket(name);
    }

    @Override
    public Collection<String> getJobs() throws PersistenceException {
        this.readConfiguredJobDefinitions();
        return this._definitionAccessor.getJobs();
    }

    @Override
    public JobDefinition getJob(String name) throws PersistenceException {
        this.readConfiguredJobDefinitions();
        return this._definitionAccessor.getJob(name);
    }

    @Override
    public boolean hasJob(String jobName) throws PersistenceException {
        return this.getJob(jobName) != null;
    }

    @Override
    public void removeJob(String name) throws PersistenceException, IllegalJobStateException {
        try {
            if (this._runStorage.getJobRunInfo(name) != null) {
                throw new IllegalJobStateException("Job '" + name + "' cannot be removed, it is still running.");
            }
            this._definitionValidator.checkJobRemove(name);
        }
        catch (IllegalJobStateException e) {
            throw e;
        }
        catch (JobManagerException e) {
            throw new PersistenceException("Exception while checking job '" + name + "' for deletion.", (Throwable)((Object)e));
        }
        this._permStorage.removeJob(name);
    }

    @Override
    public void addJob(JobDefinition jobDefinition) throws PersistenceException, InvalidConfigException {
        this._definitionValidator.validateJob(jobDefinition);
        this._permStorage.addJob(jobDefinition);
    }

    @Override
    public Collection<String> getWorkflows() throws PersistenceException {
        return this._definitionAccessor.getWorkflows();
    }

    @Override
    public WorkflowDefinition getWorkflow(String name) throws PersistenceException {
        return this._definitionAccessor.getWorkflow(name);
    }

    @Override
    public void removeWorkflow(String name) throws PersistenceException, InvalidConfigException {
        this._definitionValidator.checkRemoveWorkflow(name);
        this._permStorage.removeWorkflow(name);
    }

    @Override
    public void addWorkflow(WorkflowDefinition workflowDefinition) throws PersistenceException, InvalidConfigException {
        this._definitionValidator.validateWorkflow(workflowDefinition);
        this._permStorage.addWorkflow(workflowDefinition);
    }

    /*
     * Loose catch block
     */
    private void readConfiguredBucketDefinitions() {
        try {
            InputStream bucketsJson = ConfigUtils.getConfigStream((String)"org.eclipse.smila.jobmanager", (String)FILENAME_PREDEFINED_BUCKETS);
            try {
                try {
                    AnyMap bucketsAny = (AnyMap)this._anyReader.readJsonStream(bucketsJson);
                    Collection<BucketDefinition> buckets = this.parsePredefinedBuckets(bucketsAny);
                    HashMap<String, BucketDefinition> configuredBuckets = new HashMap<String, BucketDefinition>();
                    for (BucketDefinition bucket : buckets) {
                        if (configuredBuckets.containsKey(bucket.getName())) {
                            this._log.warn((Object)("Configuration contains duplicate bucket definition '" + bucket.getName() + "', ignoring second one."));
                            continue;
                        }
                        try {
                            this._definitionValidator.validateBucket(bucket);
                            configuredBuckets.put(bucket.getName(), bucket);
                        }
                        catch (InvalidConfigException ex) {
                            this._log.warn((Object)("Configuration contains invalid bucket definition for bucket '" + bucket.getName() + "'"), (Throwable)((Object)ex));
                        }
                    }
                    this._definitionAccessor.setConfiguredBuckets(configuredBuckets);
                }
                catch (IOException ex) {
                    this._log.warn((Object)"Error reading predefined buckets from configuration area, no predefined buckets available.", (Throwable)ex);
                    IOUtils.closeQuietly((InputStream)bucketsJson);
                }
                catch (PersistenceException ex) {
                    this._log.warn((Object)"Error reading predefined buckets from configuration area, no predefined buckets available.", (Throwable)((Object)ex));
                    IOUtils.closeQuietly((InputStream)bucketsJson);
                }
                catch (InvalidDefinitionException e) {
                    this._log.warn((Object)"Error parsing predefined bucket definitions from configuration area", (Throwable)e);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)bucketsJson);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)bucketsJson);
            }
        }
        catch (ConfigurationLoadException configurationLoadException) {
            this._log.info((Object)"No predefined buckets found in configuration area.");
        }
    }

    private void readConfiguredDataObjectTypeDefinitions() {
        try {
            InputStream dotJson = ConfigUtils.getConfigStream((String)"org.eclipse.smila.jobmanager", (String)FILENAME_PREDEFINED_DATA_OBJECT_TYPES);
            try {
                try {
                    AnyMap dotMap = (AnyMap)this._anyReader.readJsonStream(dotJson);
                    Collection<DataObjectTypeDefinition> dots = this.parsePredefinedDataObjectTypes(dotMap);
                    HashMap<String, DataObjectTypeDefinition> configuredDataObjectTypes = new HashMap<String, DataObjectTypeDefinition>();
                    for (DataObjectTypeDefinition dot : dots) {
                        configuredDataObjectTypes.put(dot.getName(), dot);
                    }
                    this._definitionAccessor.setConfiguredDataObjectTypes(configuredDataObjectTypes);
                }
                catch (IOException ex) {
                    this._log.warn((Object)"Error reading predefined data object type definitions from configuration area, no predefined data object type definitions available.", (Throwable)ex);
                    IOUtils.closeQuietly((InputStream)dotJson);
                }
                catch (InvalidDefinitionException e) {
                    this._log.warn((Object)"Error parsing predefined data object type definitions from configuration area", (Throwable)e);
                    IOUtils.closeQuietly((InputStream)dotJson);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)dotJson);
            }
        }
        catch (ConfigurationLoadException configurationLoadException) {
            this._log.info((Object)"No predefined data object types found in configuration area.");
        }
    }

    private void readConfiguredWorkerDefinitions() {
        try {
            InputStream workerJson = ConfigUtils.getConfigStream((String)"org.eclipse.smila.jobmanager", (String)FILENAME_PREDEFINED_WORKERS);
            try {
                try {
                    AnyMap workerMap = (AnyMap)this._anyReader.readJsonStream(workerJson);
                    Collection<WorkerDefinition> workers = this.parsePredefinedWorkers(workerMap);
                    HashMap<String, WorkerDefinition> configuredWorkers = new HashMap<String, WorkerDefinition>();
                    for (WorkerDefinition worker : workers) {
                        configuredWorkers.put(worker.getName(), worker);
                    }
                    this._definitionAccessor.setConfiguredWorkers(configuredWorkers);
                }
                catch (IOException ex) {
                    this._log.warn((Object)"Error reading predefined worker definitions from configuration area, no predefined worker definitions available.", (Throwable)ex);
                    IOUtils.closeQuietly((InputStream)workerJson);
                }
                catch (InvalidDefinitionException e) {
                    this._log.warn((Object)"Error parsing predefined worker definitions from configuration area", (Throwable)e);
                    IOUtils.closeQuietly((InputStream)workerJson);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)workerJson);
            }
        }
        catch (ConfigurationLoadException configurationLoadException) {
            this._log.info((Object)"No predefined workers found in configuration area.");
        }
    }

    private void readConfiguredWorkflowDefinitions() {
        try {
            InputStream workflowsJson = ConfigUtils.getConfigStream((String)"org.eclipse.smila.jobmanager", (String)FILENAME_PREDEFINED_WORKFLOWS);
            try {
                try {
                    AnyMap workflowsAnyMap = (AnyMap)this._anyReader.readJsonStream(workflowsJson);
                    Collection<WorkflowDefinition> workflows = this.parsePredefinedWorflows(workflowsAnyMap);
                    HashMap<String, WorkflowDefinition> configuredWorkflows = new HashMap<String, WorkflowDefinition>();
                    for (WorkflowDefinition workflow : workflows) {
                        if (configuredWorkflows.containsKey(workflow.getName())) {
                            this._log.warn((Object)("Configuration contains duplicate workflow definition '" + workflow.getName() + "', ignoring second one."));
                            continue;
                        }
                        try {
                            this._definitionValidator.validateWorkflow(workflow);
                            configuredWorkflows.put(workflow.getName(), workflow);
                        }
                        catch (InvalidConfigException ex) {
                            this._log.warn((Object)("Configuration contains invalid workflow definition for workflow '" + workflow.getName() + "'."), (Throwable)((Object)ex));
                        }
                        catch (PersistenceException e) {
                            this._log.warn((Object)("Error while trying to validate workflow '" + workflow.getName() + "'."), (Throwable)((Object)e));
                        }
                    }
                    this._definitionAccessor.setConfiguredWorkflows(configuredWorkflows);
                }
                catch (IOException ex) {
                    this._log.warn((Object)"Error reading predefined workflows from configuration area, no predefined workflows available.", (Throwable)ex);
                    IOUtils.closeQuietly((InputStream)workflowsJson);
                }
                catch (InvalidDefinitionException e) {
                    this._log.warn((Object)"Error parsing predefined workflows from configuration area", (Throwable)e);
                    IOUtils.closeQuietly((InputStream)workflowsJson);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)workflowsJson);
            }
        }
        catch (ConfigurationLoadException configurationLoadException) {
            this._log.info((Object)"No predefined workflows found in configuration area.");
        }
    }

    private synchronized void readConfiguredJobDefinitions() {
        if (!this._hasReadConfiguredJobs) {
            block15: {
                try {
                    InputStream jobsJson = ConfigUtils.getConfigStream((String)"org.eclipse.smila.jobmanager", (String)FILENAME_PREDEFINED_JOBS);
                    try {
                        AnyMap jobsAny = (AnyMap)this._anyReader.readJsonStream(jobsJson);
                        Collection<JobDefinition> jobs = this.parsePredefinedJobs(jobsAny);
                        HashMap<String, JobDefinition> configuredJobs = new HashMap<String, JobDefinition>();
                        for (JobDefinition job : jobs) {
                            if (configuredJobs.containsKey(job.getName())) {
                                this._log.warn((Object)("Configuration contains duplicate job definition '" + job.getName() + "', ignoring second one."));
                                continue;
                            }
                            try {
                                this._definitionValidator.validateJob(job);
                                configuredJobs.put(job.getName(), job);
                            }
                            catch (InvalidConfigException ex) {
                                this._log.warn((Object)("Configuration contains invalid job definition for job '" + job.getName() + "'."), (Throwable)((Object)ex));
                            }
                            catch (PersistenceException e) {
                                this._log.warn((Object)("Error while trying to validate job '" + job.getName() + "'."), (Throwable)((Object)e));
                            }
                        }
                        this._definitionAccessor.setConfiguredJobs(configuredJobs);
                    }
                    catch (IOException ex) {
                        this._log.warn((Object)"Error reading predefined jobs from configuration area, no predefined jobs available.", (Throwable)ex);
                        IOUtils.closeQuietly((InputStream)jobsJson);
                        break block15;
                    }
                    catch (InvalidDefinitionException e) {
                        try {
                            this._log.warn((Object)"Error parsing predefined jobs from configuration area", (Throwable)e);
                            break block15;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)jobsJson);
                        }
                    }
                    IOUtils.closeQuietly((InputStream)jobsJson);
                }
                catch (ConfigurationLoadException configurationLoadException) {
                    this._log.info((Object)"No predefined jobs found in configuration area.");
                }
            }
            this._hasReadConfiguredJobs = true;
        }
    }

    private Collection<BucketDefinition> parsePredefinedBuckets(AnyMap bucketsAny) throws InvalidDefinitionException {
        ArrayList<BucketDefinition> buckets;
        block7: {
            buckets = new ArrayList<BucketDefinition>();
            try {
                if (bucketsAny.containsKey((Object)"buckets")) {
                    for (Any bucketAny : bucketsAny.getSeq("buckets")) {
                        if (!bucketAny.isMap()) continue;
                        bucketAny.asMap().put("readOnly", Boolean.valueOf(true));
                        try {
                            buckets.add(new BucketDefinition((AnyMap)bucketAny));
                        }
                        catch (InvalidDefinitionException ex) {
                            this._log.warn((Object)("Configuration contains invalid bucket definition for bucket '" + bucketAny.asMap().getStringValue("name") + "'."), (Throwable)ex);
                        }
                    }
                    break block7;
                }
                throw new InvalidDefinitionException("Missing field buckets");
            }
            catch (InvalidDefinitionException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new InvalidDefinitionException("Invalid any structure", (Throwable)ex);
            }
        }
        return buckets;
    }

    private Collection<DataObjectTypeDefinition> parsePredefinedDataObjectTypes(AnyMap dotMap) throws InvalidDefinitionException {
        try {
            ArrayList<DataObjectTypeDefinition> dataObjectTypeDefinitions = new ArrayList<DataObjectTypeDefinition>();
            if (dotMap.containsKey((Object)"dataObjectTypes")) {
                for (Any dataObjectTypeDefinitionAny : dotMap.getSeq("dataObjectTypes")) {
                    if (!dataObjectTypeDefinitionAny.isMap()) continue;
                    dataObjectTypeDefinitionAny.asMap().put("readOnly", Boolean.valueOf(true));
                    try {
                        dataObjectTypeDefinitions.add(new DataObjectTypeDefinition((AnyMap)dataObjectTypeDefinitionAny));
                    }
                    catch (InvalidDefinitionException ex) {
                        this._log.warn((Object)("Configuration contains invalid data objetc type definition for data object type '" + dataObjectTypeDefinitionAny.asMap().getStringValue("name") + "'."), (Throwable)ex);
                    }
                }
            } else {
                throw new InvalidDefinitionException("Missing field: dataObjectTypes");
            }
            return dataObjectTypeDefinitions;
        }
        catch (InvalidDefinitionException ice) {
            throw ice;
        }
        catch (Exception e) {
            throw new InvalidDefinitionException("Error during reading dataObjectTypeDefinitionAny: " + e.getLocalizedMessage());
        }
    }

    private Collection<WorkerDefinition> parsePredefinedWorkers(AnyMap workerMap) throws InvalidDefinitionException {
        try {
            ArrayList<WorkerDefinition> workerDefinitions = new ArrayList<WorkerDefinition>();
            if (workerMap.containsKey((Object)"workers")) {
                for (Any workerDefinitionAny : workerMap.getSeq("workers")) {
                    if (!workerDefinitionAny.isMap()) continue;
                    workerDefinitionAny.asMap().put("readOnly", Boolean.valueOf(true));
                    try {
                        workerDefinitions.add(new WorkerDefinition((AnyMap)workerDefinitionAny));
                    }
                    catch (InvalidDefinitionException ex) {
                        this._log.warn((Object)("Configuration contains invalid worker definition for worker '" + workerDefinitionAny.asMap().getStringValue("name") + "'."), (Throwable)ex);
                    }
                }
            } else {
                throw new InvalidDefinitionException("Missing field: workers");
            }
            return workerDefinitions;
        }
        catch (InvalidDefinitionException ice) {
            throw ice;
        }
        catch (Exception e) {
            throw new InvalidDefinitionException("Error during reading workerDefinitionsRecordAny ", (Throwable)e);
        }
    }

    private Collection<WorkflowDefinition> parsePredefinedWorflows(AnyMap workflowsAny) throws InvalidDefinitionException {
        ArrayList<WorkflowDefinition> workflows;
        block7: {
            workflows = new ArrayList<WorkflowDefinition>();
            try {
                if (workflowsAny.containsKey((Object)"workflows")) {
                    for (Any workflowAny : workflowsAny.getSeq("workflows")) {
                        if (!workflowAny.isMap()) continue;
                        workflowAny.asMap().put("readOnly", Boolean.valueOf(true));
                        try {
                            workflows.add(new WorkflowDefinition((AnyMap)workflowAny));
                        }
                        catch (InvalidDefinitionException ex) {
                            this._log.warn((Object)("Configuration contains invalid workflow definition for workflow '" + workflowAny.asMap().getStringValue("name") + "'."), (Throwable)ex);
                        }
                    }
                    break block7;
                }
                throw new InvalidConfigException("Missing field workflows");
            }
            catch (InvalidDefinitionException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new InvalidDefinitionException("Invalid any structure", (Throwable)ex);
            }
        }
        return workflows;
    }

    private Collection<JobDefinition> parsePredefinedJobs(AnyMap jobsAny) throws InvalidDefinitionException {
        ArrayList<JobDefinition> jobs = new ArrayList<JobDefinition>();
        if (jobsAny.containsKey((Object)"jobs")) {
            for (Any jobAny : jobsAny.getSeq("jobs")) {
                if (jobAny.isMap()) {
                    jobAny.asMap().put("readOnly", Boolean.valueOf(true));
                    try {
                        jobs.add(new JobDefinition(jobAny.asMap()));
                    }
                    catch (InvalidDefinitionException ex) {
                        this._log.warn((Object)("Configuration contains invalid job definition for job '" + jobAny.asMap().getStringValue("name") + "'."), (Throwable)ex);
                    }
                    continue;
                }
                throw new InvalidDefinitionException("Invalid any structure.");
            }
        } else {
            throw new InvalidDefinitionException("Missing field jobs");
        }
        return jobs;
    }

    public void setPermanentStorage(PermanentStorage permStorage) {
        this._permStorage = permStorage;
    }

    public void unsetPermanentStorage(PermanentStorage permStorage) {
        if (this._permStorage == permStorage) {
            this._permStorage = null;
        }
    }

    public void setRunStorage(RunStorage runStorage) {
        this._runStorage = runStorage;
    }

    public void unsetRunStorage(RunStorage runStorage) {
        if (this._runStorage == runStorage) {
            this._runStorage = null;
        }
    }

    public void setObjectStoreService(ObjectStoreService objectStore) {
        this._objectStore = objectStore;
    }

    public void unsetObjectStoreService(ObjectStoreService objectStore) {
        if (this._objectStore == objectStore) {
            this._objectStore = null;
        }
    }

    public void setTaskGeneratorProvider(TaskGeneratorProvider taskGeneratorProvider) {
        this._taskGeneratorProvider = taskGeneratorProvider;
    }

    public void unsetTaskGeneratorProvider(TaskGeneratorProvider taskGeneratorProvider) {
        if (this._taskGeneratorProvider == taskGeneratorProvider) {
            this._taskGeneratorProvider = null;
        }
    }
}

