/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskmanager.httphandler;

import java.util.List;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.taskmanager.BadParameterTaskmanagerException;
import org.eclipse.smila.taskmanager.TaskManager;

public class TaskPathStateHandler
extends JsonRequestHandler {
    private TaskManager _taskManager;

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        if ("GET".equals(method)) {
            String workerName = this.getWorkerName(requestUri);
            String section = this.getSection(requestUri);
            String taskName = this.getTaskName(requestUri);
            return this._taskManager.getTaskInfo(workerName, section, taskName);
        }
        return null;
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof IllegalArgumentException) {
            return 400;
        }
        if (ex.getCause() != null && ex.getCause() instanceof BadParameterTaskmanagerException) {
            return 404;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    private String getWorkerName(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(0);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
    }

    private String getSection(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(1);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
    }

    private String getTaskName(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        StringBuilder taskName = new StringBuilder();
        if (uriParts.size() > 2 && uriParts.get(2) != null) {
            taskName.append((String)uriParts.get(2));
        }
        if (uriParts.size() > 3 && uriParts.get(3) != null) {
            taskName.append((String)uriParts.get(3));
        }
        if (taskName.length() > 0) {
            return taskName.toString();
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method);
    }

    public void setTaskManager(TaskManager taskManager) {
        this._taskManager = taskManager;
    }

    public void unsetTaskManager(TaskManager taskManager) {
        if (this._taskManager == taskManager) {
            this._taskManager = null;
        }
    }
}

