/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.management;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.management.LocatedManagementAgent;
import org.eclipse.smila.management.ManagementAgent;
import org.eclipse.smila.management.ManagementAgentLocation;
import org.eclipse.smila.management.ManagementAgentNotFoundException;
import org.eclipse.smila.management.ManagementCategory;
import org.eclipse.smila.management.RegistrationException;
import org.eclipse.smila.management.activator.Activator;
import org.eclipse.smila.management.controller.ManagementController;
import org.eclipse.smila.management.internal.ManagementCategoryImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public final class ManagementRegistration {
    public static final ManagementRegistration INSTANCE = new ManagementRegistration();
    private final Log _log = LogFactory.getLog(ManagementRegistration.class);
    private final BundleContext _context;
    private final ManagementServiceTracker _managementServiceTracker;
    private final Object _monitor = new Object();
    private final Map<ManagementAgentLocation, ManagementAgent> _agents = new HashMap<ManagementAgentLocation, ManagementAgent>();
    private final Set<ServiceReference> _controllers = new HashSet<ServiceReference>();

    private ManagementRegistration() {
        this._context = Activator.getInstance().getBundleContext();
        this._managementServiceTracker = new ManagementServiceTracker(this._context);
        this._managementServiceTracker.open();
    }

    private void log(String text) {
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)String.format("[Management Registration] %s", text));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAgent(ManagementAgentLocation location, ManagementAgent agent) {
        this.log(String.format("Registering new agent [%s]", location.getPath()));
        Object object = this._monitor;
        synchronized (object) {
            Iterator<ServiceReference> iterator = this._controllers.iterator();
            while (iterator.hasNext()) {
                ServiceReference reference = iterator.next();
                ManagementController controller = (ManagementController)this._context.getService(reference);
                if (controller != null) {
                    try {
                        this.log(String.format("Registering new agent [%s] in old controller [%s]", location.getPath(), controller.getClass().getName()));
                        controller.registerAgent(location, agent);
                    }
                    catch (RegistrationException exception) {
                        this._log.error((Object)String.format("Error registering agent [%s]", location.getPath()), (Throwable)exception);
                    }
                    continue;
                }
                iterator.remove();
            }
            this._agents.put(location, agent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAgent(ManagementAgentLocation location) {
        this.log(String.format("Unregistering agent [%s]", location));
        Object object = this._monitor;
        synchronized (object) {
            Iterator<ServiceReference> iterator = this._controllers.iterator();
            while (iterator.hasNext()) {
                ServiceReference reference = iterator.next();
                ManagementController controller = (ManagementController)this._context.getService(reference);
                if (controller != null) {
                    try {
                        this.log(String.format("Unregistering agent [%s] from controller [%s]", location, controller.getClass().getName()));
                        controller.unregisterAgent(location);
                    }
                    catch (RegistrationException exception) {
                        this._log.error((Object)String.format("Error unregistering agent [%s]", location), (Throwable)exception);
                    }
                    continue;
                }
                iterator.remove();
            }
            this._agents.remove(location);
        }
    }

    public void registerAgent(LocatedManagementAgent agent) {
        this.registerAgent(agent.getLocation(), agent);
    }

    public void unregisterAgent(LocatedManagementAgent agent) {
        this.unregisterAgent(agent.getLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagementAgent getAgent(ManagementAgentLocation location) {
        ManagementAgent agent;
        if (location == null) {
            throw new IllegalArgumentException("Location cannot be null!");
        }
        Object object = this._monitor;
        synchronized (object) {
            agent = this._agents.get(location);
        }
        if (agent == null) {
            throw new ManagementAgentNotFoundException(location);
        }
        return agent;
    }

    public ManagementAgent getAgent(String path) {
        return this.getAgent(this.getLocation(path));
    }

    public ManagementCategory getCategory(String name) {
        return new ManagementCategoryImpl(name);
    }

    public ManagementAgentLocation getLocation(String path) {
        String category;
        String name;
        if (path == null) {
            throw new IllegalArgumentException("Agent name cannot be null!");
        }
        int index = path.lastIndexOf(47);
        if (index > 0) {
            name = path.substring(index + 1);
            category = path.substring(0, index);
        } else {
            name = path;
            category = null;
        }
        return this.getCategory(category).getLocation(name);
    }

    public Object getMonitor() {
        return this._monitor;
    }

    private class ManagementServiceTracker
    extends ServiceTracker {
        public ManagementServiceTracker(BundleContext context) {
            super(context, ManagementController.class.getName(), null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object addingService(ServiceReference reference) {
            ManagementController controller = (ManagementController)this.context.getService(reference);
            Object object = ManagementRegistration.this._monitor;
            synchronized (object) {
                ManagementRegistration.this.log(String.format("Found new controller [%s]", controller.getClass().getName()));
                ManagementRegistration.this._controllers.add(reference);
                for (ManagementAgentLocation location : ManagementRegistration.this._agents.keySet()) {
                    try {
                        ManagementRegistration.this.log(String.format("Registering old agent [%s] in new controller [%s]", location, controller.getClass().getName()));
                        controller.registerAgent(location, (ManagementAgent)ManagementRegistration.this._agents.get(location));
                    }
                    catch (RegistrationException exception) {
                        ManagementRegistration.this._log.error((Object)"Error registering ManagementController service", (Throwable)exception);
                    }
                }
            }
            return controller;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference reference, Object service) {
            ManagementController controller = (ManagementController)this.context.getService(reference);
            Object object = ManagementRegistration.this._monitor;
            synchronized (object) {
                for (ManagementAgentLocation location : ManagementRegistration.this._agents.keySet()) {
                    try {
                        ManagementRegistration.this.log(String.format("Unregistering old agent [%s] from removed controller [%s]", location, controller.getClass().getName()));
                        controller.unregisterAgent(location);
                    }
                    catch (RegistrationException exception) {
                        ManagementRegistration.this._log.error((Object)"Error unregistering ManagementController service", (Throwable)exception);
                    }
                }
                ManagementRegistration.this._controllers.remove(reference);
            }
        }
    }
}

