/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Attachment;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.util.ResultCollector;

public class FileWriterPipelet
implements Pipelet {
    public static final String PROPERTY_PATH_ATTRIBUTE = "pathAttribute";
    public static final String PROPERTY_CONTENT_ATTACHMENT = "contentAttachment";
    public static final String PROPERTY_APPEND = "append";
    private final Log _log = LogFactory.getLog(this.getClass());
    private AnyMap _config;

    public void configure(AnyMap configuration) throws ProcessingException {
        this._config = configuration;
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        ParameterAccessor paramAccessor = new ParameterAccessor(blackboard, this._config);
        ResultCollector resultCollector = new ResultCollector(paramAccessor, this._log, false);
        String[] stringArray = recordIds;
        int n = recordIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            try {
                paramAccessor.setCurrentRecord(id);
                String contentAttachmentName = paramAccessor.getRequiredParameter(PROPERTY_CONTENT_ATTACHMENT);
                Attachment attachment = blackboard.getAttachment(id, contentAttachmentName);
                if (attachment == null) {
                    this._log.warn((Object)("Attachment not found in record " + id + ": " + contentAttachmentName));
                } else {
                    String pathAttributeName = paramAccessor.getRequiredParameter(PROPERTY_PATH_ATTRIBUTE);
                    String path = blackboard.getMetadata(id).getStringValue(pathAttributeName);
                    if (path == null) {
                        this._log.warn((Object)("File path not found in record " + id + ": " + pathAttributeName));
                    } else {
                        this.writeFile(attachment, path, paramAccessor.getBooleanParameter(PROPERTY_APPEND, Boolean.FALSE));
                    }
                }
                resultCollector.addResult(id);
            }
            catch (Exception e) {
                resultCollector.addFailedResult(id, (Exception)new ProcessingException("Error in FileWriterPipelet processing ID " + id, (Throwable)e));
            }
            ++n2;
        }
        return resultCollector.getResultIds();
    }

    private void writeFile(Attachment attachment, String path, boolean append) throws IOException {
        this._log.debug((Object)(String.valueOf(append ? "Writing to file " : "Creating file ") + path));
        FileOutputStream out = new FileOutputStream(path, append);
        try {
            InputStream in = attachment.getAsStream();
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }
}

