/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.management.jmx.client.cmd.task.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.management.jmx.client.cmd.CmdConsoleImpl;
import org.eclipse.smila.management.jmx.client.cmd.op.EvalService;
import org.eclipse.smila.management.jmx.client.cmd.task.Task;
import org.eclipse.smila.management.jmx.client.config.BooleanOpType;
import org.eclipse.smila.management.jmx.client.config.WaitType;
import org.eclipse.smila.management.jmx.client.exceptions.EvaluationException;
import org.eclipse.smila.management.jmx.client.exceptions.OperationException;
import org.eclipse.smila.management.jmx.client.helpers.JmxConnection;
import org.eclipse.smila.management.jmx.client.helpers.ParameterFormatHelper;

public class WaitTask
implements Task<WaitType> {
    private final Log _log = LogFactory.getLog(this.getClass());

    @Override
    public Object execute(WaitType config, JmxConnection connection, Object globalResult, String[] parameters, Object localResult) throws OperationException {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)ParameterFormatHelper.format(config.getEcho(), globalResult, parameters, localResult));
        }
        boolean doStop = false;
        boolean unconditionalWait = false;
        while (!doStop && !unconditionalWait) {
            if (config.getCmd() != null) {
                try {
                    CmdConsoleImpl console = new CmdConsoleImpl();
                    console.execute(config.getCmd(), connection, localResult, parameters);
                }
                catch (Exception e) {
                    throw new OperationException(e);
                }
            }
            try {
                BooleanOpType configOp = config.getEquals();
                if (configOp == null) {
                    configOp = config.getIn();
                }
                if (configOp != null) {
                    doStop = EvalService.eval(configOp, connection, globalResult, parameters, localResult);
                } else {
                    unconditionalWait = true;
                }
            }
            catch (EvaluationException e) {
                throw new OperationException(e);
            }
            if (doStop) continue;
            try {
                Thread.sleep(config.getPause());
            }
            catch (InterruptedException e) {}
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Wait task successfully finished");
        }
        return localResult;
    }
}

