/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskmanager.persistence.zk;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.datamodel.ipc.IpcAnyReader;
import org.eclipse.smila.datamodel.ipc.IpcAnyWriter;
import org.eclipse.smila.taskmanager.BadParameterTaskmanagerException;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskmanager.TaskCounter;
import org.eclipse.smila.taskmanager.TaskList;
import org.eclipse.smila.taskmanager.TaskmanagerException;
import org.eclipse.smila.zookeeper.ZkConcurrentMap;
import org.eclipse.smila.zookeeper.ZkConnection;
import org.eclipse.smila.zookeeper.ZooKeeperService;

public class ZkTaskQueue {
    public static final String ROOT_DIR_PREFIX = "/smila";
    public static final String TASKDIR_PREFIX = "/smila/tasks";
    public static final String TODODIR_SUFFIX = "/todo";
    public static final String TODOQUALIFIEDDIR_SUFFIX = "/todo_qualified";
    public static final String INPROGRESSDIR_SUFFIX = "/inprogress";
    public static final String DELIVERY_PREFIX = "/delivery";
    public static final String OWNER_PROP = "inProgressBy";
    public static final String SECTION_TODO = "todo";
    public static final String SECTION_TODOQUALIFIED = "todo_qualified";
    public static final String SECTION_INPROGRESS = "inprogress";
    public static final String DEFAULT_SUB_QUEUE = "_default";
    private static final String SUB_QUEUE_TASK_PROPERTY = "jobName";
    private final String _workerName;
    private final String _localhost;
    private long _maxNoOfTasksPerHost;
    private final NumberFormat _numberFormat;
    private final ZkConnection _zk;
    private final Log _log = LogFactory.getLog(this.getClass());
    private final IpcAnyReader _anyReader = new IpcAnyReader();
    private final IpcAnyWriter _anyWriter = new IpcAnyWriter();
    private final Deque<String> _lruSubQueues = new LinkedList<String>();

    public ZkTaskQueue(ZooKeeperService service, String workerName, String localhost) {
        this(service, workerName, localhost, -1L);
    }

    public ZkTaskQueue(ZooKeeperService service, String workerName, String localhost, long maxNoOfTasksPerHost) {
        this._zk = new ZkConnection(service);
        this._workerName = workerName;
        this._localhost = localhost;
        this._maxNoOfTasksPerHost = maxNoOfTasksPerHost;
        this._numberFormat = NumberFormat.getIntegerInstance();
        this._numberFormat.setMaximumIntegerDigits(19);
        this._numberFormat.setMinimumIntegerDigits(19);
        this._numberFormat.setGroupingUsed(false);
    }

    public void disconnectZkSession() throws TaskmanagerException {
        try {
            this._zk.disconnectZkSession();
        }
        catch (Exception e) {
            throw new TaskmanagerException("Error discconnecting zookeeper session.", (Throwable)e);
        }
    }

    private ZkConcurrentMap ensureDelayedDeliveryMap() throws KeeperException {
        this._zk.ensurePathExists(DELIVERY_PREFIX);
        return new ZkConcurrentMap(this._zk, DELIVERY_PREFIX);
    }

    private String getDelayedDeliveryKey(Task task) {
        return String.valueOf(this.getSubQueue(task)) + "###" + task.getWorkerName();
    }

    public long getMaxNoOfTasksPerHost() {
        return this._maxNoOfTasksPerHost;
    }

    public void setMaxNoOfTasksPerHost(long maxNoOfTasksPerHost) {
        this._maxNoOfTasksPerHost = maxNoOfTasksPerHost;
    }

    public String getWorkerName() {
        return this._workerName;
    }

    public void put(Task task) throws TaskmanagerException {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("put(), task = " + task));
        }
        try {
            String subQueue = this.getSubQueue(task);
            String todoTaskPath = this.getTodoTaskPath(task.getQualifier(), subQueue);
            this.putTask(task, todoTaskPath);
        }
        catch (Exception ex) {
            throw new TaskmanagerException((Throwable)ex);
        }
    }

    public String putInProgress(Task task) throws TaskmanagerException {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("putInProgress(), task = " + task));
        }
        try {
            String myId = String.valueOf(this._localhost) + "-" + Thread.currentThread().getName();
            task.getProperties().put(OWNER_PROP, myId);
            task.setTaskStartedProperties();
            byte[] inProgressData = this.task2Message(task);
            String inProgressNodeName = this.getInProgressTaskPath(task.getTaskId());
            try {
                this._zk.createPath(inProgressNodeName, inProgressData);
            }
            catch (KeeperException.NodeExistsException e) {
                this._log.trace((Object)("Node exists: " + (Object)((Object)e)));
            }
            String string = myId;
            return string;
        }
        catch (Exception ex) {
            throw new TaskmanagerException((Throwable)ex);
        }
        finally {
            task.getProperties().remove(OWNER_PROP);
        }
    }

    public Task get(Collection<String> qualifiers, String host) throws TaskmanagerException {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("get(), qualifiers = " + qualifiers));
        }
        String qualifiedRootPath = String.valueOf(this.getTodoQualifiedRootPath()) + "/";
        boolean getUnqualifiedTasks = qualifiers == null || qualifiers.isEmpty();
        Collection<String> effectiveQualifiers = getUnqualifiedTasks ? Collections.singleton(null) : qualifiers;
        try {
            List<String> lruSubQueues = this.getSubQueuesForNextTask();
            for (String subQueue : lruSubQueues) {
                if (!getUnqualifiedTasks && !this.isNotEmpty(String.valueOf(qualifiedRootPath) + subQueue)) continue;
                for (String qualifier : effectiveQualifiers) {
                    String todoTaskPath = this.getTodoTaskPath(qualifier, subQueue);
                    Task task = this.getTask(todoTaskPath, host);
                    if (task == null) continue;
                    this.markSubQueueAsUsed(subQueue);
                    return task;
                }
            }
            return null;
        }
        catch (RuntimeException | KeeperException ex) {
            throw new TaskmanagerException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getSubQueuesForNextTask() throws KeeperException {
        LinkedList todoSubQueues = new LinkedList();
        String todoRoot = this.getTodoRootPath();
        String todoQualifiedRoot = this.getTodoQualifiedRootPath();
        if (this.isNotEmpty(todoRoot)) {
            todoSubQueues.addAll(this._zk.getChildrenSorted(todoRoot));
        }
        if (this.isNotEmpty(todoQualifiedRoot)) {
            todoSubQueues.addAll(this._zk.getChildrenSorted(todoQualifiedRoot));
        }
        LinkedList<String> orderedSubQueues = new LinkedList<String>();
        if (!todoSubQueues.isEmpty()) {
            Deque<String> deque = this._lruSubQueues;
            synchronized (deque) {
                this._lruSubQueues.retainAll(todoSubQueues);
                orderedSubQueues.addAll(this._lruSubQueues);
            }
            for (String subQueue : todoSubQueues) {
                if (orderedSubQueues.contains(subQueue)) continue;
                orderedSubQueues.add(0, subQueue);
            }
        }
        return orderedSubQueues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markSubQueueAsUsed(String subQueue) {
        Deque<String> deque = this._lruSubQueues;
        synchronized (deque) {
            this._lruSubQueues.remove(subQueue);
            this._lruSubQueues.addLast(subQueue);
        }
    }

    private Map<String, Task> getTasks(String path) throws KeeperException, TaskmanagerException {
        HashMap<String, Task> tasks;
        block6: {
            tasks = new HashMap<String, Task>();
            try {
                List nodeNames = this._zk.getChildrenSorted(path);
                if (nodeNames == null || nodeNames.isEmpty()) break block6;
                int noOfNames = nodeNames.size();
                int i = 0;
                while (i < noOfNames) {
                    String nodeName = (String)nodeNames.get(i);
                    byte[] nodeData = null;
                    try {
                        nodeData = this._zk.getData(String.valueOf(path) + "/" + nodeName);
                    }
                    catch (KeeperException.NoNodeException noNodeException) {
                        this._log.trace((Object)("Node to get data doesn't exist anymore: " + nodeName));
                    }
                    if (nodeData != null && nodeData.length > 0) {
                        tasks.put(nodeName, this.message2Task(nodeData));
                    }
                    ++i;
                }
            }
            catch (KeeperException.NoNodeException noNodeException) {
                if (!this._log.isDebugEnabled()) break block6;
                this._log.debug((Object)("Todo directory " + path + " does not exist yet."));
            }
        }
        return tasks;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Task getTask(String todoTaskPath, String host) throws KeeperException, TaskmanagerException {
        Task task = null;
        boolean hostCheckSuccessful = false;
        try {
            try {
                if (!this.isNotEmpty(todoTaskPath)) return task;
                List nodeNames = this._zk.getChildrenSorted(todoTaskPath);
                if (nodeNames == null) return task;
                if (nodeNames.isEmpty()) return task;
                hostCheckSuccessful = this.checkAndIncHostCounter(host);
                if (!hostCheckSuccessful) return task;
                int noOfNames = nodeNames.size();
                int i = 0;
                while (task == null) {
                    if (i >= noOfNames) {
                        return task;
                    }
                    task = this.tryTask(todoTaskPath, (String)nodeNames.get(i), host);
                    ++i;
                }
                return task;
            }
            catch (KeeperException.NoNodeException noNodeException) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Todo directory " + todoTaskPath + " does not exist yet."));
                }
                if (!hostCheckSuccessful) return task;
                if (task != null) return task;
                try {
                    this.decHostCounter(host);
                    return task;
                }
                catch (Exception e) {
                    this._log.warn((Object)("Error while decrementing host task counter for host '" + host + "'"), (Throwable)e);
                    return task;
                }
            }
        }
        finally {
            if (hostCheckSuccessful && task == null) {
                try {
                    this.decHostCounter(host);
                }
                catch (Exception e) {
                    this._log.warn((Object)("Error while decrementing host task counter for host '" + host + "'"), (Throwable)e);
                }
            }
        }
    }

    private boolean checkAndIncHostCounter(String host) throws KeeperException {
        if (host == null) {
            return true;
        }
        this._zk.ensurePathExists("/smila/taskmanager/hosts");
        ZkConcurrentMap hostsMap = new ZkConcurrentMap(this._zk, "/smila/taskmanager/hosts");
        Integer newValue = null;
        newValue = this._maxNoOfTasksPerHost == -1L ? hostsMap.add(host, 1) : hostsMap.incIfLessThan(host, this._maxNoOfTasksPerHost);
        if (newValue == null) {
            this._log.warn((Object)("Could not update host task counter for host '" + host + "', probably due to temporary overload."));
            return false;
        }
        return newValue != -1;
    }

    private Task tryTask(String todoTaskPath, String nodeName, String host) throws KeeperException, TaskmanagerException {
        String todoNodeName = String.valueOf(todoTaskPath) + "/" + nodeName;
        byte[] nodeData = null;
        try {
            nodeData = this._zk.getData(todoNodeName);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            this._log.trace((Object)("Node to get data doesn't exist anymore: " + todoNodeName));
        }
        if (nodeData != null && nodeData.length > 0) {
            String myId;
            boolean canGoOn;
            Task task = this.message2Task(nodeData);
            if (host != null) {
                task.getProperties().put("workerHost", host);
            }
            if (!(canGoOn = this.checkDeliveryDelay(task, false))) {
                return null;
            }
            String inProgressNodeName = this.getInProgressTaskPath(task.getTaskId());
            if (this.checkTaskProperty(inProgressNodeName, OWNER_PROP, myId = this.putInProgress(task))) {
                block11: {
                    canGoOn = this.checkDeliveryDelay(task, true);
                    if (canGoOn) break block11;
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("Delay check not successful, removing task " + task.getTaskId() + " from in-progress queue"));
                    }
                    this.delete(task.getTaskId());
                    return null;
                }
                try {
                    this._zk.deleteNode(todoNodeName);
                    task.getProperties().remove(OWNER_PROP);
                    return task;
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("Node to delete doesn't exist anymore: " + todoNodeName));
                    }
                    this._zk.deleteNode(inProgressNodeName);
                }
            }
        }
        return null;
    }

    private boolean checkDeliveryDelay(Task task, boolean changeDeliveryTime) throws TaskmanagerException, KeeperException {
        String deliveryDelay = (String)task.getProperties().get("deliveryDelay");
        if (deliveryDelay != null) {
            long now;
            String deliveryDelayKey;
            String lastDelivery;
            ZkConcurrentMap deliveryMap;
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("delivery delay configured: " + deliveryDelay));
            }
            if (this.mustWaitForDeliveryDelay(task, deliveryMap = this.ensureDelayedDeliveryMap(), deliveryDelay, lastDelivery = deliveryMap.getString(deliveryDelayKey = this.getDelayedDeliveryKey(task)), now = System.currentTimeMillis())) {
                return false;
            }
            if (changeDeliveryTime) {
                String newValue = String.valueOf(now);
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("trying to change last delivery time from " + lastDelivery + " to " + newValue));
                }
                if (lastDelivery != null) {
                    return deliveryMap.replace(deliveryDelayKey, lastDelivery, newValue);
                }
                return newValue.equals(deliveryMap.putIfAbsent(deliveryDelayKey, newValue));
            }
        }
        return true;
    }

    private boolean mustWaitForDeliveryDelay(Task task, ZkConcurrentMap deliveryMap, String deliveryDelay, String lastDelivery, long now) {
        if (deliveryDelay != null && lastDelivery != null && now - Long.valueOf(lastDelivery) < Long.valueOf(deliveryDelay)) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("configured delivery delay " + deliveryDelay + " not reached yet: " + (now - Long.valueOf(lastDelivery))));
            }
            return true;
        }
        return false;
    }

    public Task getInProgressTask(String taskId) throws TaskmanagerException {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("getInProgresTask(), taskId = " + taskId));
        }
        String inProgressNodeName = this.getInProgressTaskPath(taskId);
        try {
            byte[] message = this._zk.getData(inProgressNodeName);
            Task task = this.message2Task(message);
            task.getProperties().remove(OWNER_PROP);
            String host = (String)task.getProperties().remove("workerHost");
            this.decHostCounter(host);
            return task;
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            return null;
        }
        catch (KeeperException.NoNodeException noNodeException) {
            return null;
        }
        catch (Exception ex) {
            throw new TaskmanagerException((Throwable)ex);
        }
    }

    private void decHostCounter(String host) throws KeeperException {
        if (host != null) {
            this._zk.ensurePathExists("/smila/taskmanager/hosts");
            ZkConcurrentMap hostsMap = new ZkConcurrentMap(this._zk, "/smila/taskmanager/hosts");
            Integer newValue = hostsMap.decIfGreaterThan(host, 0L);
            if (newValue == null) {
                this._log.warn((Object)("Could not decrement host task counter for host '" + host + "', probably due to temporary overload."));
            } else if (newValue < 0) {
                this._log.error((Object)("Negative host counter (" + newValue + ") for host '" + host + "'!"));
            }
        }
    }

    public void delete(String taskId) throws TaskmanagerException {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("delete(), taskId = " + taskId));
        }
        try {
            String inProgressNodeName = this.getInProgressTaskPath(taskId);
            try {
                this._zk.deleteNode(inProgressNodeName);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                throw new BadParameterTaskmanagerException("Could not find taskId '" + taskId + "' for worker '" + this._workerName + "'.", BadParameterTaskmanagerException.Cause.taskId);
            }
        }
        catch (RuntimeException | KeeperException ex) {
            throw new TaskmanagerException(ex);
        }
    }

    public void keepAlive(String taskId) throws TaskmanagerException {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("keepAlive(), taskId = " + taskId));
        }
        try {
            String inProgressNodeName = this.getInProgressTaskPath(taskId);
            byte[] nodeData = this._zk.getData(inProgressNodeName);
            this._zk.setData(inProgressNodeName, nodeData);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            throw new BadParameterTaskmanagerException("Could not find taskId '" + taskId + "' for worker '" + this._workerName + "'.", BadParameterTaskmanagerException.Cause.taskId);
        }
        catch (Exception ex) {
            throw new TaskmanagerException((Throwable)ex);
        }
    }

    public boolean hasQualifiedTasks() throws KeeperException {
        String qualifiedRootPath = this.getTodoQualifiedRootPath();
        if (this.isNotEmpty(qualifiedRootPath)) {
            List todoQualifiedSubQueues = this._zk.getChildrenSorted(qualifiedRootPath);
            for (String subQueue : todoQualifiedSubQueues) {
                if (!this.isNotEmpty(String.valueOf(qualifiedRootPath) + "/" + subQueue)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNotEmpty(String path) throws KeeperException {
        Stat stat = this._zk.exists(path);
        return stat != null && stat.getNumChildren() > 0;
    }

    public TaskCounter getTaskCounter() throws TaskmanagerException {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"getTaskCounter()");
        }
        try {
            String workerDir = this.getWorkerPath();
            String todoDir = this.getTodoRootPath();
            String todoQualifiedDir = this.getTodoQualifiedRootPath();
            String inProgressDir = String.valueOf(workerDir) + INPROGRESSDIR_SUFFIX;
            ArrayList todoSubQueues = new ArrayList();
            ArrayList todoQualifiedSubQueues = new ArrayList();
            if (this._zk.exists(todoDir) != null) {
                todoSubQueues.addAll(this._zk.getChildrenSorted(todoDir));
            }
            if (this._zk.exists(todoQualifiedDir) != null) {
                todoQualifiedSubQueues.addAll(this._zk.getChildrenSorted(todoQualifiedDir));
            }
            HashMap<String, Integer> tasksTodoPerJobs = new HashMap<String, Integer>();
            for (String subQueue : todoSubQueues) {
                String todoSubQueueDir = this.getTodoTaskPath(null, subQueue);
                Stat todoStat = this._zk.exists(todoSubQueueDir);
                if (todoStat == null) continue;
                tasksTodoPerJobs.put(subQueue, todoStat.getNumChildren());
            }
            for (String subQueue : todoQualifiedSubQueues) {
                String todoQualifiedSubQueueDir = String.valueOf(todoQualifiedDir) + "/" + subQueue;
                if (this._zk.exists(todoQualifiedSubQueueDir) == null) continue;
                List qualifiers = this._zk.getChildrenSorted(todoQualifiedSubQueueDir);
                for (String qualifier : qualifiers) {
                    String qualifierDir = this.getTodoTaskPath(qualifier, subQueue);
                    Stat qualifierStat = this._zk.exists(qualifierDir);
                    if (qualifierStat == null) continue;
                    if (tasksTodoPerJobs.containsKey(subQueue)) {
                        tasksTodoPerJobs.put(subQueue, (Integer)tasksTodoPerJobs.get(subQueue) + qualifierStat.getNumChildren());
                        continue;
                    }
                    tasksTodoPerJobs.put(subQueue, qualifierStat.getNumChildren());
                }
            }
            Stat inProgressStat = this._zk.exists(inProgressDir);
            int inProgressCount = 0;
            if (inProgressStat != null) {
                inProgressCount = inProgressStat.getNumChildren();
            }
            return new TaskCounter(this._workerName, tasksTodoPerJobs, inProgressCount);
        }
        catch (Exception e) {
            throw new TaskmanagerException((Throwable)e);
        }
    }

    public Collection<String> getTimedOutTasks(long timeToLiveMs) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"checkInProgressTasks()");
        }
        ArrayList<String> timedOutTasks = new ArrayList<String>();
        try {
            String inProgressPath = this.getInProgressPath();
            Stat stat = this._zk.exists(inProgressPath);
            if (stat != null && stat.getNumChildren() > 0) {
                List tasks = this._zk.getChildrenSorted(inProgressPath);
                for (String taskId : tasks) {
                    if (!this.isTaskTimedOut(inProgressPath, taskId, timeToLiveMs)) continue;
                    timedOutTasks.add(taskId);
                }
            }
        }
        catch (Exception ex) {
            this._log.warn((Object)("Error checking inprogress tasks of worker " + this._workerName), (Throwable)ex);
        }
        return timedOutTasks;
    }

    private boolean isTaskTimedOut(String rootPath, String taskId, long timeToLiveMs) {
        try {
            String taskNodePath = String.valueOf(rootPath) + "/" + taskId;
            Stat stat = this._zk.exists(taskNodePath);
            if (stat != null) {
                long mtime = stat.getMtime();
                long now = System.currentTimeMillis();
                if (now - mtime > timeToLiveMs) {
                    String finishNodePath;
                    if (this._log.isInfoEnabled()) {
                        this._log.info((Object)("reached maximum processing time (" + timeToLiveMs + " ms) for task " + taskId));
                    }
                    return this._zk.exists(finishNodePath = String.valueOf(taskNodePath) + "/finishing") == null;
                }
            }
        }
        catch (Exception ex) {
            this._log.error((Object)("Error checking task " + taskId + " for worker " + this._workerName), (Throwable)ex);
        }
        return false;
    }

    public void purge() {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"purge()");
        }
        try {
            String workerDir = this.getWorkerPath();
            String todoDir = this.getTodoRootPath();
            String todoQualifiedDir = this.getTodoQualifiedRootPath();
            String inProgressDir = String.valueOf(workerDir) + INPROGRESSDIR_SUFFIX;
            ArrayList todoSubQueues = new ArrayList();
            ArrayList todoQualifiedSubQueues = new ArrayList();
            if (this._zk.exists(todoDir) != null) {
                todoSubQueues.addAll(this._zk.getChildrenSorted(todoDir));
            }
            if (this._zk.exists(todoQualifiedDir) != null) {
                todoQualifiedSubQueues.addAll(this._zk.getChildrenSorted(todoQualifiedDir));
            }
            for (String subQueue : todoSubQueues) {
                String todoSubQueueDir = this.getTodoTaskPath(null, subQueue);
                this.purge(todoSubQueueDir);
            }
            this.purge(todoDir);
            for (String subQueue : todoQualifiedSubQueues) {
                String todoQualifiedSubQueueDir = String.valueOf(todoQualifiedDir) + "/" + subQueue;
                if (this._zk.exists(todoQualifiedSubQueueDir) == null) continue;
                try {
                    List qualifiers = this._zk.getChildrenSorted(todoQualifiedSubQueueDir);
                    for (String qualifier : qualifiers) {
                        String qualifierDir = this.getTodoTaskPath(qualifier, subQueue);
                        this.purge(qualifierDir);
                    }
                    this.purge(todoQualifiedSubQueueDir);
                }
                catch (Exception ex) {
                    this._log.warn((Object)("Error determining qualifier node of queue " + this._workerName + " during purge"), (Throwable)ex);
                }
            }
            this.purge(inProgressDir);
            this._lruSubQueues.clear();
        }
        catch (Exception ex) {
            this._log.warn((Object)("Error purging queue for worker " + this._workerName), (Throwable)ex);
        }
    }

    private void purge(String node) {
        try {
            Stat stat = this._zk.exists(node);
            if (stat != null && stat.getNumChildren() > 0) {
                List children = this._zk.getChildrenSorted(node);
                for (String childNode : children) {
                    String childPath = String.valueOf(node) + "/" + childNode;
                    try {
                        this._zk.deleteNode(childPath);
                    }
                    catch (Exception ex) {
                        this._log.warn((Object)("Failed to delete node " + childPath + " during purge"), (Throwable)ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            this._log.warn((Object)("Failed to purge path " + node), (Throwable)ex);
        }
    }

    public void cleanEmptyNodes(long timeToLiveMs) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("cleanEmptyNodes() for " + this._workerName));
        }
        try {
            String todoDir = this.getTodoRootPath();
            this.cleanEmptyNodes(todoDir, false, timeToLiveMs);
            String todoQualifiedDir = this.getTodoQualifiedRootPath();
            this.cleanEmptyNodes(todoQualifiedDir, false, timeToLiveMs);
        }
        catch (Exception ex) {
            this._log.warn((Object)("Error during cleaning todo queue for worker " + this._workerName), (Throwable)ex);
        }
    }

    private void cleanEmptyNodes(String node, boolean removeEmpty, long timeToLiveMs) {
        try {
            Stat stat = this._zk.exists(node);
            if (stat != null && stat.getNumChildren() > 0) {
                List children = this._zk.getChildrenSorted(node);
                for (String childNode : children) {
                    String childPath = String.valueOf(node) + "/" + childNode;
                    this.cleanEmptyNodes(childPath, true, timeToLiveMs);
                }
            }
            if (removeEmpty && (stat = this._zk.exists(node)) != null && stat.getNumChildren() == 0 && stat.getDataLength() == 0) {
                long mtime = stat.getMtime();
                long now = System.currentTimeMillis();
                if (now - mtime > timeToLiveMs) {
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("remove empty node " + node));
                    }
                    this._zk.deleteNode(node);
                }
            }
        }
        catch (Exception ex) {
            this._log.warn((Object)("Failed to clean node " + node), (Throwable)ex);
        }
    }

    private String getTodoRootPath() {
        return this.getWorkerPath() + TODODIR_SUFFIX;
    }

    private String getTodoQualifiedRootPath() {
        return String.valueOf(this.getWorkerPath()) + TODOQUALIFIEDDIR_SUFFIX;
    }

    private String getTodoTaskPath(String qualifier, String subQueue) {
        StringBuilder todoTaskDir = new StringBuilder(this.getWorkerPath());
        if (qualifier == null) {
            todoTaskDir.append(TODODIR_SUFFIX);
            if (subQueue != null) {
                todoTaskDir.append("/").append(subQueue);
            }
        } else {
            todoTaskDir.append(TODOQUALIFIEDDIR_SUFFIX);
            if (subQueue != null) {
                todoTaskDir.append("/").append(subQueue);
            }
            todoTaskDir.append('/').append(this.encodeQualifier(qualifier));
        }
        return todoTaskDir.toString();
    }

    private String getWorkerPath() {
        StringBuilder workerPath = new StringBuilder(TASKDIR_PREFIX);
        workerPath.append('/').append(this._workerName);
        return workerPath.toString();
    }

    private String getInProgressPath() {
        return String.valueOf(this.getWorkerPath()) + INPROGRESSDIR_SUFFIX;
    }

    private String getInProgressTaskPath(String taskId) {
        return String.valueOf(this.getInProgressPath()) + "/" + taskId;
    }

    private void putTask(Task task, String path) throws KeeperException, TaskmanagerException {
        String nodePath = String.valueOf(path) + "/" + this.createUniqueTaskNodeName(task);
        byte[] nodeData = this.task2Message(task);
        this._zk.ensurePathExists(path);
        this._zk.setData(path, ZkConnection.NO_DATA);
        this._zk.createPath(nodePath, ZkConnection.NO_DATA);
        try {
            this._zk.setData(nodePath, nodeData);
        }
        catch (KeeperException.NoNodeException e) {
            this._log.info((Object)("Coudn't set data for task " + task.getTaskId()), (Throwable)e);
        }
    }

    private byte[] task2Message(Task task) throws TaskmanagerException {
        try {
            AnyMap anyTask = task.toAny();
            byte[] message = this._anyWriter.writeBinaryObject((Any)anyTask);
            return message;
        }
        catch (Exception ex) {
            throw new TaskmanagerException("Failed to create BON objet from task", (Throwable)ex);
        }
    }

    private Task message2Task(byte[] message) throws TaskmanagerException {
        try {
            Any anyTask = this._anyReader.readBinaryObject(message);
            Task task = Task.fromAny((Any)anyTask);
            return task;
        }
        catch (Exception ex) {
            throw new TaskmanagerException("Failed to parse task from BON object", (Throwable)ex);
        }
    }

    private boolean checkTaskProperty(String nodePath, String taskPropertyName, String expectedPropertyValue) {
        try {
            byte[] nodeData = this._zk.getData(nodePath);
            if (nodeData != null) {
                Task task = this.message2Task(nodeData);
                String value = (String)task.getProperties().get(taskPropertyName);
                return expectedPropertyValue.equals(value);
            }
        }
        catch (KeeperException.NoNodeException noNodeException) {
            this._log.warn((Object)("Node doesn't exist" + nodePath));
        }
        catch (Exception e) {
            this._log.warn((Object)"Error while checking task property ", (Throwable)e);
        }
        return false;
    }

    private String createUniqueTagString(Task task) {
        return "_" + (String)task.getProperties().get("uniquenessTag") + "_";
    }

    private String createUniqueTaskNodeName(Task task) {
        StringBuilder taskNodeName = new StringBuilder();
        taskNodeName.append(this._numberFormat.format(System.nanoTime()));
        if (task.getProperties().containsKey("uniquenessTag")) {
            taskNodeName.append(this.createUniqueTagString(task));
        }
        taskNodeName.append("-").append(task.getTaskId()).append("-").append(this._localhost);
        return taskNodeName.toString();
    }

    public TaskList getTaskList(String section, int maxCount) throws TaskmanagerException {
        TaskList taskList;
        block13: {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("getTaskList(): workerName=" + this._workerName + " section=" + section + " maxCount=" + maxCount));
            }
            taskList = new TaskList(this._workerName, section, 0);
            try {
                String workerDir = this.getWorkerPath();
                String todoDir = String.valueOf(workerDir) + TODODIR_SUFFIX;
                String todoQualifiedDir = String.valueOf(workerDir) + TODOQUALIFIEDDIR_SUFFIX;
                String inProgressDir = String.valueOf(workerDir) + INPROGRESSDIR_SUFFIX;
                if (section.equals(SECTION_TODO) || section.equals(SECTION_TODOQUALIFIED)) {
                    ArrayList todoSubQueues = new ArrayList();
                    ArrayList todoQualifiedSubQueues = new ArrayList();
                    if (this._zk.exists(todoDir) != null) {
                        todoSubQueues.addAll(this._zk.getChildrenSorted(todoDir));
                    }
                    if (this._zk.exists(todoQualifiedDir) != null) {
                        todoQualifiedSubQueues.addAll(this._zk.getChildrenSorted(todoQualifiedDir));
                    }
                    for (String subQueue : todoSubQueues) {
                        String todoSubQueueDir = this.getTodoTaskPath(null, subQueue);
                        this.getTaskList(todoSubQueueDir, subQueue, maxCount, taskList);
                    }
                    for (String subQueue : todoQualifiedSubQueues) {
                        String todoQualifiedSubQueueDir = String.valueOf(todoQualifiedDir) + "/" + subQueue;
                        if (this._zk.exists(todoQualifiedSubQueueDir) == null) continue;
                        try {
                            List qualifiers = this._zk.getChildrenSorted(todoQualifiedSubQueueDir);
                            for (String qualifier : qualifiers) {
                                String qualifierDir = this.getTodoTaskPath(qualifier, subQueue);
                                this.getTaskList(qualifierDir, subQueue, maxCount, taskList);
                            }
                        }
                        catch (KeeperException.NoNodeException noNodeException) {}
                    }
                    break block13;
                }
                if (section.equals(SECTION_INPROGRESS)) {
                    this.getTaskList(inProgressDir, null, maxCount, taskList);
                    break block13;
                }
                throw new BadParameterTaskmanagerException("Accessing task pipe " + this._workerName + " with an invalid type " + section + ". ", BadParameterTaskmanagerException.Cause.workerName);
            }
            catch (TaskmanagerException tex) {
                throw tex;
            }
            catch (Exception e) {
                throw new TaskmanagerException((Throwable)e);
            }
        }
        return taskList;
    }

    private void getTaskList(String currentDir, String subQueue, int maxCount, TaskList taskList) throws KeeperException {
        Stat currentStat;
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("getTaskList(): currentDir=" + currentDir + " maxCount=" + maxCount));
        }
        if ((currentStat = this._zk.exists(currentDir)) == null) {
            return;
        }
        taskList.setSize(taskList.getSize() + currentStat.getNumChildren());
        try {
            List taskIDs = this._zk.getChildrenSorted(currentDir);
            for (String taskID : taskIDs) {
                if (maxCount < 0 || taskList.getTaskNames().size() < maxCount) {
                    String taskPath = String.valueOf(currentDir) + "/" + taskID;
                    if (subQueue != null && taskPath.contains("/" + subQueue + "/")) {
                        taskPath = taskPath.replace(String.valueOf(subQueue) + "/", "");
                    }
                    taskList.addTaskName(taskPath);
                    continue;
                }
                break;
            }
        }
        catch (KeeperException.NoNodeException noNodeException) {}
    }

    public AnyMap getTaskInfo(String section, String taskName) throws TaskmanagerException {
        block14: {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("getTaskInfo(): workerName=" + this._workerName + " taskQueueType=" + section + " taskName=" + taskName));
            }
            AnyMap taskInfo = DataFactory.DEFAULT.createAnyMap();
            try {
                String workerDir = this.getWorkerPath();
                String rootDir = String.valueOf(workerDir) + "/" + section;
                Stat taskStat = null;
                String taskDir = null;
                if (SECTION_TODO.equals(section) || SECTION_TODOQUALIFIED.equals(section)) {
                    ArrayList subQueues = new ArrayList();
                    if (this._zk.exists(rootDir) != null) {
                        subQueues.addAll(this._zk.getChildrenSorted(rootDir));
                    }
                    for (String subQueue : subQueues) {
                        taskDir = String.valueOf(rootDir) + "/" + subQueue + "/" + taskName;
                        taskStat = this._zk.exists(taskDir);
                        if (taskStat == null) {
                            continue;
                        }
                        break;
                    }
                } else {
                    taskDir = String.valueOf(rootDir) + "/" + taskName;
                    taskStat = this._zk.exists(taskDir);
                }
                if (taskStat == null) break block14;
                byte[] nodeData = null;
                try {
                    nodeData = this._zk.getData(taskDir);
                }
                catch (KeeperException.NoNodeException noNodeException) {}
                if (nodeData != null) {
                    taskInfo.put("created", (Any)this.toTimestampAny(taskStat.getCtime()));
                    taskInfo.put("modified", (Any)this.toTimestampAny(taskStat.getMtime()));
                    if (nodeData.length > 0) {
                        Task task = this.message2Task(nodeData);
                        taskInfo.put("task", (Any)task.toAny());
                    } else {
                        taskInfo.put("task", "");
                    }
                }
                return taskInfo;
            }
            catch (Exception e) {
                throw new TaskmanagerException((Throwable)e);
            }
        }
        throw new BadParameterTaskmanagerException("Task does not exist in " + this._workerName + ".", BadParameterTaskmanagerException.Cause.taskId);
    }

    private Value toTimestampAny(long timestamp) {
        return DataFactory.DEFAULT.createDateTimeValue(new Date(timestamp));
    }

    private String encodeQualifier(String qualifier) {
        return qualifier.replace('/', '_');
    }

    public void removeTasks(AnyMap filterMap) {
        String subQueue = filterMap.getStringValue(SUB_QUEUE_TASK_PROPERTY);
        if (subQueue == null) {
            subQueue = DEFAULT_SUB_QUEUE;
        }
        if (subQueue != null) {
            this.removeTasks(this.getTodoTaskPath(null, subQueue), filterMap);
        }
        List qualifiers = new ArrayList();
        try {
            String todoQualifiedDir = String.valueOf(this.getTodoQualifiedRootPath()) + "/" + subQueue;
            if (this._zk.exists(todoQualifiedDir) != null) {
                qualifiers = this._zk.getChildrenSorted(todoQualifiedDir);
            }
        }
        catch (Exception exception) {}
        for (String qualifier : qualifiers) {
            this.removeTasks(this.getTodoTaskPath(qualifier, subQueue), filterMap);
        }
        this.removeTasks(this.getInProgressPath(), filterMap);
    }

    private void removeTasks(String path, AnyMap filterMap) {
        try {
            Map<String, Task> tasks = this.getTasks(path);
            for (Map.Entry<String, Task> entry : tasks.entrySet()) {
                String nodeName = entry.getKey();
                Task task = entry.getValue();
                if (!this.checkTask(task, filterMap)) continue;
                try {
                    this._zk.deleteTree(String.valueOf(path) + "/" + nodeName);
                    String host = (String)task.getProperties().get("workerHost");
                    if (host == null) continue;
                    this.decHostCounter(host);
                }
                catch (KeeperException.NoNodeException noNodeException) {
                }
                catch (Exception e) {
                    this._log.warn((Object)"Caught exception while removing tasks.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this._log.warn((Object)"Caught exception while removing tasks.", (Throwable)e);
        }
    }

    private boolean checkTask(Task task, AnyMap filterMap) {
        Map properties = task.getProperties();
        for (Map.Entry entry : filterMap.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((Any)entry.getValue()).toString();
            String propertyValue = (String)properties.get(key);
            if (propertyValue != null && propertyValue.equals(value)) continue;
            return false;
        }
        return true;
    }

    public List<Task> filterDuplicates(List<Task> tasks) throws TaskmanagerException {
        ArrayList<Task> result = new ArrayList<Task>();
        try {
            HashMap<String, List<String>> todoTasksCache = new HashMap<String, List<String>>();
            for (Task task : tasks) {
                boolean taskExists = false;
                if (task.getProperties().containsKey("uniquenessTag")) {
                    String uniqueTagToSearch = this.createUniqueTagString(task);
                    String subQueue = this.getSubQueue(task);
                    String todoTaskPath = this.getTodoTaskPath(task.getQualifier(), subQueue);
                    List<String> todoTasks = this.getStoredTodoTasksWithCache(todoTaskPath, todoTasksCache);
                    for (String todoTask : todoTasks) {
                        if (!todoTask.contains(uniqueTagToSearch)) continue;
                        taskExists = true;
                        if (!this._log.isDebugEnabled()) break;
                        this._log.debug((Object)("Filtered task '" + task.getTaskId() + "' for worker '" + this._workerName + "' with uniqueness tag '" + (String)task.getProperties().get("uniquenessTag") + "' cause todo task exists: " + todoTask));
                        break;
                    }
                }
                if (taskExists) continue;
                result.add(task);
            }
            return result;
        }
        catch (Exception e) {
            throw new TaskmanagerException((Throwable)e);
        }
    }

    private List<String> getStoredTodoTasksWithCache(String todoTaskPath, Map<String, List<String>> todoTasksCache) throws KeeperException {
        ArrayList todoTasks = todoTasksCache.get(todoTaskPath);
        if (todoTasks == null) {
            try {
                todoTasks = this._zk.getChildrenSorted(todoTaskPath);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                todoTasks = new ArrayList();
            }
            todoTasksCache.put(todoTaskPath, todoTasks);
        }
        return todoTasks;
    }

    private String getSubQueue(Task task) {
        if (task.getProperties().containsKey(SUB_QUEUE_TASK_PROPERTY)) {
            return (String)task.getProperties().get(SUB_QUEUE_TASK_PROPERTY);
        }
        return DEFAULT_SUB_QUEUE;
    }
}

