/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.scripting.httphandler;

import java.net.MalformedURLException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.http.server.util.URLCreator;
import org.eclipse.smila.scripting.ScriptingEngine;
import org.eclipse.smila.scripting.ScriptingEngineException;

public class ScriptsHandler
extends JsonRequestHandler {
    private ScriptingEngine _scriptingEngine;

    protected boolean isValidMethod(String method, String requestUri) {
        return this.isGetRequest(method);
    }

    protected boolean isGetRequest(String method) {
        return "GET".equals(method);
    }

    public Object process(String method, String requestUri, Record inputRecord, HttpExchange exchange) throws Exception {
        return this.getScriptsList(this.getRequestHost(exchange), requestUri);
    }

    private Object getScriptsList(String requestHost, String baseUri) throws MalformedURLException, ScriptingEngineException {
        AnyMap result = DataFactory.DEFAULT.createAnyMap();
        AnySeq scripts = FACTORY.createAnySeq();
        AnySeq itemsSeq = this._scriptingEngine.listScripts();
        for (Any singleItem : itemsSeq) {
            String itemName = singleItem.asMap().getStringValue("name");
            singleItem.asMap().put("url", URLCreator.create((String)requestHost, (String)baseUri, (String)itemName).toString());
            scripts.add((Object)singleItem);
        }
        result.put("scripts", (Any)scripts);
        return result;
    }

    public void setScriptingEngine(ScriptingEngine scriptingEngine) {
        this._scriptingEngine = scriptingEngine;
    }

    public void unsetScriptingEngine(ScriptingEngine scriptingEngine) {
        if (this._scriptingEngine == scriptingEngine) {
            this._scriptingEngine = null;
        }
    }
}

