/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.scripting.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.BlackboardFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.processing.PipeletTracker;
import org.eclipse.smila.scripting.ScriptExecutor;
import org.eclipse.smila.scripting.ScriptingEngine;
import org.eclipse.smila.scripting.ScriptingEngineException;
import org.eclipse.smila.scripting.internal.JavascriptExecutor;
import org.eclipse.smila.scripting.internal.RhinoUtils;
import org.eclipse.smila.scripting.internal.ScriptCatalogVisitor;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.commonjs.module.ModuleScriptProvider;
import org.osgi.service.component.ComponentContext;

public class JavascriptEngine
implements ScriptingEngine {
    public static final String BUNDLE_NAME = "org.eclipse.smila.scripting";
    private static final String SYSPROP_SCRIPT_DIR = "smila.scripting.dir";
    private static final String SYSPROP_SCRIPT_DEBUG = "smila.scripting.debug";
    private static final String DEFAULT_SCRIPT_DIR = "js";
    private Path _scriptDirectory;
    private ModuleScriptProvider _scriptProvider;
    private Scriptable _baseScope;
    private PipeletTracker _pipeletTracker;
    private BlackboardFactory _blackboardFactory;
    private final Log _log = LogFactory.getLog(this.getClass());

    protected void activate(ComponentContext componentContext) throws IOException {
        RhinoUtils.printEngineInfo(this._log);
        this.setScriptDirectory();
        this.initDebugger();
        this._scriptProvider = RhinoUtils.createScriptProvider(this._scriptDirectory);
        this._baseScope = RhinoUtils.createBaseScope(componentContext.getBundleContext(), this._pipeletTracker, this._blackboardFactory);
    }

    private void setScriptDirectory() {
        String scriptDirProperty = System.getProperty(SYSPROP_SCRIPT_DIR);
        if (scriptDirProperty == null) {
            String configFolder = ConfigUtils.getConfigurationFolder().getAbsolutePath();
            this._scriptDirectory = Paths.get(configFolder, BUNDLE_NAME, DEFAULT_SCRIPT_DIR);
        } else {
            this._scriptDirectory = Paths.get(scriptDirProperty, new String[0]);
        }
        this._scriptDirectory = this._scriptDirectory.toAbsolutePath();
        this._log.info((Object)("Using Javascript files from directory " + this._scriptDirectory));
    }

    private void initDebugger() {
        String connectionString = System.getProperty(SYSPROP_SCRIPT_DEBUG);
        if (!StringUtils.isEmpty((String)connectionString)) {
            try {
                RhinoUtils.startDebugger(connectionString);
                this._log.info((Object)("RhinoDebugger initialised with settings " + connectionString));
            }
            catch (Exception ex) {
                this._log.warn((Object)"Failed to start debugger", (Throwable)ex);
            }
        }
    }

    @Override
    public Collection<String> listScriptNames() throws ScriptingEngineException {
        AnySeq scripts = this.listScripts();
        HashSet<String> scriptNames = new HashSet<String>();
        for (Any script : scripts) {
            scriptNames.add(script.asMap().getStringValue("name"));
        }
        return scriptNames;
    }

    @Override
    public AnySeq listScripts() throws ScriptingEngineException {
        AnySeq scripts = DataFactory.DEFAULT.createAnySeq();
        if (!(Files.exists(this._scriptDirectory, new LinkOption[0]) && Files.isReadable(this._scriptDirectory) && Files.isDirectory(this._scriptDirectory, new LinkOption[0]))) {
            this._log.warn((Object)("Script directory " + this._scriptDirectory + " does not exists, is not readable or not a directory. Cannot list scripts."));
        } else {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (ScriptExecutor executor = this.getScriptExecutor();){
                    Files.walkFileTree(this._scriptDirectory, new ScriptCatalogVisitor(executor, scripts, this._scriptDirectory));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                throw new ScriptingEngineException("Error reading script catalog files", ex);
            }
        }
        this.sortDescriptionsByName(scripts);
        return scripts;
    }

    private void sortDescriptionsByName(AnySeq scripts) {
        Collections.sort(scripts, new Comparator<Any>(){

            @Override
            public int compare(Any o1, Any o2) {
                if (o1.isMap() && o2.isMap()) {
                    return o1.asMap().getStringValue("name").compareTo(o2.asMap().getStringValue("name"));
                }
                return 0;
            }
        });
    }

    @Override
    public Record callScript(String scriptName, Record record) throws ScriptingEngineException {
        String[] scriptFileAndFunction = this.getScriptFileAndFunction(scriptName);
        Throwable throwable = null;
        Object var5_6 = null;
        try (ScriptExecutor executor = this.getScriptExecutor();){
            executor.loadScript(scriptFileAndFunction[0]);
            String scriptFunction = scriptFileAndFunction[1];
            return executor.call(scriptFunction, record);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public AnyMap callScript(String scriptName, AnyMap arguments) throws ScriptingEngineException {
        String[] scriptFileAndFunction = this.getScriptFileAndFunction(scriptName);
        Throwable throwable = null;
        Object var5_6 = null;
        try (ScriptExecutor executor = this.getScriptExecutor();){
            executor.loadScript(scriptFileAndFunction[0]);
            String scriptFunction = scriptFileAndFunction[1];
            return executor.call(scriptFunction, arguments);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String[] getScriptFileAndFunction(String scriptName) throws ScriptingEngineException {
        int dotIndex = scriptName.indexOf(46);
        if (dotIndex < 0) {
            throw new ScriptingEngineException("Script name " + scriptName + " does not contain a dot, must have format <script>.<function>");
        }
        return new String[]{scriptName.substring(0, dotIndex), scriptName.substring(dotIndex + 1)};
    }

    @Override
    public ScriptExecutor getScriptExecutor() throws ScriptingEngineException {
        return new JavascriptExecutor(this._scriptProvider, this._baseScope);
    }

    public void setPipeletTracker(PipeletTracker pipeletTracker) {
        this._pipeletTracker = pipeletTracker;
    }

    public void unsetPipeletTracker(PipeletTracker pipeletTracker) {
        if (this._pipeletTracker == pipeletTracker) {
            this._pipeletTracker = null;
        }
    }

    public void setBlackboardFactory(BlackboardFactory factory) {
        this._blackboardFactory = factory;
    }

    public void unsetBlackboardFactory(BlackboardFactory factory) {
        if (this._blackboardFactory == factory) {
            this._blackboardFactory = null;
        }
    }
}

