/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.scripting.internal;

import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.util.AnyUtil;
import org.eclipse.smila.scripting.ScriptExecutor;
import org.eclipse.smila.scripting.ScriptingEngineException;

public class ScriptCatalogVisitor
extends SimpleFileVisitor<Path> {
    private static final String JS_SUFFIX = ".js";
    private static final String SCRIPTCATALOG_SUFFIX = "ScriptCatalog.js";
    private final ScriptExecutor _executor;
    private final AnySeq _scripts;
    private final Log _log = LogFactory.getLog(this.getClass());
    private final Path _scriptDirectory;

    public ScriptCatalogVisitor(ScriptExecutor executor, AnySeq scripts, Path scriptDirectory) {
        this._executor = executor;
        this._scripts = scripts;
        this._scriptDirectory = scriptDirectory;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        this._log.debug((Object)("Visit " + file));
        if (file.getFileName().toString().endsWith(SCRIPTCATALOG_SUFFIX)) {
            try {
                String scriptFile = this._scriptDirectory.relativize(file).toString();
                scriptFile = scriptFile.substring(0, scriptFile.length() - JS_SUFFIX.length());
                scriptFile = scriptFile.replace("\\", "/");
                this._log.info((Object)("Reading catalog file " + scriptFile));
                Object result = this._executor.loadScript(scriptFile);
                if (result != null) {
                    Any resultAny = AnyUtil.objectToAny((Object)result);
                    for (Any entry : resultAny) {
                        this.addValidDescription(entry, file);
                    }
                }
            }
            catch (ScriptingEngineException ex) {
                this._log.warn((Object)("Cannot read " + file + ", ignoring it. Details: " + (Object)((Object)ex)));
            }
            catch (InvalidValueTypeException ex) {
                this._log.warn((Object)("Cannot convert result from " + file + " to Any object, ignoring it. Details: " + (Object)((Object)ex)));
            }
        }
        return FileVisitResult.CONTINUE;
    }

    private void addValidDescription(Any entry, Path file) {
        if (entry.isMap()) {
            AnyMap entryMap = entry.asMap();
            if (entryMap.containsKey((Object)"name")) {
                this._scripts.add((Object)entryMap);
            } else {
                this._log.warn((Object)("Description " + entryMap + " from " + file + " does not contain a name, skipping it."));
            }
        } else {
            this._log.warn((Object)("Description " + entry + " from " + file + " is not a map, skipping it."));
        }
    }
}

