/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.scripting.worker;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.scripting.ScriptExecutor;
import org.eclipse.smila.scripting.ScriptingEngine;
import org.eclipse.smila.scripting.ScriptingEngineException;
import org.eclipse.smila.scripting.internal.RhinoInstallable;
import org.eclipse.smila.scripting.worker.EmitFunction;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;
import org.eclipse.smila.taskworker.input.RecordInput;
import org.eclipse.smila.taskworker.output.RecordOutput;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ScriptProcessorWorker
implements Worker {
    public static final String WORKER_NAME = "scriptProcessor";
    public static final String KEY_SCRIPT_NAME = "script";
    public static final String KEY_PROCESS_FUNCTION = "function";
    public static final String KEY_INIT_FUNCTION = "initializeFunction";
    public static final String KEY_WRITE_ATTACHMENTS_TO_OUTPUT = "writeAttachmentsToOutput";
    public static final String KEY_FAIL_ON_ERROR = "_failOnError";
    public static final String DEFAULT_PARAMETERS_ATTRIBUTE = "_parameters";
    public static final String ATTR_SCRIPT_NAME = "_script";
    public static final String ATTR_FUNCTION_NAME = "_function";
    public static final String INPUT_SLOT_NAME = "input";
    public static final String OUTPUT_SLOT_NAME = "output";
    public static final String DEFAULT_PROCESS_FUNCTION = "processRecord";
    public static final String DEFAULT_INIT_FUNCTION = "prepare";
    private final Log _log = LogFactory.getLog(this.getClass());
    private ScriptingEngine _scriptingEngine;

    public String getName() {
        return WORKER_NAME;
    }

    public void perform(TaskContext taskContext) throws Exception {
        RecordOutput recordOutput;
        RecordInput recordInput;
        AnyMap parameters = this.getTaskParameters(taskContext);
        boolean success = this.processScript(parameters, recordInput = taskContext.getInputs().getAsRecordInput(INPUT_SLOT_NAME), recordOutput = taskContext.getOutputs().getAsRecordOutput(OUTPUT_SLOT_NAME), taskContext);
        if (!success) {
            throw new ProcessingException("None of the records of task " + taskContext.getTask() + " could be successfully processed, have a look at the log for details.");
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processScript(AnyMap parameters, RecordInput recordInput, RecordOutput recordOutput, TaskContext taskContext) throws Exception {
        scriptExecutors = new HashMap<String, ScriptExecutor>();
        scriptName = this.getScriptName(parameters);
        functionName = this.getProcessFunctionName(parameters);
        initFunctionName = this.getInitFunctionName(parameters);
        success = false;
        try {
            bulkFinished = false;
            if (true) ** GOTO lbl19
            do {
                if ((record = recordInput.getRecord()) == null) {
                    bulkFinished = true;
                } else {
                    this.setTaskParameters(record, parameters);
                    recordScriptName = this.getScriptNameForRecord(record, scriptName);
                    scriptExecutor = this.getScriptExecutor(scriptExecutors, recordScriptName, initFunctionName, recordOutput, parameters, taskContext);
                    recordFunctionName = this.getFunctionNameForRecord(record, functionName);
                    if (!taskContext.isCanceled()) {
                        success |= this.processRecord(scriptExecutor, record, recordFunctionName, recordOutput, taskContext);
                    }
                }
lbl19:
                // 5 sources

                if (bulkFinished) break;
            } while (!taskContext.isCanceled());
        }
        finally {
            ** for (scriptExecutor : scriptExecutors.values())
        }
lbl-1000:
        // 1 sources

        {
            try {
                scriptExecutor.close();
            }
            catch (Throwable e) {
                this._log.warn((Object)"Error while closing ScriptExecutor", e);
            }
            continue;
        }
lbl32:
        // 1 sources

        return success;
    }

    private ScriptExecutor getScriptExecutor(Map<String, ScriptExecutor> scriptExecutors, String scriptName, String initFunctionName, RecordOutput output, AnyMap parameters, TaskContext taskContext) throws ScriptingEngineException {
        ScriptExecutor scriptExecutor = scriptExecutors.get(scriptName);
        if (scriptExecutor == null) {
            taskContext.addToCounter("scripts", 1L);
            scriptExecutor = this.loadScript(scriptName, output, taskContext);
            this.initScript(scriptExecutor, scriptName, initFunctionName, parameters, taskContext);
            scriptExecutors.put(scriptName, scriptExecutor);
        }
        return scriptExecutor;
    }

    private void loadScriptInstallToRuntime(RecordOutput output, final TaskContext taskContext, ScriptExecutor scriptExecutor) throws ScriptingEngineException {
        scriptExecutor.install(new EmitFunction(output, taskContext));
        scriptExecutor.install(new RhinoInstallable(){

            @Override
            public void install(Scriptable installScope) {
                ScriptableObject.putProperty((Scriptable)installScope, (String)"workerLog", (Object)Context.javaToJS((Object)taskContext.getLog(), (Scriptable)installScope));
            }
        });
        scriptExecutor.install(new RhinoInstallable(){

            @Override
            public void install(Scriptable installScope) {
                ScriptableObject.putProperty((Scriptable)installScope, (String)"taskContext", (Object)Context.javaToJS((Object)taskContext, (Scriptable)installScope));
            }
        });
    }

    private ScriptExecutor loadScript(String scriptName, RecordOutput output, TaskContext taskContext) throws ScriptingEngineException {
        long timestamp = taskContext.getTimestamp();
        try {
            ScriptExecutor scriptExecutor = this._scriptingEngine.getScriptExecutor();
            this.loadScriptInstallToRuntime(output, taskContext, scriptExecutor);
            scriptExecutor.loadScript(scriptName);
            ScriptExecutor scriptExecutor2 = scriptExecutor;
            return scriptExecutor2;
        }
        finally {
            taskContext.measureTime("script.load", timestamp);
        }
    }

    private void initScript(ScriptExecutor scriptExecutor, String scriptName, String initFunction, AnyMap parameters, TaskContext taskContext) throws ScriptingEngineException {
        long timestamp = taskContext.getTimestamp();
        try {
            try {
                scriptExecutor.call(initFunction, parameters);
            }
            catch (ScriptingEngineException ex) {
                taskContext.getLog().warn("Failed to initialize script calling " + scriptName + "." + initFunction, (Throwable)((Object)ex));
                throw ex;
            }
        }
        finally {
            taskContext.measureTime("script.prepare", timestamp);
        }
    }

    private boolean processRecord(ScriptExecutor scriptExecutor, Record record, String scriptFunction, RecordOutput recordOutput, TaskContext taskContext) throws Exception {
        long timestamp = taskContext.getTimestamp();
        try {
            Record result = scriptExecutor.call(scriptFunction, record);
            this.writeResultRecord(result, recordOutput, taskContext);
            return true;
        }
        catch (ScriptingEngineException ex) {
            if (ex.isRecoverable()) {
                throw ex;
            }
            taskContext.getLog().warn("Failed to process record " + record.getId() + ", skipping it.", (Throwable)((Object)ex));
            return false;
        }
        finally {
            taskContext.measureTime("script.process", timestamp);
        }
    }

    private AnyMap getTaskParameters(TaskContext taskContext) {
        return DataFactory.DEFAULT.cloneAnyMap(taskContext.getTask().getParameters());
    }

    private String getScriptName(AnyMap parameters) {
        String scriptName = parameters.getStringValue(KEY_SCRIPT_NAME);
        if (scriptName == null || scriptName.isEmpty()) {
            throw new IllegalArgumentException("Parameter 'script' is not set.");
        }
        return scriptName;
    }

    private String getProcessFunctionName(AnyMap parameters) {
        String function = parameters.getStringValue(KEY_PROCESS_FUNCTION);
        if (function == null || function.isEmpty()) {
            function = DEFAULT_PROCESS_FUNCTION;
        }
        return function;
    }

    private String getInitFunctionName(AnyMap parameters) {
        String function = parameters.getStringValue(KEY_INIT_FUNCTION);
        if (function == null || function.isEmpty()) {
            function = DEFAULT_INIT_FUNCTION;
        }
        return function;
    }

    private String getScriptNameForRecord(Record record, String defaultScriptName) {
        AnyMap metadata = record.getMetadata();
        Any attributeValue = (Any)metadata.get((Object)ATTR_SCRIPT_NAME);
        if (attributeValue != null && attributeValue.isString()) {
            return attributeValue.asValue().asString();
        }
        return defaultScriptName;
    }

    private String getFunctionNameForRecord(Record record, String defaultFunctionName) {
        AnyMap metadata = record.getMetadata();
        Any attributeValue = (Any)metadata.get((Object)ATTR_FUNCTION_NAME);
        if (attributeValue != null && attributeValue.isString()) {
            return attributeValue.asValue().asString();
        }
        return defaultFunctionName;
    }

    private void writeResultRecord(Record record, RecordOutput recordOutput, TaskContext taskContext) throws ObjectStoreException, IOException {
        boolean withAttachments = this.shouldWriteAttachments(taskContext);
        if (record != null && recordOutput != null) {
            if (!withAttachments) {
                record.removeAttachments();
            }
            recordOutput.writeRecord(record);
        }
    }

    private void setTaskParameters(Record record, AnyMap parameters) {
        AnyMap parameterMap = record.getMetadata().getMap(DEFAULT_PARAMETERS_ATTRIBUTE, true);
        for (Map.Entry parameter : parameters.entrySet()) {
            parameterMap.put((String)parameter.getKey(), (Any)parameter.getValue());
        }
    }

    private boolean shouldWriteAttachments(TaskContext taskContext) {
        Boolean writeAttachments = taskContext.getTask().getParameters().getBooleanValue(KEY_WRITE_ATTACHMENTS_TO_OUTPUT);
        return writeAttachments == null ? true : writeAttachments;
    }

    public void setScriptingEngine(ScriptingEngine scriptingEngine) {
        this._scriptingEngine = scriptingEngine;
    }

    public void unsetScriptingEngine(ScriptingEngine scriptingEngine) {
        if (this._scriptingEngine == scriptingEngine) {
            this._scriptingEngine = null;
        }
    }
}

