/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.common.util.NamedList;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.datamodel.util.AnyUtil;

public class SolrUtils {
    public static final String ESCAPE_CHARS = "+-&|!(){}[]^~*?:\\\"/";
    public static final String ESCAPE_CHARS_WS = "+-&|!(){}[]^~*?:\\\"/ ";
    public static final String QUERY_WRAPPER_FILTER = "QueryWrapperFilter";

    private SolrUtils() {
    }

    public static boolean isErrorResponse(SolrResponseBase response) {
        return response.getStatus() != 0;
    }

    public static String escape(String string) {
        return SolrUtils.escape(string, ESCAPE_CHARS);
    }

    public static String escapeWS(String string) {
        return SolrUtils.escape(string, ESCAPE_CHARS_WS);
    }

    public static String escape(String string, String escapeChars) {
        if (StringUtils.isEmpty((String)string)) {
            return string;
        }
        int length = string.length();
        StringBuilder buf = new StringBuilder(length * 2);
        int i = 0;
        while (i < length) {
            char ch = string.charAt(i);
            if (escapeChars.indexOf(ch) >= 0) {
                buf.append('\\');
            }
            buf.append(ch);
            ++i;
        }
        if (buf.length() != string.length()) {
            return buf.toString();
        }
        return string;
    }

    public static String getPerFieldParameter(String fieldName, String parameterName) {
        return "f" + "." + fieldName + "." + parameterName;
    }

    public static StringBuilder writeLocalParams(AnyMap localParams) {
        return SolrUtils.writeLocalParams(new StringBuilder(), localParams);
    }

    public static StringBuilder writeLocalParams(StringBuilder sb, AnyMap localParams) {
        if (sb == null) {
            throw new NullArgumentException("sb");
        }
        if (MapUtils.isEmpty((Map)localParams)) {
            return sb;
        }
        sb.append("{");
        sb.append("!");
        for (Map.Entry localParam : localParams.entrySet()) {
            String key = (String)localParam.getKey();
            sb.append(key);
            sb.append("=");
            Any value = (Any)localParam.getValue();
            String val = null;
            if (value.isValue()) {
                val = value.asValue().asString();
            } else if (value.isSeq()) {
                List vals = value.asSeq().asStrings();
                val = StringUtils.join((Collection)vals, (String)",");
            }
            sb.append(val);
            sb.append(" ");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        return sb;
    }

    public static StringBuilder addLocalParams(String value, AnyMap localParams) {
        StringBuilder sb = SolrUtils.writeLocalParams(localParams);
        return sb.append(value);
    }

    public static AnyMap putLocalParam(AnyMap config, String param, String value, boolean create) {
        return SolrUtils.putLocalParam(config, param, value, create, LocalParamsMode.IGNORE);
    }

    public static AnyMap putLocalParam(AnyMap config, String param, String value, boolean create, LocalParamsMode mode) {
        if (config == null) {
            throw new NullArgumentException("config");
        }
        if (param == null) {
            throw new NullArgumentException("param");
        }
        AnyMap localParams = config.getMap("localParams", create);
        if (localParams != null) {
            switch (mode) {
                case ADD: {
                    Value val = DataFactory.DEFAULT.autoConvertValue((Object)value);
                    localParams.add(param, (Any)val);
                    break;
                }
                case OVERWRITE: {
                    localParams.put(param, value);
                    break;
                }
                case IGNORE: {
                    if (localParams.containsKey((Object)param)) break;
                    localParams.put(param, value);
                    break;
                }
                default: {
                    throw new NotImplementedException(mode.toString());
                }
            }
        }
        return localParams;
    }

    public static AnyMap parseNamedList(NamedList<?> list) {
        AnyMap target = DataFactory.DEFAULT.createAnyMap();
        SolrUtils.parseNamedList(list, target);
        return target;
    }

    public static void parseNamedList(NamedList<?> list, AnyMap target) {
        SolrUtils.parseNamedList(list, target, target.getFactory());
    }

    public static void parseNamedList(NamedList<?> list, AnyMap target, DataFactory factory) {
        if (target == null) {
            return;
        }
        int i = 0;
        while (i < list.size()) {
            AnyMap child;
            Object sub;
            String name = list.getName(i);
            Object obj = list.getVal(i);
            if (obj instanceof NamedList) {
                sub = (NamedList)obj;
                child = target.getMap(name, true);
                SolrUtils.parseNamedList(sub, child, factory);
            } else if (obj instanceof ArrayList) {
                sub = (ArrayList)obj;
                child = target.getSeq(name, true);
                SolrUtils.parseArrayList(sub, (AnySeq)child, factory);
            } else {
                try {
                    Any value = AnyUtil.objectToAny((Object)obj);
                    target.put(name, value);
                }
                catch (InvalidValueTypeException invalidValueTypeException) {}
            }
            ++i;
        }
    }

    public static void parseArrayList(ArrayList<?> list, AnySeq target, DataFactory factory) {
        if (target == null || factory == null) {
            return;
        }
        for (Object obj : list) {
            AnyMap child;
            Object sub;
            if (obj instanceof NamedList) {
                sub = (NamedList)obj;
                child = factory.createAnyMap();
                target.add((Object)child);
                SolrUtils.parseNamedList(sub, child, factory);
                continue;
            }
            if (obj instanceof ArrayList) {
                sub = (ArrayList)obj;
                child = factory.createAnySeq();
                target.add((Object)child);
                SolrUtils.parseArrayList(sub, (AnySeq)child, factory);
                continue;
            }
            try {
                Any value = AnyUtil.objectToAny(obj);
                target.add((Object)value);
            }
            catch (InvalidValueTypeException invalidValueTypeException) {}
        }
    }

    public static String getSolrQueryFilter(String luceneFilter) {
        luceneFilter = StringUtils.remove((String)luceneFilter, (String)QUERY_WRAPPER_FILTER);
        luceneFilter = StringUtils.replace((String)luceneFilter, (String)"\\", (String)"\\\\");
        return luceneFilter;
    }

    public static String getConstQueryOnField(String fieldName, String constant) {
        return String.valueOf(fieldName) + ":\"" + SolrUtils.escape(constant) + '\"';
    }

    public static String getTokenQueryOnField(String fieldName, String token) {
        return "(" + fieldName + ":" + SolrUtils.escape(token, ESCAPE_CHARS_WS) + ')';
    }

    public static String encodeQuery(String query) throws UnsupportedEncodingException {
        return URLEncoder.encode(query, "UTF-8");
    }

    public static String decodeQuery(String query) throws UnsupportedEncodingException {
        return URLDecoder.decode(query, "UTF-8");
    }

    public static enum LocalParamsMode {
        ADD,
        OVERWRITE,
        IGNORE;

    }
}

