/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.administration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.solr.SolrOperationService;
import org.eclipse.smila.solr.administration.FieldInfo;
import org.eclipse.smila.utils.service.ServiceUtils;

public class FieldInfoCache {
    public static final String PARAM_INCLUDE_DYNAMIC = "includeDynamic";
    static final Map<String, Map<String, FieldInfo>> _fieldInfo = new HashMap<String, Map<String, FieldInfo>>();

    public static Map<String, FieldInfo> getFieldInfo(String index) {
        Map<String, FieldInfo> fieldInfo = _fieldInfo.get(index);
        if (fieldInfo == null) {
            fieldInfo = new HashMap<String, FieldInfo>();
            _fieldInfo.put(index, fieldInfo);
        }
        return fieldInfo;
    }

    public static FieldInfo getFieldInfo(String index, String fieldName) throws HttpException, InterruptedException, IOException {
        FieldInfo fieldInfo = FieldInfoCache.getFieldInfo(index).get(fieldName);
        if (fieldInfo == null && (fieldInfo = FieldInfoCache.getFromSchema(index, fieldName)) != null) {
            FieldInfoCache.getFieldInfo(index).put(fieldName, fieldInfo);
        }
        return fieldInfo;
    }

    private static FieldInfo getFromSchema(String index, String fieldName) throws InterruptedException, HttpException, IOException {
        SolrOperationService service = (SolrOperationService)ServiceUtils.getService(SolrOperationService.class);
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("fl", new String[]{fieldName});
        params.put(PARAM_INCLUDE_DYNAMIC, new String[]{Boolean.toString(true)});
        ArrayList<String> path = new ArrayList<String>();
        path.add("schema");
        path.add("fields");
        Any response = service.processSchemaRequest(index, params, path);
        if (response instanceof AnyMap) {
            AnyMap field = ((AnyMap)response).getSeq("fields").getMap(0);
            return new FieldInfo(field);
        }
        return null;
    }
}

