/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.params;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.search.api.helper.QueryParameterAccessor;

public class QueryParams
extends QueryParameterAccessor {
    public static final String QUERY = "query";

    public QueryParams(Blackboard blackboard, String queryRecordId) {
        super(blackboard, queryRecordId);
    }

    public QueryParams(Blackboard blackboard, AnyMap configuration, String queryRecordId) {
        super(blackboard, configuration, queryRecordId);
    }

    public int getStart() {
        return this.getIntParameter("offset", 0);
    }

    public int getRows() {
        return this.getIntParameter("maxcount", 10);
    }

    public String[] getFields() {
        List fields = this.getParameters("resultAttributes");
        if (CollectionUtils.isNotEmpty((Collection)fields)) {
            return fields.toArray(new String[fields.size()]);
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public Any getQueryObject() {
        return this.getParameterAny(QUERY);
    }

    public AnyMap getNativeParams() {
        Any solr = this.getParameterAny("_solr");
        if (solr != null && solr.isMap()) {
            return solr.asMap().getMap(QUERY);
        }
        return null;
    }

    public String getRequestHandler() {
        AnyMap nativeParams = this.getNativeParams();
        if (nativeParams != null) {
            return nativeParams.getStringValue("qt");
        }
        return null;
    }
}

