/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.params;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.processing.parameters.ParameterAccessor;

public class SolrParams
extends ParameterAccessor {
    public static final String SOLR_PARAMETER_ATTRIBUTE = "_solr";

    public SolrParams(AnyMap configuration) {
        super(configuration);
        this.setParameterAttribute(SOLR_PARAMETER_ATTRIBUTE);
    }

    public SolrParams(Blackboard blackboard) {
        super(blackboard);
        this.setParameterAttribute(SOLR_PARAMETER_ATTRIBUTE);
    }

    public SolrParams(Blackboard blackboard, AnyMap configuration) {
        super(blackboard, configuration);
        this.setParameterAttribute(SOLR_PARAMETER_ATTRIBUTE);
    }

    public SolrParams(Blackboard blackboard, AnyMap configuration, String recordId) {
        super(blackboard, configuration, recordId);
        this.setParameterAttribute(SOLR_PARAMETER_ATTRIBUTE);
    }

    public SolrParams(Blackboard blackboard, String recordId) {
        super(blackboard, recordId);
        this.setParameterAttribute(SOLR_PARAMETER_ATTRIBUTE);
    }

    public Any getSolrParam(String category, String name) {
        Any param = null;
        AnyMap params = null;
        if (this._blackboard != null && this._recordId != null) {
            try {
                Record record = this._blackboard.getRecord(this._recordId);
                if (record != null) {
                    params = record.getMetadata();
                }
            }
            catch (BlackboardAccessException blackboardAccessException) {}
            if (params != null && this._parametersAttribute != null) {
                params = params.getMap(SOLR_PARAMETER_ATTRIBUTE);
            }
            param = this.getSubParam(params, category, name);
        }
        if (param == null) {
            params = this._config;
            param = this.getSubParam(params, category, name);
        }
        return param;
    }

    private Any getSubParam(AnyMap params, String category, String name) {
        if (params != null && (params = params.getMap(category)) != null) {
            return (Any)params.get((Object)name);
        }
        return null;
    }

    public AnyMap getSolrParamAsAnyMap(String category, String name) {
        Any map = this.getSolrParam(category, name);
        if (map != null) {
            return map.asMap();
        }
        return null;
    }

    public AnySeq getSolrParamAsAnySeq(String category, String name) {
        Any seq = this.getSolrParam(category, name);
        if (seq != null) {
            return seq.asSeq();
        }
        return null;
    }

    public Boolean getSolrParamAsBoolean(String category, String name) {
        Any val = this.getSolrParam(category, name);
        if (val != null) {
            return val.asValue().asBoolean();
        }
        return null;
    }

    public Float getSolrParamAsFloat(String category, String name) {
        Any val = this.getSolrParam(category, name);
        if (val != null) {
            return Float.valueOf(val.asValue().asDouble().floatValue());
        }
        return null;
    }

    public Integer getSolrParamAsInteger(String category, String name) {
        Any val = this.getSolrParam(category, name);
        if (val != null) {
            return val.asValue().asLong().intValue();
        }
        return null;
    }

    public String getSolrParamAsString(String category, String name) {
        Any val = this.getSolrParam(category, name);
        if (val != null) {
            return val.asValue().asString();
        }
        return null;
    }

    public static AnyMap getSolrParams(Record record) {
        return record.getMetadata().getMap(SOLR_PARAMETER_ATTRIBUTE);
    }
}

