/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.query;

import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.common.params.CommonParams;
import org.apache.solr.common.params.FacetParams;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.datamodel.util.AnyUtil;
import org.eclipse.smila.search.api.helper.QueryBuilder;
import org.eclipse.smila.solr.SolrConstants;
import org.eclipse.smila.solr.SolrUtils;

public class SolrQueryBuilder
extends QueryBuilder {
    public SolrQueryBuilder() {
    }

    public SolrQueryBuilder(Record request) {
        super(request);
    }

    public SolrQueryBuilder setStart(int start) {
        return (SolrQueryBuilder)this.setOffset(start);
    }

    public SolrQueryBuilder setRows(int rows) {
        return (SolrQueryBuilder)this.setMaxCount(rows);
    }

    public SolrQueryBuilder addFilterQuery(String fq) {
        return this.addFilterQuery(fq, null);
    }

    public SolrQueryBuilder addFilterQuery(String fq, AnyMap localParams) {
        fq = SolrUtils.addLocalParams(fq, localParams).toString();
        return this.addNative("fq", fq);
    }

    public SolrQueryBuilder addFilter(String attribute, AnyMap filter, AnyMap localParams) {
        if (localParams != null) {
            filter.put("localParams", (Any)localParams);
        }
        return (SolrQueryBuilder)this.addFilter(attribute, filter);
    }

    public SolrQueryBuilder addReturnField(String fl) {
        return this.addReturnField(fl, null);
    }

    public SolrQueryBuilder addReturnField(String fl, String alias) {
        if (StringUtils.isNotBlank((String)alias)) {
            fl = String.valueOf(alias) + ":" + fl;
        }
        return this.addNative("fl", fl);
    }

    public SolrQueryBuilder setDebug(SolrConstants.Debug debug) {
        if (debug == null) {
            throw new IllegalArgumentException("debug");
        }
        return this.setNative("debug", debug.toString());
    }

    public SolrQueryBuilder setExplainOther(String explainOther) {
        return this.setNative("explainOther", explainOther);
    }

    public SolrQueryBuilder setDebugExplainStructured(boolean debugExplainStructured) {
        return this.setNative("debug.explain.structured", Boolean.toString(debugExplainStructured));
    }

    public SolrQueryBuilder setDefType(String defType) {
        return this.setNative("defType", defType);
    }

    public SolrQueryBuilder setTimeAllowed(long timeAllowed) {
        return this.setNative("timeAllowed", String.valueOf(timeAllowed));
    }

    public SolrQueryBuilder setOmitHeader(boolean omitHeader) {
        return this.setNative("omitHeader", Boolean.toString(omitHeader));
    }

    public SolrQueryBuilder setRequestHandler(String qt) {
        return this.setNative("qt", qt);
    }

    public SolrQueryBuilder setWriterType(String wt) {
        return this.setNative("wt", wt);
    }

    public SolrQueryBuilder setNow(long ms) {
        return this.setNative("NOW", String.valueOf(ms));
    }

    public SolrQueryBuilder setTimezone(String tz) {
        return this.setNative("TZ", tz);
    }

    public SolrQueryBuilder setEchoHandler(boolean echoHandler) {
        return this.setNative("echoHandler", Boolean.toString(echoHandler));
    }

    public SolrQueryBuilder setEchoParams(CommonParams.EchoParamStyle echoParams) {
        if (echoParams == null) {
            throw new IllegalArgumentException("echoParams");
        }
        return this.setNative("echoParams", echoParams.toString());
    }

    public SolrQueryBuilder setFacet(boolean facet) {
        return this.setNative("facet", Boolean.toString(facet));
    }

    public SolrQueryBuilder addFacetQuery(String query) {
        return this.addNative("facet.query", query);
    }

    public SolrQueryBuilder addFacetByQuery(String attribute, String[] expression) {
        return this.addFacetByQuery(attribute, expression, null, false);
    }

    public SolrQueryBuilder addFacetByQuery(String attribute, String[] expression, AnySeq filter, boolean multiselect) {
        return this.addFacetByQuery(attribute, expression, filter, multiselect, null);
    }

    public SolrQueryBuilder addFacetByQuery(String attribute, String[] expression, AnySeq filter, boolean multiselect, AnyMap localParams) {
        if (StringUtils.isBlank((String)attribute)) {
            throw new NullArgumentException("attribute");
        }
        if (ArrayUtils.isEmpty((Object[])expression)) {
            throw new NullArgumentException("queries");
        }
        AnyMap config = this.getFactory().createAnyMap();
        config.put("query", attribute);
        config.put("queries", AnyUtil.objectToAny((Object)expression));
        return this.addFacetConfig(config, filter, multiselect, localParams);
    }

    public SolrQueryBuilder addFacetByAttribute(String attribute) {
        return this.addFacetByAttribute(attribute, null, false);
    }

    public SolrQueryBuilder addFacetByAttribute(String attribute, AnySeq filter, boolean multiselect) {
        return this.addFacetByAttribute(attribute, filter, multiselect, null);
    }

    public SolrQueryBuilder addFacetByAttribute(String attribute, AnySeq filter, boolean multiselect, AnyMap localParams) {
        if (StringUtils.isBlank((String)attribute)) {
            throw new NullArgumentException("attribute");
        }
        AnyMap config = this.getFactory().createAnyMap();
        config.put("attribute", attribute);
        return this.addFacetConfig(config, filter, multiselect, localParams);
    }

    public SolrQueryBuilder setFacetPrefix(String prefix) {
        return this.setFacetPrefix(prefix, null);
    }

    public SolrQueryBuilder setFacetPrefix(String prefix, String fieldName) {
        return this.setNative("facet.prefix", prefix, fieldName);
    }

    public SolrQueryBuilder setFacetSort(SolrConstants.FacetSort facetSort) {
        return this.setFacetSort(facetSort, null);
    }

    public SolrQueryBuilder setFacetSort(SolrConstants.FacetSort sort, String fieldName) {
        if (sort == null) {
            throw new IllegalArgumentException("facet.sort");
        }
        return this.setNative("facet.sort", sort.toString(), fieldName);
    }

    public SolrQueryBuilder setFacetLimit(int limit) {
        return this.setFacetLimit(limit, null);
    }

    public SolrQueryBuilder setFacetLimit(int limit, String fieldName) {
        return this.setNative("facet.limit", String.valueOf(limit), fieldName);
    }

    public SolrQueryBuilder setFacetOffset(int offset) {
        return this.setFacetOffset(offset, null);
    }

    public SolrQueryBuilder setFacetOffset(int offset, String fieldName) {
        return this.setNative("facet.offset", String.valueOf(offset), fieldName);
    }

    public SolrQueryBuilder setFacetMincount(int mincount) {
        return this.setFacetMincount(mincount, null);
    }

    public SolrQueryBuilder setFacetMincount(int mincount, String fieldName) {
        return this.setNative("facet.mincount", String.valueOf(mincount), fieldName);
    }

    public SolrQueryBuilder setFacetMissing(boolean missing) {
        return this.setFacetMissing(missing, null);
    }

    public SolrQueryBuilder setFacetMissing(boolean missing, String fieldName) {
        return this.setNative("facet.missing", Boolean.toString(missing), fieldName);
    }

    public SolrQueryBuilder setFacetMethod(SolrConstants.FacetMethod method) {
        return this.setFacetMethod(method, null);
    }

    public SolrQueryBuilder setFacetMethod(SolrConstants.FacetMethod facetMethod, String fieldName) {
        if (facetMethod == null) {
            throw new IllegalArgumentException("facet.method");
        }
        return this.setNative("facet.method", facetMethod.toString(), fieldName);
    }

    public SolrQueryBuilder setFacetEnumCacheMinDf(int enumCacheMinDf) {
        return this.setFacetEnumCacheMinDf(enumCacheMinDf, null);
    }

    public SolrQueryBuilder setFacetEnumCacheMinDf(int enumCacheMinDf, String fieldName) {
        return this.setNative("facet.enum.cache.minDf", String.valueOf(enumCacheMinDf), fieldName);
    }

    public SolrQueryBuilder setFacetThreads(int threads) {
        return this.setNative("facet.threads", String.valueOf(threads), null);
    }

    public SolrQueryBuilder addFacetByRange(String range, Number start, Number end, Number gap) {
        return this.addFacetByRange(range, start, end, gap, null);
    }

    public SolrQueryBuilder addFacetByRange(String range, Number start, Number end, Number gap, String outputKey) {
        return this.addFacetByRange(range, start, end, gap, outputKey, false);
    }

    public SolrQueryBuilder addFacetByRange(String range, Number start, Number end, Number gap, String outputKey, boolean multiselect) {
        if (StringUtils.isBlank((String)range)) {
            throw new IllegalArgumentException("range");
        }
        AnyMap rangeFacet = this.getFactory().createAnyMap();
        rangeFacet.put("range", range);
        rangeFacet.put("start", start);
        rangeFacet.put("end", end);
        rangeFacet.put("gap", gap);
        if (StringUtils.isNotBlank((String)outputKey)) {
            rangeFacet.put("key", outputKey);
        }
        if (multiselect) {
            rangeFacet.put("multiselect", Boolean.valueOf(multiselect));
        }
        return this.addConfig("facetby", rangeFacet);
    }

    public SolrQueryBuilder addFacetByRange(String range, Date start, Date end, String gap) {
        return this.addFacetByRange(range, start, end, gap, null);
    }

    public SolrQueryBuilder addFacetByRange(String range, Date start, Date end, String gap, String outputKey) {
        return this.addFacetByRange(range, start, end, gap, outputKey, false);
    }

    public SolrQueryBuilder addFacetByRange(String range, Date start, Date end, String gap, String outputKey, boolean multiselect) {
        if (StringUtils.isBlank((String)range)) {
            throw new IllegalArgumentException("range");
        }
        AnyMap rangeFacet = this.getFactory().createAnyMap();
        rangeFacet.put("range", range);
        rangeFacet.put("start", AnyUtil.objectToAny((Object)start));
        rangeFacet.put("end", AnyUtil.objectToAny((Object)end));
        rangeFacet.put("gap", AnyUtil.objectToAny((Object)gap));
        if (StringUtils.isNotBlank((String)outputKey)) {
            rangeFacet.put("key", outputKey);
        }
        if (multiselect) {
            rangeFacet.put("multiselect", Boolean.valueOf(multiselect));
        }
        return this.addConfig("facetby", rangeFacet);
    }

    public SolrQueryBuilder addFacetPivot(String ... pivot) {
        if (pivot == null) {
            throw new IllegalArgumentException("pivot");
        }
        AnyMap pivotFacet = this.getFactory().createAnyMap();
        Any values = AnyUtil.objectToAny((Object)pivot);
        if (values.isSeq()) {
            pivotFacet.getSeq("pivot", true).addAll((Collection)values.asSeq());
        }
        return this.addConfig("facetby", pivotFacet);
    }

    public SolrQueryBuilder addFacetInterval(String interval, String ... set) {
        if (StringUtils.isBlank((String)interval)) {
            throw new IllegalArgumentException("interval");
        }
        AnyMap intervalFacet = this.getFactory().createAnyMap();
        intervalFacet.put("interval", interval);
        Any values = AnyUtil.objectToAny((Object)set);
        if (values.isSeq()) {
            intervalFacet.getSeq("set", true).addAll((Collection)values.asSeq());
        }
        return this.addConfig("facetby", intervalFacet);
    }

    public SolrQueryBuilder setFacetRangeHardend(boolean hardend) {
        return this.setFacetRangeHardend(hardend, null);
    }

    public SolrQueryBuilder setFacetRangeHardend(boolean hardend, String fieldName) {
        return this.setNative("facet.range.hardend", Boolean.toString(hardend), fieldName);
    }

    public SolrQueryBuilder setFacetRangeOther(FacetParams.FacetRangeOther other) {
        return this.setFacetRangeOther(other, null);
    }

    public SolrQueryBuilder setFacetRangeOther(FacetParams.FacetRangeOther other, String fieldName) {
        if (other == null) {
            throw new IllegalArgumentException("facet.range.other");
        }
        return this.setNative("facet.range.other", other.toString(), fieldName);
    }

    public SolrQueryBuilder setFacetRangeInclude(FacetParams.FacetRangeInclude include) {
        return this.setFacetRangeInclude(include, null);
    }

    public SolrQueryBuilder setFacetRangeInclude(FacetParams.FacetRangeInclude include, String fieldName) {
        if (include == null) {
            throw new IllegalArgumentException("facet.range.include");
        }
        return this.setNative("facet.range.include", include.toString(), fieldName);
    }

    public SolrQueryBuilder setFacetPivotMincount(int mincount) {
        return this.setNative("facet.pivot.mincount", String.valueOf(mincount));
    }

    public SolrQueryBuilder setGroup(boolean group) {
        return this.setNative("group", Boolean.toString(group));
    }

    public SolrQueryBuilder addGroupByAttribute(String attribute) {
        if (StringUtils.isBlank((String)attribute)) {
            throw new IllegalArgumentException("group.field");
        }
        AnyMap group = this.getFactory().createAnyMap();
        group.put("attribute", attribute);
        return this.addConfig("groupby", group);
    }

    public SolrQueryBuilder addGroupByFunctionQuery(String func) {
        if (StringUtils.isBlank((String)func)) {
            throw new IllegalArgumentException("group.func");
        }
        AnyMap group = this.getFactory().createAnyMap();
        group.put("func", func);
        return this.addConfig("groupby", group);
    }

    public SolrQueryBuilder addGroupByQuery(String query) {
        if (StringUtils.isBlank((String)query)) {
            throw new IllegalArgumentException("group.query");
        }
        AnyMap group = this.getFactory().createAnyMap();
        group.put("query", query);
        return this.addConfig("groupby", group);
    }

    public SolrQueryBuilder setGroupLimit(int limit) {
        return this.setNative("group.limit", String.valueOf(limit));
    }

    public SolrQueryBuilder setGroupOffset(int offset) {
        return this.setNative("group.offset", String.valueOf(offset));
    }

    public SolrQueryBuilder setGroupFormat(SolrConstants.GroupFormat format) {
        if (format == null) {
            throw new IllegalArgumentException("group.format");
        }
        return this.setNative("group.format", format.toString());
    }

    public SolrQueryBuilder setGroupMain(boolean main) {
        return this.setNative("group.main", Boolean.toString(main));
    }

    public SolrQueryBuilder setGroupNGroups(boolean ngroups) {
        return this.setNative("group.ngroups", Boolean.toString(ngroups));
    }

    public SolrQueryBuilder setGroupTruncate(boolean truncate) {
        return this.setNative("group.truncate", Boolean.toString(truncate));
    }

    public SolrQueryBuilder setGroupFacet(boolean facet) {
        return this.setNative("group.facet", Boolean.toString(facet));
    }

    public SolrQueryBuilder setGroupCachePercent(int cachePercent) {
        if (cachePercent < 0 || cachePercent > 100) {
            throw new IllegalArgumentException("group.cache.percent");
        }
        return this.setNative("group.cache.percent", String.valueOf(cachePercent));
    }

    public SolrQueryBuilder setHighlight(boolean highlight) {
        return this.setNative("hl", Boolean.toString(highlight));
    }

    public SolrQueryBuilder setHighlightQuery(String query) {
        return this.setNative("hl.q", query);
    }

    public SolrQueryBuilder addHighlightField(String field) {
        if (StringUtils.isBlank((String)field)) {
            throw new IllegalArgumentException("hl.fl");
        }
        AnyMap config = this.getFactory().createAnyMap();
        config.put("attribute", field);
        return this.addConfig("highlight", config);
    }

    public SolrQueryBuilder setHighlightSnippets(int snippets) {
        return this.setHighlightSnippets(snippets, null);
    }

    public SolrQueryBuilder setHighlightSnippets(int snippets, String fieldName) {
        return this.setNative("hl.snippets", String.valueOf(snippets), fieldName);
    }

    public SolrQueryBuilder setHighlightFragsize(int fragsize) {
        return this.setHighlightFragsize(fragsize, null);
    }

    public SolrQueryBuilder setHighlightFragsize(int fragsize, String fieldName) {
        return this.setNative("hl.fragsize", String.valueOf(fragsize), fieldName);
    }

    public SolrQueryBuilder setHighlightMergeContiguous(boolean mergeContiguous) {
        return this.setHighlightMergeContiguous(mergeContiguous, null);
    }

    public SolrQueryBuilder setHighlightMergeContiguous(boolean mergeContiguous, String fieldName) {
        return this.setNative("hl.mergeContiguous", Boolean.toString(mergeContiguous), fieldName);
    }

    public SolrQueryBuilder setHighlightRequireFieldMatch(boolean requireFieldMatch) {
        return this.setNative("hl.requireFieldMatch", Boolean.toString(requireFieldMatch));
    }

    public SolrQueryBuilder setHighlightMaxAnalysedChars(int maxAnalysedChars) {
        return this.setNative("hl.maxAnalyzedChars", String.valueOf(maxAnalysedChars));
    }

    public SolrQueryBuilder setHighlightAlternateField(String alternateField) {
        return this.setHighlightAlternateField(alternateField, null);
    }

    public SolrQueryBuilder setHighlightAlternateField(String alternateField, String fieldName) {
        return this.setNative("hl.alternateField", alternateField, fieldName);
    }

    public SolrQueryBuilder setHighlightAlternateFieldLength(int alternateFieldLength) {
        return this.setNative("hl.maxAlternateFieldLength", String.valueOf(alternateFieldLength));
    }

    public SolrQueryBuilder setHighlightPreserveMulti(boolean preserveMulti) {
        return this.setNative("hl.preserveMulti", Boolean.toString(preserveMulti));
    }

    public SolrQueryBuilder setHighlightMaxMultiValuedToExamine(int maxMultiValuedToExamine) {
        return this.setNative("hl.maxMultiValuedToExamine", String.valueOf(maxMultiValuedToExamine), null);
    }

    public SolrQueryBuilder setHighlightMaxMultiValuedToMatch(int maxMultiValuedToMatch) {
        return this.setNative("hl.maxMultiValuedToMatch", String.valueOf(maxMultiValuedToMatch), null);
    }

    public SolrQueryBuilder setHighlightFormatter(String formatter) {
        return this.setHighlightFormatter(formatter, null);
    }

    public SolrQueryBuilder setHighlightFormatter(String formatter, String fieldName) {
        return this.setNative("hl.formatter", formatter, fieldName);
    }

    public SolrQueryBuilder setHighlightSimplePre(String simplePre) {
        return this.setHighlightSimplePre(simplePre, null);
    }

    public SolrQueryBuilder setHighlightSimplePre(String simplePre, String fieldName) {
        return this.setNative("hl.simple.pre", simplePre, fieldName);
    }

    public SolrQueryBuilder setHighlightSimplePost(String simplePost) {
        return this.setHighlightSimplePost(simplePost, null);
    }

    public SolrQueryBuilder setHighlightSimplePost(String simplePost, String fieldName) {
        return this.setNative("hl.simple.post", simplePost, fieldName);
    }

    public SolrQueryBuilder setHighlightFragmeter(String fragmenter) {
        return this.setHighlightFragmenter(fragmenter, null);
    }

    public SolrQueryBuilder setHighlightFragmenter(String fragmenter, String fieldName) {
        return this.setNative("hl.fragmenter", fragmenter, fieldName);
    }

    public SolrQueryBuilder setHighlightFragListBuilder(String fragListBuilder) {
        return this.setHighlightFragListBuilder(fragListBuilder, null);
    }

    public SolrQueryBuilder setHighlightFragListBuilder(String fragListBuilder, String fieldName) {
        return this.setNative("hl.fragListBuilder", fragListBuilder, fieldName);
    }

    public SolrQueryBuilder setHighlightFragmentsBuilder(String fragmentsBuilder) {
        return this.setNative("hl.fragmentsBuilder", fragmentsBuilder);
    }

    public SolrQueryBuilder setHighlightBoundaryScanner(String boundaryScanner) {
        return this.setNative("hl.boundaryScanner", boundaryScanner);
    }

    public SolrQueryBuilder setHighlightBsMaxScan(int bsMaxScan) {
        return this.setNative("hl.bs.maxScan", String.valueOf(bsMaxScan));
    }

    public SolrQueryBuilder setHighlightBsChars(String bsChars) {
        return this.setNative("hl.bs.chars", bsChars);
    }

    public SolrQueryBuilder setHighlightBsType(SolrConstants.HighlightBsType bsType) {
        return this.setNative("hl.bs.type", bsType.toString());
    }

    public SolrQueryBuilder setHighlightBsLanguage(String bsLanguage) {
        return this.setNative("hl.bs.language", bsLanguage);
    }

    public SolrQueryBuilder setHighlightBsCountry(String bsCountry) {
        return this.setNative("hl.bs.country", bsCountry);
    }

    public SolrQueryBuilder setHighlightUseFastVectorHighlighter(boolean useFastVectorHighlighter) {
        return this.setHighlightUseFastVectorHighlighter(useFastVectorHighlighter, null);
    }

    public SolrQueryBuilder setHighlightUseFastVectorHighlighter(boolean useFastVectorHighlighter, String fieldName) {
        return this.setNative("hl.useFastVectorHighlighter", Boolean.toString(useFastVectorHighlighter), fieldName);
    }

    public SolrQueryBuilder setHighlightUsePhraseHighlighter(boolean usePhaseHighlighter) {
        return this.setNative("hl.usePhraseHighlighter", Boolean.toString(usePhaseHighlighter));
    }

    public SolrQueryBuilder setHighlightMultiTerm(boolean highlightMultiTerm) {
        return this.setNative("hl.highlightMultiTerm", Boolean.toString(highlightMultiTerm));
    }

    public SolrQueryBuilder setHighlightRegexSlop(float regexSlop) {
        return this.setNative("hl.regex.slop", String.valueOf(regexSlop));
    }

    public SolrQueryBuilder setHighlightRegexPattern(String regexPattern) {
        return this.setNative("hl.regex.pattern", regexPattern);
    }

    public SolrQueryBuilder setHighlightRegexMaxAnalyzedChars(int regexMaxAnalyzedChars) {
        return this.setNative("hl.regex.maxAnalyzedChars", String.valueOf(regexMaxAnalyzedChars));
    }

    public SolrQueryBuilder setMoreLikeThis(boolean mlt) {
        return this.setNative("mlt", Boolean.toString(mlt));
    }

    public SolrQueryBuilder setMoreLikeThisSimilarityFields(String[] fl) {
        return this.setNative("mlt.fl", StringUtils.join((Object[])fl, (String)","));
    }

    public SolrQueryBuilder setMoreLikeThisCount(int count) {
        return this.setNative("mlt.count", String.valueOf(count));
    }

    public SolrQueryBuilder setMoreLikeThisMinTermFrequency(int minTermFrequency) {
        return this.setNative("mlt.mintf", String.valueOf(minTermFrequency));
    }

    public SolrQueryBuilder setMoreLikeThisMinDocumentFrequency(int minDocumentFrequenxy) {
        return this.setNative("mlt.mindf", String.valueOf(minDocumentFrequenxy));
    }

    public SolrQueryBuilder setMoreLikeThisMinWordLength(int minWordLength) {
        return this.setNative("mlt.minwl", String.valueOf(minWordLength));
    }

    public SolrQueryBuilder setMoreLikeThisMaxWordLength(int maxWordLength) {
        return this.setNative("mlt.maxwl", String.valueOf(maxWordLength));
    }

    public SolrQueryBuilder setMoreLikeThisMaxQueryTerms(int maxQueryTerms) {
        return this.setNative("mlt.maxqt", String.valueOf(maxQueryTerms));
    }

    public SolrQueryBuilder setMoreLikeThisMaxTokens(int maxTokens) {
        return this.setNative("mlt.maxntp", String.valueOf(maxTokens));
    }

    public SolrQueryBuilder setMoreLikeThisBoost(boolean boost) {
        return this.setNative("mlt.boost", Boolean.toString(boost));
    }

    public SolrQueryBuilder setMoreLikeThisQueryFields(String[] qf) {
        return this.setNative("mlt.qf", StringUtils.join((Object[])qf, (String)" "));
    }

    public SolrQueryBuilder setMoreLikeThisMatchInclude(boolean matchInclude) {
        return this.setNative("mlt.match.include", Boolean.toString(matchInclude));
    }

    public SolrQueryBuilder setMoreLikeThisMatchOffset(int matchOffset) {
        return this.setNative("mlt.match.offset", String.valueOf(matchOffset));
    }

    public SolrQueryBuilder setMoreLikeThisInterestingTerms(SolrConstants.MoreLikeThisInterestingTerms interestingTerms) {
        if (interestingTerms == null) {
            throw new IllegalArgumentException("mlt.interestingTerms");
        }
        return this.setNative("mlt.interestingTerms", interestingTerms.toString());
    }

    public SolrQueryBuilder setSpellcheck(boolean spellcheck) {
        return this.setNative("spellcheck", Boolean.toString(spellcheck));
    }

    public SolrQueryBuilder setSpellcheckQuery(String query) {
        return this.setNative("spellcheck.q", query);
    }

    public SolrQueryBuilder setSpellcheckBuild(boolean build) {
        return this.setNative("spellcheck.build", Boolean.toString(build));
    }

    public SolrQueryBuilder setSpellcheckReload(boolean reload) {
        return this.setNative("spellcheck.reload", Boolean.toString(reload));
    }

    public SolrQueryBuilder setSpellcheckDictionary(String dictionary) {
        return this.setNative("spellcheck.dictionary", dictionary);
    }

    public SolrQueryBuilder setSpellcheckCount(int count) {
        return this.setNative("spellcheck.count", String.valueOf(count));
    }

    public SolrQueryBuilder setSpellcheckAlternativeTermCount(int alternativeTermCount) {
        return this.setNative("spellcheck.alternativeTermCount", String.valueOf(alternativeTermCount));
    }

    public SolrQueryBuilder setSpellchekOnlyMorePopular(boolean onlyMorePopular) {
        return this.setNative("spellcheck.onlyMorePopular", Boolean.toString(onlyMorePopular));
    }

    public SolrQueryBuilder setSpellcheckMaxResultsForSuggest(int maxResultsForSuggest) {
        return this.setNative("spellcheck.maxResultsForSuggest", String.valueOf(maxResultsForSuggest));
    }

    public SolrQueryBuilder setSpellcheckExtendedResults(boolean extendedResults) {
        return this.setNative("spellcheck.extendedResults", Boolean.toString(extendedResults));
    }

    public SolrQueryBuilder setSpellcheckCollate(boolean coolate) {
        return this.setNative("spellcheck.collate", Boolean.toString(coolate));
    }

    public SolrQueryBuilder setSpellcheckMaxCollations(int maxCollations) {
        return this.setNative("spellcheck.maxCollations", String.valueOf(maxCollations));
    }

    public SolrQueryBuilder setSpellcheckMaxCollationTries(int maxCollationTries) {
        return this.setNative("spellcheck.maxCollationTries", String.valueOf(maxCollationTries));
    }

    public SolrQueryBuilder setSpellcheckMaxCollationEvaluations(int maxCollationEvaluations) {
        return this.setNative("spellcheck.maxCollationEvaluations", String.valueOf(maxCollationEvaluations));
    }

    public SolrQueryBuilder setSpellcheckCollateParam(String collateParam, String collateParamValue) {
        String parameterName = "spellcheck.collateParam." + collateParam;
        return this.setNative(parameterName, collateParamValue);
    }

    public SolrQueryBuilder setSpellcheckCollateExtendedResults(boolean collateExtendedResults) {
        return this.setNative("spellcheck.collateExtendedResults", String.valueOf(collateExtendedResults));
    }

    public SolrQueryBuilder setSpellcheckCollateMaxCollectDocs(int collateMaxcollateDocs) {
        return this.setNative("spellcheck.collateMaxCollectDocs", String.valueOf(collateMaxcollateDocs));
    }

    public SolrQueryBuilder setSpellcheckAccuracy(float accuracy) {
        return this.setNative("spellcheck.accuracy", String.valueOf(accuracy));
    }

    public SolrQueryBuilder setSpellcheckDictionaryKey(String dictionary, String key, String value) {
        String parameterName = "spellcheck." + dictionary + "." + key;
        return this.setNative(parameterName, value);
    }

    public SolrQueryBuilder setTerms(boolean terms) {
        return this.setNative("terms", Boolean.toString(terms));
    }

    public SolrQueryBuilder addTermsField(String field) {
        return this.setNative("terms.fl", field);
    }

    public SolrQueryBuilder setTermsLower(String lower) {
        return this.setNative("terms.lower", lower);
    }

    public SolrQueryBuilder setTermsLowerInclusive(boolean lowerInclusive) {
        return this.setNative("terms.lower.incl", Boolean.toString(lowerInclusive));
    }

    public SolrQueryBuilder setTermsMincount(int mincount) {
        return this.setNative("terms.mincount", String.valueOf(mincount));
    }

    public SolrQueryBuilder setTermsMaxcount(int maxcount) {
        return this.setNative("terms.maxcount", String.valueOf(maxcount));
    }

    public SolrQueryBuilder setTermsPrefix(String prefix) {
        return this.setNative("terms.prefix", prefix);
    }

    public SolrQueryBuilder setTermsRegex(String regex) {
        return this.setNative("terms.regex", regex);
    }

    public SolrQueryBuilder addTermsRegexFlag(SolrConstants.TermsRegexFlag regexFlag) {
        if (regexFlag == null) {
            throw new IllegalArgumentException("terms.regex.flag");
        }
        return this.setNative("terms.regex.flag", regexFlag.toString());
    }

    public SolrQueryBuilder setTermsLimit(int limit) {
        return this.setNative("terms.limit", String.valueOf(limit));
    }

    public SolrQueryBuilder setTermsUpper(String upper) {
        return this.setNative("terms.upper", upper);
    }

    public SolrQueryBuilder setTermsUpperInclusive(boolean upperInclusive) {
        return this.setNative("terms.upper.incl", Boolean.toString(upperInclusive));
    }

    public SolrQueryBuilder setTermsRaw(boolean raw) {
        return this.setNative("terms.raw", Boolean.toString(raw));
    }

    public SolrQueryBuilder setTermsSort(SolrConstants.TermsSort sort) {
        return this.setNative("terms.sort", sort.toString());
    }

    public SolrQueryBuilder setShards(String ... shards) {
        return this.setNative("shards", StringUtils.join((Object[])shards, (String)","));
    }

    public SolrQueryBuilder setShardsRequestHandler(String qt) {
        return this.setNative("shards.qt", qt);
    }

    public SolrQueryBuilder setShardsInfo(boolean info) {
        return this.setNative("shards.info", Boolean.toString(info));
    }

    public SolrQueryBuilder setShardsTolerant(boolean tolerant) {
        return this.setNative("shards.tolerant", Boolean.toString(tolerant));
    }

    public SolrQueryBuilder setCursorMarkStart() {
        return this.setCursorMark("*");
    }

    public SolrQueryBuilder setCursorMark(String cursorMark) {
        return this.setNative("cursorMark", cursorMark);
    }

    public SolrQueryBuilder setCollection(String ... collection) {
        return this.setNative("collection", StringUtils.join((Object[])collection, (String)","));
    }

    public SolrQueryBuilder setRoute(String route) {
        return this.setNative("_route_", route);
    }

    public SolrQueryBuilder setQueryFindAll() {
        return (SolrQueryBuilder)this.setQuery("*:*");
    }

    public SolrQueryBuilder setNative(String parameterName, String value) {
        return this.setNative(parameterName, value, null);
    }

    public SolrQueryBuilder setNative(String parameterName, String value, String fieldName) {
        parameterName = this.getParameterName(parameterName, fieldName);
        if (value != null) {
            this.getNativeParams().put(parameterName, value);
        } else {
            this.getNativeParams().remove((Object)parameterName);
        }
        return this;
    }

    public SolrQueryBuilder addNative(String parameterName, String value) {
        return this.addNative(parameterName, value, null);
    }

    public SolrQueryBuilder addNative(String parameterName, String value, String fieldName) {
        parameterName = this.getParameterName(parameterName, fieldName);
        if (value != null) {
            Value val = this.getFactory().createStringValue(value);
            this.getNativeParams().add(parameterName, (Any)val);
        }
        return this;
    }

    SolrQueryBuilder addConfig(String parameterName, AnyMap config) {
        this.getMetadata().getSeq(parameterName, true).add((Object)config);
        return this;
    }

    private String getParameterName(String parameterName, String fieldName) {
        if (StringUtils.isBlank((String)parameterName)) {
            throw new IllegalArgumentException("parameter name must not be empty or null.");
        }
        if (fieldName != null) {
            return SolrUtils.getPerFieldParameter(fieldName, parameterName);
        }
        return parameterName;
    }

    private AnyMap getNativeParams() {
        return this.getMetadata().getMap("_solr", true).getMap("query", true);
    }

    private SolrQueryBuilder addFacetConfig(AnyMap config, AnySeq filter, boolean multiselect, AnyMap localParams) {
        if (filter != null) {
            config.put("filter", (Any)filter);
        }
        if (multiselect) {
            config.put("multiselect", Boolean.valueOf(multiselect));
        }
        if (localParams != null) {
            config.put("localParams", (Any)localParams);
        }
        return this.addConfig("facetby", config);
    }
}

