/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.server;

import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.eclipse.smila.solr.SolrConfig;
import org.eclipse.smila.solr.server.SolrServers;

public class HttpServers
extends SolrServers {
    public HttpServers(SolrConfig config) {
        super(config);
    }

    @Override
    protected SolrServer createServer(String index) throws Exception {
        String baseUrl = this.getConfig().getHttpSolrServerBaseUrl();
        if (index != null) {
            baseUrl = this.addIndexName(baseUrl, index);
        }
        HttpSolrServer server = new HttpSolrServer(baseUrl);
        return server;
    }

    @Override
    protected SolrServer createServer() throws Exception {
        return this.createServer(null);
    }

    private String addIndexName(String baseUrl, String index) {
        baseUrl = StringUtils.endsWith((String)baseUrl, (String)"/") ? baseUrl : String.valueOf(baseUrl) + "/";
        baseUrl = String.valueOf(baseUrl) + index;
        return baseUrl;
    }
}

