/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.v2;

import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Activity;
import org.apache.ode.bpel.compiler.bom.AssignActivity;
import org.apache.ode.bpel.compiler.bom.BpelObject;
import org.apache.ode.bpel.compiler.bom.Copy;
import org.apache.ode.bpel.compiler.bom.ExtensionAssignOperation;
import org.apache.ode.bpel.compiler.bom.ExtensionVal;
import org.apache.ode.bpel.compiler.bom.From;
import org.apache.ode.bpel.compiler.bom.LiteralVal;
import org.apache.ode.bpel.compiler.bom.PartnerLinkVal;
import org.apache.ode.bpel.compiler.bom.PropertyVal;
import org.apache.ode.bpel.compiler.bom.To;
import org.apache.ode.bpel.compiler.bom.VariableVal;
import org.apache.ode.bpel.compiler.v2.AssignGeneratorMessages;
import org.apache.ode.bpel.compiler.v2.DefaultActivityGenerator;
import org.apache.ode.bpel.extension.ExtensibleElement;
import org.apache.ode.bpel.extension.ExtensionValidator;
import org.apache.ode.bpel.rtrep.v2.DebugInfo;
import org.apache.ode.bpel.rtrep.v2.OActivity;
import org.apache.ode.bpel.rtrep.v2.OAssign;
import org.apache.ode.bpel.rtrep.v2.OMessageVarType;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.SerializableElement;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class AssignGenerator
extends DefaultActivityGenerator {
    private static final Log __log = LogFactory.getLog(AssignGenerator.class);
    private static final AssignGeneratorMessages __cmsgs = (AssignGeneratorMessages)MessageBundle.getMessages(AssignGeneratorMessages.class);

    AssignGenerator() {
    }

    public OActivity newInstance(Activity activity) {
        return new OAssign(this._context.getOProcess(), this._context.getCurrent());
    }

    public void compile(OActivity oActivity, Activity activity) {
        OAssign oAssign = (OAssign)oActivity;
        AssignActivity assignActivity = (AssignActivity)activity;
        for (AssignActivity.AssignOperation assignOperation : assignActivity.getOperations()) {
            OAssign.Copy copy;
            BpelObject bpelObject;
            if (assignOperation instanceof Copy) {
                bpelObject = (Copy)assignOperation;
                copy = new OAssign.Copy(this._context.getOProcess());
                copy.keepSrcElementName = ((Copy)bpelObject).isKeepSrcElement();
                copy.ignoreMissingFromData = ((Copy)bpelObject).isIgnoreMissingFromData();
                copy.insertMissingToData = ((Copy)bpelObject).isInsertMissingToData();
                copy.ignoreUninitializedFromVariable = ((Copy)bpelObject).isIgnoreUninitializedFromVariable();
                copy.debugInfo = new DebugInfo(this._context.getSourceLocation(), bpelObject.getLineNo(), activity.getExtensibilityElements());
                try {
                    if (((Copy)bpelObject).getFrom() == null) {
                        throw new CompilationException(__cmsgs.errMissingFromSpec().setSource(bpelObject));
                    }
                    copy.from = this.compileFrom(((Copy)bpelObject).getFrom());
                    if (((Copy)bpelObject).getTo() == null) {
                        throw new CompilationException(__cmsgs.errMissingToSpec().setSource(bpelObject));
                    }
                    copy.to = this.compileTo(((Copy)bpelObject).getTo());
                    this.verifyCopy(copy);
                    oAssign.operations.add(copy);
                }
                catch (CompilationException compilationException) {
                    this._context.recoveredFromError(bpelObject, compilationException);
                }
                continue;
            }
            if (!(assignOperation instanceof ExtensionAssignOperation)) continue;
            bpelObject = (ExtensionAssignOperation)assignOperation;
            copy = new OAssign.ExtensionAssignOperation(this._context.getOProcess());
            copy.debugInfo = new DebugInfo(this._context.getSourceLocation(), bpelObject.getLineNo(), activity.getExtensibilityElements());
            try {
                if (activity.is20Draft()) {
                    throw new CompilationException(__cmsgs.errExtensibleAssignNotSupported());
                }
                Element element = ((ExtensionAssignOperation)bpelObject).getNestedElement();
                if (element == null) {
                    throw new CompilationException(__cmsgs.errMissingExtensionAssignOperationElement().setSource(bpelObject));
                }
                if (!this._context.isExtensionDeclared(element.getNamespaceURI())) {
                    throw new CompilationException(__cmsgs.errUndeclaredExtensionAssignOperation().setSource(bpelObject));
                }
                ExtensionValidator extensionValidator = this._context.getExtensionValidator(DOMUtils.getElementQName((Element)element));
                if (extensionValidator != null) {
                    extensionValidator.validate((Object)this._context, (ExtensibleElement)bpelObject);
                }
                copy.extensionName = DOMUtils.getElementQName((Element)element);
                copy.nestedElement = new SerializableElement(element);
                oAssign.operations.add(copy);
            }
            catch (CompilationException compilationException) {
                this._context.recoveredFromError(bpelObject, compilationException);
            }
        }
    }

    private void verifyCopy(OAssign.Copy copy) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("verifying copy: " + copy));
        }
        if (copy.to instanceof OAssign.VariableRef && ((OAssign.VariableRef)copy.to).isMessageRef() && copy.from instanceof OAssign.VariableRef && ((OAssign.VariableRef)copy.from).isMessageRef()) {
            String string = ((OAssign.VariableRef)copy.to).variable.name;
            String string2 = ((OAssign.VariableRef)copy.from).variable.name;
            QName qName = ((OMessageVarType)((OAssign.VariableRef)copy.to).variable.type).messageType;
            QName qName2 = ((OMessageVarType)((OAssign.VariableRef)copy.from).variable.type).messageType;
            if (!qName.equals(qName2)) {
                throw new CompilationException(__cmsgs.errMismatchedMessageAssignment(string, qName, string2, qName2));
            }
        } else {
            if (copy.from instanceof OAssign.VariableRef && ((OAssign.VariableRef)copy.from).isMessageRef() && (!(copy.to instanceof OAssign.VariableRef) || !((OAssign.VariableRef)copy.to).isMessageRef())) {
                String string = ((OAssign.VariableRef)copy.from).variable.name;
                throw new CompilationException(__cmsgs.errCopyFromMessageToNonMessage(string));
            }
            if (copy.to instanceof OAssign.VariableRef && ((OAssign.VariableRef)copy.to).isMessageRef() && (!(copy.from instanceof OAssign.VariableRef) || !((OAssign.VariableRef)copy.from).isMessageRef())) {
                String string = ((OAssign.VariableRef)copy.to).variable.name;
                throw new CompilationException(__cmsgs.errCopyToMessageFromNonMessage(string));
            }
            if (copy.to instanceof OAssign.PartnerLinkRef && !((OAssign.PartnerLinkRef)copy.to).partnerLink.hasPartnerRole()) {
                String string = ((OAssign.PartnerLinkRef)copy.to).partnerLink.getName();
                throw new CompilationException(__cmsgs.errCopyToUndeclaredPartnerRole(string));
            }
            if (copy.from instanceof OAssign.PartnerLinkRef) {
                if (((OAssign.PartnerLinkRef)copy.from).isMyEndpointReference && !((OAssign.PartnerLinkRef)copy.from).partnerLink.hasMyRole()) {
                    String string = ((OAssign.PartnerLinkRef)copy.from).partnerLink.getName();
                    throw new CompilationException(__cmsgs.errCopyFromUndeclaredPartnerRole(string, "myRole"));
                }
                if (!((OAssign.PartnerLinkRef)copy.from).isMyEndpointReference && !((OAssign.PartnerLinkRef)copy.from).partnerLink.hasPartnerRole()) {
                    String string = ((OAssign.PartnerLinkRef)copy.from).partnerLink.getName();
                    throw new CompilationException(__cmsgs.errCopyFromUndeclaredPartnerRole(string, "partnerRole"));
                }
            }
        }
        __log.debug((Object)("Copy verified OK: " + copy));
    }

    private OAssign.RValue compileFrom(From from) {
        assert (from != null);
        try {
            if (from.isExtensionVal()) {
                return this.compileExtensionVal(from.getAsExtensionVal());
            }
            if (from.isLiteralVal()) {
                return this.compileLiteral(from.getAsLiteralVal());
            }
            if (from.isPropertyVal()) {
                OAssign.PropertyRef propertyRef = new OAssign.PropertyRef(this._context.getOProcess());
                PropertyVal propertyVal = from.getAsPropertyVal();
                propertyRef.variable = this._context.resolveVariable(propertyVal.getVariable());
                propertyRef.propertyAlias = this._context.resolvePropertyAlias(propertyRef.variable, propertyVal.getProperty());
                return propertyRef;
            }
            if (from.isVariableVal()) {
                VariableVal variableVal = from.getAsVariableVal();
                OAssign.VariableRef variableRef = new OAssign.VariableRef(this._context.getOProcess());
                variableRef.variable = this._context.resolveVariable(variableVal.getVariable());
                if (variableVal.getPart() != null) {
                    variableRef.part = this._context.resolvePart(variableRef.variable, variableVal.getPart());
                    if (variableVal.getLocation() != null && variableVal.getLocation().getExpression() != null) {
                        variableRef.location = this._context.compileExpr(variableVal.getLocation());
                    }
                }
                if (variableVal.getHeader() != null) {
                    variableRef.headerPart = this._context.resolveHeaderPart(variableRef.variable, variableVal.getHeader());
                    if (variableRef.headerPart == null) {
                        variableRef.headerPart = new OMessageVarType.Part(this._context.getOProcess(), variableVal.getHeader(), null);
                    }
                    if (variableVal.getLocation() != null && variableVal.getLocation().getExpression() != null) {
                        variableRef.location = this._context.compileExpr(variableVal.getLocation());
                    }
                }
                return variableRef;
            }
            if (from.isPartnerLinkVal()) {
                PartnerLinkVal partnerLinkVal = from.getAsPartnerLinkVal();
                OAssign.PartnerLinkRef partnerLinkRef = new OAssign.PartnerLinkRef(this._context.getOProcess());
                partnerLinkRef.partnerLink = this._context.resolvePartnerLink(partnerLinkVal.getPartnerLink());
                partnerLinkRef.isMyEndpointReference = partnerLinkVal.getEndpointReference() == PartnerLinkVal.EndpointReference.MYROLE;
                return partnerLinkRef;
            }
            if (from.getAsExpression() != null) {
                return new OAssign.Expression(this._context.getOProcess(), this._context.compileExpr(from.getAsExpression()));
            }
            throw new CompilationException(__cmsgs.errUnkownFromSpec().setSource(from));
        }
        catch (CompilationException compilationException) {
            if (compilationException.getCompilationMessage().source == null) {
                compilationException.getCompilationMessage().source = from;
            }
            throw compilationException;
        }
    }

    private OAssign.RValue compileExtensionVal(ExtensionVal extensionVal) {
        OAssign.DirectRef directRef = new OAssign.DirectRef(this._context.getOProcess());
        directRef.variable = this._context.resolveVariable(extensionVal.getVariable());
        directRef.elName = extensionVal.getExtension();
        return directRef;
    }

    private OAssign.RValue compileLiteral(LiteralVal literalVal) {
        Element element = literalVal.getLiteral();
        Document document = DOMUtils.newDocument();
        Element element2 = (Element)document.importNode(element, true);
        document.appendChild(element2);
        return new OAssign.Literal(this._context.getOProcess(), document);
    }

    private OAssign.LValue compileTo(To to) {
        assert (to != null);
        try {
            if (to.isPropertyVal()) {
                OAssign.PropertyRef propertyRef = new OAssign.PropertyRef(this._context.getOProcess());
                propertyRef.variable = this._context.resolveVariable(to.getAsPropertyVal().getVariable());
                propertyRef.propertyAlias = this._context.resolvePropertyAlias(propertyRef.variable, to.getAsPropertyVal().getProperty());
                return propertyRef;
            }
            if (to.isVariableVal()) {
                VariableVal variableVal = to.getAsVariableVal();
                OAssign.VariableRef variableRef = new OAssign.VariableRef(this._context.getOProcess());
                variableRef.variable = this._context.resolveVariable(variableVal.getVariable());
                if (to.getAsVariableVal().getPart() != null) {
                    variableRef.part = this._context.resolvePart(variableRef.variable, variableVal.getPart());
                    if (variableVal.getLocation() != null && variableVal.getLocation().getExpression() != null) {
                        variableRef.location = this._context.compileExpr(variableVal.getLocation());
                    }
                }
                if (to.getAsVariableVal().getHeader() != null) {
                    variableRef.headerPart = this._context.resolveHeaderPart(variableRef.variable, variableVal.getHeader());
                    if (variableRef.headerPart == null) {
                        variableRef.headerPart = new OMessageVarType.Part(this._context.getOProcess(), to.getAsVariableVal().getHeader(), null);
                    }
                    if (variableVal.getLocation() != null && variableVal.getLocation().getExpression() != null) {
                        variableRef.location = this._context.compileExpr(variableVal.getLocation());
                    }
                }
                return variableRef;
            }
            if (to.isPartnerLinkVal()) {
                OAssign.PartnerLinkRef partnerLinkRef = new OAssign.PartnerLinkRef(this._context.getOProcess());
                partnerLinkRef.partnerLink = this._context.resolvePartnerLink(to.getAsPartnerLinkVal().getPartnerLink());
                return partnerLinkRef;
            }
            if (to.getAsExpression() != null) {
                return new OAssign.LValueExpression(this._context.getOProcess(), this._context.compileLValueExpr(to.getAsExpression()));
            }
            throw new CompilationException(__cmsgs.errUnknownToSpec().setSource(to));
        }
        catch (CompilationException compilationException) {
            if (compilationException.getCompilationMessage().source == null) {
                compilationException.getCompilationMessage().source = to;
            }
            throw compilationException;
        }
    }
}

