/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.client;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.utils.MaybeRecoverableException;

public class RestException
extends MaybeRecoverableException {
    private static final long serialVersionUID = 1L;
    private static final String KEY_MESSAGE = "message";
    private final int _responseCode;
    private final AnyMap _responseObject;

    public RestException(int responseCode, String message) {
        super(message, RestException.isRecoverable(responseCode));
        this._responseCode = responseCode;
        this._responseObject = null;
    }

    public RestException(int responseCode, AnyMap responseObject) {
        super(RestException.getMessage(responseObject), RestException.isRecoverable(responseCode));
        this._responseCode = responseCode;
        this._responseObject = responseObject;
    }

    private static boolean isRecoverable(int responseCode) {
        return responseCode >= 500;
    }

    private static String getMessage(AnyMap responseObject) {
        Any message;
        if (responseObject != null && (message = (Any)responseObject.get((Object)KEY_MESSAGE)) != null && message.isString()) {
            return message.asValue().asString();
        }
        return "Response did not contain a message.";
    }

    public int getResponseCode() {
        return this._responseCode;
    }

    public AnyMap getResponseObject() {
        return this._responseObject;
    }
}

