/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.server.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.eclipse.smila.clusterconfig.ClusterConfigService;
import org.eclipse.smila.http.server.HttpHandler;
import org.eclipse.smila.http.server.HttpService;
import org.eclipse.smila.http.server.JettyHandler;
import org.eclipse.smila.http.server.internal.HttpServer;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.osgi.service.component.ComponentContext;

public class HttpServiceImpl
implements HttpService {
    public static final String CONFIG_FILE = "jetty.xml";
    private static final String KEY_CONFIG_PORT = "jetty.port";
    private static final String KEY_CONFIG_SECUREPORT = "jetty.securePort";
    private static final String KEY_CONFIG_AUTHUSER = "jetty.user";
    private static final String KEY_CONFIG_AUTHPASSWORD = "jetty.password";
    private static final String KEY_SERVICE_NAME = "serviceName";
    private final Log _log = LogFactory.getLog(HttpServiceImpl.class);
    private XmlConfiguration _configuration;
    private HttpServer _server;
    private final ArrayList<HttpHandler> _handlers = new ArrayList();
    private final ArrayList<JettyHandler> _jettyHandlers = new ArrayList();
    private ClusterConfigService _clusterConfigService;
    private String _serviceName;

    public void addHttpHandler(HttpHandler handler) {
        this._handlers.add(handler);
    }

    public void removeHttpHandler(HttpHandler handler) {
        if (this._handlers.contains(handler)) {
            this._handlers.remove(handler);
        }
    }

    public void addJettyHandler(JettyHandler handler) {
        this._jettyHandlers.add(handler);
    }

    public void removeJettyHandler(JettyHandler handler) {
        if (this._jettyHandlers.contains(handler)) {
            this._jettyHandlers.remove(handler);
        }
    }

    protected void activate(ComponentContext context) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.setConfiguredServiceName(context);
        try {
            try {
                this.readConfiguration();
                this._server = new HttpServer(this._configuration);
                this.addContexts();
                this._server.start();
                this._log.info((Object)("HTTP server started successfully on port(s) " + Arrays.toString(this._server.getPorts()) + "."));
            }
            catch (Exception ex) {
                String msg = "Starting HTTP server failed: " + ex.toString() + ". See log for details.";
                this._log.error((Object)msg, (Throwable)ex);
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    protected void deactivate(ComponentContext context) {
        if (this._server != null) {
            try {
                this._server.stop();
                this._log.info((Object)"HTTP server stopped successfully.");
            }
            catch (Exception e) {
                this._log.error((Object)"Stopping HTTP server failed", (Throwable)e);
            }
        }
    }

    public void setClusterConfigService(ClusterConfigService clusterConfigService) {
        this._clusterConfigService = clusterConfigService;
    }

    public void unsetClusterConfigService(ClusterConfigService clusterConfigService) {
        if (this._clusterConfigService == clusterConfigService) {
            this._clusterConfigService = null;
        }
    }

    private void addContexts() {
        String message;
        for (HttpHandler httpHandler : this._handlers) {
            this._server.addHttpHandler(httpHandler);
            message = "HTTP server has SMILA handler " + httpHandler.getClass().getSimpleName() + " for context " + httpHandler.getRootContextPath() + ".";
            this._log.info((Object)message);
        }
        for (JettyHandler jettyHandler : this._jettyHandlers) {
            this._server.addJettyHandler(jettyHandler);
            message = "HTTP server has Jetty handler " + jettyHandler.getClass().getSimpleName() + " for context " + jettyHandler.getRootContextPath() + ".";
            this._log.info((Object)message);
        }
    }

    private void readConfiguration() throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream configFileStream = ConfigUtils.getConfigStream((String)"org.eclipse.smila.http.server", (String)CONFIG_FILE);){
                this._configuration = new XmlConfiguration(configFileStream);
                if (this._clusterConfigService != null && this._serviceName != null && !this._serviceName.isEmpty()) {
                    int configuredHttpPort = this._clusterConfigService.getHttpPort(this._serviceName);
                    int configuredSecHttpPort = this._clusterConfigService.getSecureHttpPort(this._serviceName);
                    if (configuredSecHttpPort < 0 && configuredHttpPort > 0) {
                        configuredSecHttpPort = configuredHttpPort + 1;
                    }
                    this.setConfigurationProperty(KEY_CONFIG_PORT, configuredHttpPort);
                    this.setConfigurationProperty(KEY_CONFIG_SECUREPORT, configuredSecHttpPort);
                    this.setConfigurationProperty(KEY_CONFIG_AUTHUSER, this._clusterConfigService.getHttpAuthUser());
                    this.setConfigurationProperty(KEY_CONFIG_AUTHPASSWORD, this.prepareHash(this._clusterConfigService.getHttpAuthPasswordHash()));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            throw new IOException("Reading properties from jetty.xml failed: " + ex.toString());
        }
    }

    private String prepareHash(String passwordHash) {
        if (passwordHash == null) {
            return null;
        }
        return "MD5:" + passwordHash;
    }

    private void setConfigurationProperty(String name, int positiveValue) {
        if (positiveValue > 0) {
            this._configuration.getProperties().put(name, Integer.toString(positiveValue));
        }
    }

    private void setConfigurationProperty(String name, String value) {
        if (value != null) {
            this._configuration.getProperties().put(name, value);
        }
    }

    private void setConfiguredServiceName(ComponentContext context) {
        this._serviceName = context.getProperties().get(KEY_SERVICE_NAME).toString();
    }
}

