package org.apache.solr.util.stats;

public class Histogram {

  enum SampleType {
    UNIFORM {
      @Override
      public Sample newSample() {
        return new UniformSample();
      }
    },
    BIASED {
      @Override
      public Sample newSample() {
        return new ExponentiallyDecayingSample();
      }
    };
    public abstract Sample newSample();
  }

  Histogram() {
    ; // nothing
  }

  Histogram(final SampleType arg1) {
    ; // nothing
  }

  Histogram(final Sample arg1) {
    ; // nothing
  }

  public void clear() {
    ; // nothing
  }

  public void update(final int arg1) {
    ; // nothing
  }

  public void update(final long arg1) {
    ; // nothing
  }

  public long getCount() {
    return 0;
  }

  public double getMax() {
    return 0.0;
  }

  public double getMin() {
    return 0.0;
  }

  public double getMean() {
    return 0.0;
  }

  public double getStdDev() {
    return 0.0;
  }

  public double getSum() {
    return 0.0;
  }

  public Snapshot getSnapshot() {
    return new Snapshot();
  }

}
