/**
 *
 */
package org.eclipse.smila.solr.server;

import java.util.Collection;

import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.core.CoreContainer;
import org.eclipse.smila.solr.SolrConfig;

/**
 * @author pwissel
 *
 */
public class EmbeddedServers extends SolrServers {

  private final CoreContainer _coreContainer;

  /**
   *
   */
  public EmbeddedServers(final SolrConfig config) {
    super(config);
    final String solrHome = getConfig().getEmbeddedSolrServerSolrHome();
    _coreContainer = new CoreContainer(solrHome);
    _coreContainer.load();
    // _coreContainer = CoreContainer.createAndLoad(solrHome, new File(solrHome, "solr.xml"));
  }

  /*
   * (non-Javadoc)
   *
   * @see org.eclipse.smila.solr.server.SolrServers#createServer(java.lang.String)
   */
  @Override
  protected SolrServer createServer(final String index) throws Exception {
    final EmbeddedSolrServer server = new EmbeddedSolrServer(_coreContainer, index);
    server.ping();
    return server;
  }

  @Override
  protected SolrServer createServer() throws Exception {
    // any instance of EmbeddedSolrServer need a core so. so we get one random
    final Collection<String> coreNames = _coreContainer.getCoreNames();
    if (coreNames.isEmpty()) {
      final String message =
        String.format("No core available for admin operations. Update solr.home: s%", _coreContainer.getSolrHome());
      throw new SolrServerException(message);
    }
    return createServer(coreNames.iterator().next());
  }

  @Override
  public void shutdown() {
    if (_coreContainer != null) {
      _coreContainer.shutdown();
    }
    super.shutdown();
  }

}
