/**
 *
 */
package org.eclipse.smila.solr.server;

import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.util.NamedList;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.solr.SolrException;
import org.eclipse.smila.solr.SolrUtils;

/**
 * @author pwissel
 *
 */
public class ServerUtil {

  public static AnyMap commit(final SolrServer server, Boolean waitFlush, Boolean waitSearcher, Boolean softCommit)
    throws SolrException {
    if (server == null) {
      throw new IllegalArgumentException("server must not be null");
    }
    // set to default if null
    waitFlush = waitFlush != null ? waitFlush : false;
    waitSearcher = waitSearcher != null ? waitSearcher : false;
    softCommit = softCommit != null ? softCommit : false;
    // process on server and parse response
    try {
      final UpdateResponse response = server.commit(waitFlush, waitSearcher, softCommit);
      return parseUpdateResponse(response);
    } catch (Exception exception) {
      throw new SolrException("error executing commit", exception);
    }
  }

  public static AnyMap optimize(final SolrServer server, Boolean waitFlush, Boolean waitSearcher,
    Integer maxSegments) throws SolrException {
    if (server == null) {
      throw new IllegalArgumentException("server must not be null");
    }
    // set to default if null
    waitFlush = waitFlush != null ? waitFlush : false;
    waitSearcher = waitSearcher != null ? waitSearcher : false;
    maxSegments = maxSegments != null ? maxSegments : 1;
    // process on server and parse response
    try {
      final UpdateResponse response = server.optimize(waitFlush, waitSearcher, maxSegments);
      return parseUpdateResponse(response);
    } catch (final Exception exception) {
      throw new SolrException("error executing opimize", exception);
    }
  }

  private static AnyMap parseUpdateResponse(final UpdateResponse response) {
    final NamedList<Object> namedList = response.getResponse();
    if (namedList != null) {
      return SolrUtils.parseNamedList(namedList);
    }
    return null;
  }

}
