/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.objectstore;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;

/**
 * Comparator implementation for StoreObject timestamps.
 * 
 * @author aweber
 */
public class StoreObjectTimestampComparator implements Comparator<StoreObject>, Serializable {
  /**
   * SerialVersionUID.
   */
  private static final long serialVersionUID = 7886373541766991959L;

  /**
   * {@inheritDoc}
   */
  @Override
  public int compare(final StoreObject o1, final StoreObject o2) {
    if (o1 == o2) {
      return 0;
    }
    final Date t1 = o1.getTimestamp();
    final Date t2 = o2.getTimestamp();
    return t1.compareTo(t2);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(final Object obj) {
    if (obj instanceof StoreObjectTimestampComparator) {
      return this == obj;
    }
    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int hashCode() {
    return -1;
  }
}
