/*********************************************************************************************************************
 * Copyright (c) 2008, 2015 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
**********************************************************************************************************************/
package org.eclipse.smila.scripting;

import org.eclipse.smila.utils.http.NotFoundHTTPResult;

/** Thrown if a requested script does not exist in the script directory. */
public class ScriptNotFoundException extends ScriptingEngineException implements NotFoundHTTPResult {

  private static final long serialVersionUID = 1L;

  /** Creates exception. */
  public ScriptNotFoundException(final String message, final boolean recoverable) {
    super(message, recoverable);
  }

  /** Creates exception. */
  public ScriptNotFoundException(final String message, final Throwable cause, final boolean recoverable) {
    super(message, cause, recoverable);
  }

  /** Creates exception. */
  public ScriptNotFoundException(final String message, final Throwable cause) {
    super(message, cause);
  }

  /** Creates exception. */
  public ScriptNotFoundException(final String message) {
    super(message);
  }

}
