/**********************************************************************************************************************
 * Copyright (c) 2008, 2014 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: Andreas Weber (Empolis Information Management GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.scripting.internal;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/**
 * Utility class to lookup OSGi service references from a script.
 */
public class ServiceAccessor {
  private final BundleContext _bundleContext;

  /** Creates instance. */
  public ServiceAccessor(final BundleContext bundleContext) {
    _bundleContext = bundleContext;
  }

  /**
   * Finds a service reference.
   * 
   * @param serviceInterface
   *          name of an interface provided by the service.
   * @return the service object to call.
   */
  public Object find(final String serviceInterface) {
    final ServiceReference<?> reference = _bundleContext.getServiceReference(serviceInterface);
    if (reference == null) {
      return null;
    }
    return _bundleContext.getService(reference);
  }
}
