/*********************************************************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *********************************************************************************************************************/
package org.eclipse.smila.importing.util;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.importing.ImportingConstants;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskworker.TaskContext;

/** base class for crawling contexts, containing common parameters for crawl processes. */
public abstract class CrawlingContext {

  private final TaskContext _taskContext;

  private final String _jobName;

  private final String _jobRunId;

  private final String _dataSource;

  private final PropertyNameMapper _mapper;

  public CrawlingContext(final TaskContext taskContext, final boolean normalize) {
    _taskContext = taskContext;
    _jobName = taskContext.getTask().getProperties().get(Task.PROPERTY_JOB_NAME);
    _jobRunId = taskContext.getTask().getProperties().get(Task.PROPERTY_JOB_RUN_ID);
    final AnyMap taskParameters = taskContext.getTaskParameters();
    _dataSource = taskParameters.getStringValue(ImportingConstants.TASK_PARAM_DATA_SOURCE);
    _mapper = PropertyNameMapper.createFrom(taskParameters, normalize);
  }

  public TaskContext getTaskContext() {
    return _taskContext;
  }

  public String getJobName() {
    return _jobName;
  }

  public String getJobRunId() {
    return _jobRunId;
  }

  public String getDataSource() {
    return _dataSource;
  }

  public PropertyNameMapper getMapper() {
    return _mapper;
  }

  protected long getNonNegativeParameter(final AnyMap taskParameters, final String parameterName,
    final long defaultValue) {
    final Long parameterValue = taskParameters.getLongValue(parameterName);
    if (parameterValue == null) {
      return defaultValue;
    }
    if (parameterValue < 0) {
      throw new IllegalArgumentException("Task parameter " + parameterName + " must not be negative.");
    }
    return parameterValue;
  }
}
