/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.persistence.zk;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public final class ZkPaths {
    public static final String JOBMANAGER_PREFIX = "/smila/jobmanager";
    public static final String NODE_WORKFLOW_RUNS = "workflow-runs";
    public static final String NODE_BUCKETS = "buckets";
    public static final String NODE_JOBS = "jobs";
    public static final String NODE_DATA = "data";
    public static final String NODE_WORKERDATA = "worker-data";
    public static final String NODE_TASKS = "tasks";
    public static final String NODE_TRANSIENT_BULKS = "transient-bulks";
    public static final String NODE_RUN_DEFINITIONS = "jobrun-definitions";
    public static final String NODE_RUN_DEFINITIONS_JOB = "jobdef";
    public static final String NODE_RUN_DEFINITIONS_WORKFLOW = "wfdef";
    public static final String NODE_RUN_DEFINITIONS_BUCKET = "bucketdef";
    public static final String NODE_WORKFLOW_RUN_FINISHING = "finishing";
    public static final String NODE_CUSTOM = "custom";

    public static String getJobsPath() {
        return "/smila/jobmanager/jobs";
    }

    public static String getJobPath(String jobName) {
        return String.valueOf(ZkPaths.getJobsPath()) + '/' + jobName;
    }

    public static String getJobRunDefinitionsPath(String jobName) {
        return String.valueOf(ZkPaths.getJobPath(jobName)) + '/' + NODE_RUN_DEFINITIONS;
    }

    public static String getJobRunDefPathForJobDef(String jobName) {
        return String.valueOf(ZkPaths.getJobRunDefinitionsPath(jobName)) + '/' + NODE_RUN_DEFINITIONS_JOB;
    }

    public static String getJobRunDefPathForWorkflowDef(String jobName) {
        return String.valueOf(ZkPaths.getJobRunDefinitionsPath(jobName)) + '/' + NODE_RUN_DEFINITIONS_WORKFLOW;
    }

    public static String getJobRunDefPathForBucketDefs(String jobName) {
        return String.valueOf(ZkPaths.getJobRunDefinitionsPath(jobName)) + '/' + NODE_RUN_DEFINITIONS_BUCKET;
    }

    public static String getJobDataPath(String jobName) {
        return String.valueOf(ZkPaths.getJobPath(jobName)) + '/' + NODE_DATA;
    }

    public static String getJobWorkerDataPath(String jobName) {
        return String.valueOf(ZkPaths.getJobPath(jobName)) + '/' + NODE_WORKERDATA;
    }

    public static String getJobWorkerDataPath(String jobName, String workerName) {
        return String.valueOf(ZkPaths.getJobWorkerDataPath(jobName)) + '/' + workerName;
    }

    public static String getWorkflowRunsPath(String jobName) {
        return String.valueOf(ZkPaths.getJobPath(jobName)) + '/' + NODE_WORKFLOW_RUNS;
    }

    public static String getWorkflowRunPath(String jobName, String workflowRunId) {
        return String.valueOf(ZkPaths.getWorkflowRunsPath(jobName)) + '/' + workflowRunId;
    }

    public static String getWorkflowRunDataPath(String jobName, String workflowRunId) {
        return String.valueOf(ZkPaths.getWorkflowRunPath(jobName, workflowRunId)) + "/data";
    }

    public static String getWorkflowRunTasksPath(String jobName, String workflowRunId) {
        return String.valueOf(ZkPaths.getWorkflowRunDataPath(jobName, workflowRunId)) + '/' + NODE_TASKS;
    }

    public static String getWorkflowRunBulksPath(String jobName, String workflowRunId) {
        return String.valueOf(ZkPaths.getWorkflowRunDataPath(jobName, workflowRunId)) + '/' + NODE_TRANSIENT_BULKS;
    }

    public static String getWorkflowRunBulksSubPath(String jobName, String workflowRunId, int currentSubFolder) {
        return String.valueOf(ZkPaths.getWorkflowRunDataPath(jobName, workflowRunId)) + '/' + NODE_TRANSIENT_BULKS + "/" + currentSubFolder;
    }

    public static String getWorkflowRunBarriersPath(String jobName, String workflowRunId, int actionPosition) {
        return String.valueOf(ZkPaths.getWorkflowRunDataPath(jobName, workflowRunId)) + "/barriers/" + actionPosition + '/';
    }

    public static String getWorkflowRunBarrierTasksPath(String jobName, String workflowRunId, int actionPosition) {
        return String.valueOf(ZkPaths.getWorkflowRunBarriersPath(jobName, workflowRunId, actionPosition)) + NODE_TASKS;
    }

    public static String getWorkflowRunBarrierTaskPath(String jobName, String workflowRunId, int actionPosition, String taskId) {
        return String.valueOf(ZkPaths.getWorkflowRunBarrierTasksPath(jobName, workflowRunId, actionPosition)) + '/' + taskId;
    }

    public static String getWorkflowRunBarrierBulksPath(String jobName, String workflowRunId, int actionPosition) {
        return String.valueOf(ZkPaths.getWorkflowRunBarriersPath(jobName, workflowRunId, actionPosition)) + "bulks";
    }

    public static String getWorkflowRunBarrierBulkPath(String jobName, String workflowRunId, int actionPosition, String bulkId) {
        return String.valueOf(ZkPaths.getWorkflowRunBarrierBulksPath(jobName, workflowRunId, actionPosition)) + '/' + ZkPaths.encode(bulkId);
    }

    public static String getWorkflowRunBarrierOpeningPath(String jobName, String workflowRunId, int actionPosition) {
        return String.valueOf(ZkPaths.getWorkflowRunBarriersPath(jobName, workflowRunId, actionPosition)) + "open";
    }

    public static String getWorkflowRunBarrierPendingPath(String jobName, String workflowRunId, int actionPosition) {
        return String.valueOf(ZkPaths.getWorkflowRunBarriersPath(jobName, workflowRunId, actionPosition)) + "pending";
    }

    public static String getTriggerBucketPath(String bucketId) {
        return "/smila/jobmanager/buckets/" + ZkPaths.encode(bucketId);
    }

    public static String getTriggeredJobPath(String bucketId, String jobName) {
        return String.valueOf(ZkPaths.getTriggerBucketPath(bucketId)) + '/' + jobName;
    }

    public static String getCustomDataPath(String job, String worker, String ... path) {
        StringBuilder customPath = new StringBuilder(ZkPaths.getJobPath(job));
        customPath.append('/').append(NODE_CUSTOM).append('/').append(worker);
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String pathElement = stringArray[n2];
            customPath.append('/').append(pathElement);
            ++n2;
        }
        return customPath.toString();
    }

    public static String encode(String value) {
        try {
            return URLEncoder.encode(value, "utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("UTF-8 MUST BE SUPPORTED!", ex);
        }
    }

    public static String decode(String encodedValue) {
        try {
            return URLDecoder.decode(encodedValue, "utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("UTF-8 MUST BE SUPPORTED!", ex);
        }
    }

    private ZkPaths() {
    }
}

