/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskmanager.httphandler;

import java.net.MalformedURLException;
import java.util.Map;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.util.AnyUtil;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.http.server.util.URLCreator;
import org.eclipse.smila.taskmanager.BadParameterTaskmanagerException;
import org.eclipse.smila.taskmanager.TaskCounter;
import org.eclipse.smila.taskmanager.TaskManager;

public class TaskStateHandler
extends JsonRequestHandler {
    public static final String PARAM_RETURN_DETAILS = "returnDetails";
    private TaskManager _taskManager;

    public Object process(String method, String requestUri, Record inputRecord, HttpExchange exchange) throws Exception {
        if ("GET".equals(method)) {
            return this.processGET(requestUri, inputRecord, exchange);
        }
        return this.processPOST(requestUri, inputRecord, exchange);
    }

    private Object processGET(String requestUri, Record inputRecord, HttpExchange exchange) throws Exception {
        String requestHost = this.getRequestHost(exchange);
        boolean returnDetails = this.getBooleanParameter(inputRecord, PARAM_RETURN_DETAILS, false);
        AnyMap result = FACTORY.createAnyMap();
        result.put("failsafety", (Number)this._taskManager.getFailSafetyLevel());
        Map<String, TaskCounter> taskCounters = this._taskManager.getTaskCounters();
        result.put("taskmanager", (Any)this.buildTaskManagerSection(taskCounters));
        AnySeq workers = FACTORY.createAnySeq();
        for (TaskCounter counter : taskCounters.values()) {
            AnyMap workerSection = FACTORY.createAnyMap();
            workerSection.put("name", counter.getWorkerName());
            if (returnDetails) {
                this.createCounterSection(requestHost, workerSection, requestUri, "todo", counter.getTasksTodo(), counter.getTasksTodoPerJobs());
            } else {
                this.createCounterSection(requestHost, workerSection, requestUri, "todo", counter.getTasksTodo(), null);
            }
            this.createCounterSection(requestHost, workerSection, requestUri, "inprogress", counter.getTasksInProgress(), null);
            workers.add((Object)workerSection);
        }
        result.put("workers", (Any)workers);
        AnySeq scaleUp = FACTORY.createAnySeq();
        Map<String, Integer> scaleUpCounters = this._taskManager.getScaleUpCounters();
        for (Map.Entry<String, Integer> counter : scaleUpCounters.entrySet()) {
            AnyMap hostSection = FACTORY.createAnyMap();
            hostSection.put("host", counter.getKey());
            hostSection.put("count", (Number)counter.getValue());
            scaleUp.add((Object)hostSection);
        }
        result.put("maxScaleUp", (Number)this._taskManager.getMaxScaleUp());
        result.put("scaleUp", (Any)scaleUp);
        return result;
    }

    private Object processPOST(String requestUri, Record inputRecord, HttpExchange exchange) throws Exception {
        if (inputRecord == null) {
            throw new IllegalArgumentException("Missing input, cannot update configuration.");
        }
        this._taskManager.updateConfiguration(inputRecord.getMetadata());
        return null;
    }

    private AnyMap buildErrorSection(Exception e) {
        AnyMap errorSection = FACTORY.createAnyMap();
        errorSection.put("error", (Any)AnyUtil.exceptionToAny((Throwable)e));
        return errorSection;
    }

    private AnyMap buildTaskManagerSection(Map<String, TaskCounter> counters) {
        AnyMap taskManagerSection = FACTORY.createAnyMap();
        try {
            int todoCount = 0;
            int inprogressCount = 0;
            for (TaskCounter counter : counters.values()) {
                todoCount += counter.getTasksTodo();
                inprogressCount += counter.getTasksInProgress();
            }
            taskManagerSection.put("todo", (Number)todoCount);
            taskManagerSection.put("inprogress", (Number)inprogressCount);
            return taskManagerSection;
        }
        catch (Exception e) {
            return this.buildErrorSection(e);
        }
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof IllegalArgumentException) {
            return 400;
        }
        if (ex.getCause() != null && ex.getCause() instanceof BadParameterTaskmanagerException) {
            return 404;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    private void createCounterSection(String requestHost, AnyMap workerTaskSection, String requestUri, String type, long count, Map<String, Integer> countsPerJobs) throws MalformedURLException {
        AnyMap counterSection = FACTORY.createAnyMap();
        counterSection.put("count", (Number)count);
        if (countsPerJobs != null && !countsPerJobs.isEmpty()) {
            AnyMap jobsSection = FACTORY.createAnyMap();
            for (Map.Entry<String, Integer> jobInfo : countsPerJobs.entrySet()) {
                jobsSection.put(jobInfo.getKey(), (Number)jobInfo.getValue());
            }
            counterSection.put("jobs", (Any)jobsSection);
        }
        counterSection.put("url", URLCreator.create((String)requestHost, (String)requestUri, (String)(workerTaskSection.get((Object)"name") + "/" + type)).toString());
        workerTaskSection.put(type, (Any)counterSection);
    }

    private boolean getBooleanParameter(Record parameters, String name, boolean defaultValue) {
        if (parameters != null && parameters.getMetadata().containsKey((Object)name)) {
            try {
                return parameters.getMetadata().getBooleanValue(name);
            }
            catch (InvalidValueTypeException invalidValueTypeException) {}
        }
        return defaultValue;
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method) || "POST".equals(method);
    }

    public void setTaskManager(TaskManager taskManager) {
        this._taskManager = taskManager;
    }

    public void unsetTaskManager(TaskManager taskManager) {
        if (this._taskManager == taskManager) {
            this._taskManager = null;
        }
    }
}

