/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.server;

import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.util.NamedList;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.solr.SolrException;
import org.eclipse.smila.solr.SolrUtils;

public class ServerUtil {
    public static AnyMap commit(SolrServer server, Boolean waitFlush, Boolean waitSearcher, Boolean softCommit) throws SolrException {
        if (server == null) {
            throw new IllegalArgumentException("server must not be null");
        }
        waitFlush = waitFlush != null ? waitFlush : false;
        waitSearcher = waitSearcher != null ? waitSearcher : false;
        softCommit = softCommit != null ? softCommit : false;
        try {
            UpdateResponse response = server.commit(waitFlush.booleanValue(), waitSearcher.booleanValue(), softCommit.booleanValue());
            return ServerUtil.parseUpdateResponse(response);
        }
        catch (Exception exception) {
            throw new SolrException("error executing commit", exception);
        }
    }

    public static AnyMap optimize(SolrServer server, Boolean waitFlush, Boolean waitSearcher, Integer maxSegments) throws SolrException {
        if (server == null) {
            throw new IllegalArgumentException("server must not be null");
        }
        waitFlush = waitFlush != null ? waitFlush : false;
        waitSearcher = waitSearcher != null ? waitSearcher : false;
        maxSegments = maxSegments != null ? maxSegments : 1;
        try {
            UpdateResponse response = server.optimize(waitFlush.booleanValue(), waitSearcher.booleanValue(), maxSegments.intValue());
            return ServerUtil.parseUpdateResponse(response);
        }
        catch (Exception exception) {
            throw new SolrException("error executing opimize", exception);
        }
    }

    private static AnyMap parseUpdateResponse(UpdateResponse response) {
        NamedList namedList = response.getResponse();
        if (namedList != null) {
            return SolrUtils.parseNamedList(namedList);
        }
        return null;
    }
}

