/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.update;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrInputDocument;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.util.AnyUtil;
import org.eclipse.smila.solr.params.SolrParams;
import org.eclipse.smila.solr.params.UpdateParams;

public class SolrDocumentConverter {
    public static final String FIELD_NAME = "fieldName";
    public static final String FIELD_BOOST = "fieldBoost";
    public static final String TYPE = "type";
    private final Log _log = LogFactory.getLog(this.getClass());

    public SolrInputDocument toSolrDocument(Record record) throws UnsupportedEncodingException {
        return this.toSolrDocument(record, false);
    }

    public SolrInputDocument toSolrDocument(Record record, List<Record> children) throws UnsupportedEncodingException {
        return this.toSolrDocument(record, false, children);
    }

    public List<SolrInputDocument> toSolrDocuments(List<Record> records) throws UnsupportedEncodingException {
        return this.toSolrDocuments(records, false);
    }

    public SolrInputDocument toSolrDocument(Record record, boolean attachments) throws UnsupportedEncodingException {
        SolrInputDocument document = this.prepareSolrDocument(record);
        for (Map.Entry entry : record.getMetadata().entrySet()) {
            Any any;
            String name = (String)entry.getKey();
            if (this.isSystemKey(name) || !(any = (Any)entry.getValue()).isValue() && !any.isSeq()) continue;
            Object value = AnyUtil.anyToNative((Any)any);
            document.addField(name, value);
        }
        if (attachments && record.hasAttachments()) {
            Iterator attachmentNames = record.getAttachmentNames();
            while (attachmentNames.hasNext()) {
                String name = (String)attachmentNames.next();
                if (this.isSystemKey(name)) continue;
                byte[] bytes = record.getAttachmentAsBytes(name);
                document.addField(name, (Object)new String(bytes, "UTF-8"));
            }
        }
        return document;
    }

    public SolrInputDocument toSolrDocument(Record record, boolean attachments, List<Record> children) throws UnsupportedEncodingException {
        SolrInputDocument document = this.toSolrDocument(record, attachments);
        for (Record child : children) {
            SolrInputDocument childDocument = this.toSolrDocument(child, attachments);
            document.addChildDocument(childDocument);
        }
        return document;
    }

    public List<SolrInputDocument> toSolrDocuments(List<Record> records, boolean attachments) throws UnsupportedEncodingException {
        ArrayList<SolrInputDocument> documents = new ArrayList<SolrInputDocument>(records.size());
        for (Record record : records) {
            SolrInputDocument document = this.toSolrDocument(record, attachments);
            documents.add(document);
        }
        return documents;
    }

    public SolrInputDocument toSolrDocument(Record record, AnyMap mapping) throws UnsupportedEncodingException {
        SolrInputDocument document = this.prepareSolrDocument(record);
        String id = record.getId();
        AnyMap metadata = record.getMetadata();
        for (Map.Entry entry : mapping.entrySet()) {
            String name = (String)entry.getKey();
            Any any = (Any)entry.getValue();
            if (any.isValue()) {
                String fieldName = any.asValue().asString();
                if (StringUtils.isEmpty((String)fieldName)) {
                    fieldName = name;
                }
                this.addObjectToDocument(id, metadata, name, document, fieldName);
                continue;
            }
            if (any.isSeq()) {
                String[] fieldNames = any.asSeq().asStrings().toArray(new String[any.asSeq().size()]);
                this.addObjectToDocument(id, metadata, name, document, fieldNames);
                continue;
            }
            if (!any.isMap()) continue;
            AnyMap map = any.asMap();
            String fieldName = map.containsKey((Object)FIELD_NAME) ? map.getStringValue(FIELD_NAME) : name;
            float fieldBoost = 0.0f;
            boolean boost = false;
            if (map.containsKey((Object)FIELD_BOOST)) {
                fieldBoost = map.getDoubleValue(FIELD_BOOST).floatValue();
                boost = true;
            }
            Type type = map.containsKey((Object)TYPE) ? Type.get(map.getStringValue(TYPE)) : Type.ATTRIBUTE;
            String value = null;
            switch (type) {
                case ATTRIBUTE: {
                    this.addObjectToDocument(id, metadata, name, document, fieldName);
                    break;
                }
                case ATTACHMENT: {
                    if (record.hasAttachment(name)) {
                        byte[] bytes = record.getAttachmentAsBytes(name);
                        value = new String(bytes, "UTF-8");
                        break;
                    }
                    if (!this._log.isWarnEnabled()) break;
                    String message = String.format("Record does not contain attachment for given key. _recordid=%s, key=%s", id, name);
                    this._log.warn((Object)message);
                }
            }
            if (boost) {
                document.addField(fieldName, value, fieldBoost);
                continue;
            }
            document.addField(fieldName, value);
        }
        return document;
    }

    public SolrInputDocument toSolrDocument(Record record, AnyMap mapping, List<Record> children) throws UnsupportedEncodingException {
        SolrInputDocument document = this.toSolrDocument(record, mapping);
        for (Record child : children) {
            SolrInputDocument childDocument = this.toSolrDocument(child, mapping);
            document.addChildDocument(childDocument);
        }
        return document;
    }

    private void addObjectToDocument(String id, AnyMap metadata, String name, SolrInputDocument document, String ... fieldNames) {
        if (metadata.containsKey((Object)name)) {
            Any val = (Any)metadata.get((Object)name);
            if (!val.isMap()) {
                Object value = AnyUtil.anyToNative((Any)val);
                String[] stringArray = fieldNames;
                int n = fieldNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String fieldName = stringArray[n2];
                    document.addField(fieldName, value);
                    ++n2;
                }
            } else if (this._log.isWarnEnabled()) {
                String message = String.format("Can not convert AnyMap to SolrDocument field. _recordid=%s, key=%s", id, name);
                this._log.warn((Object)message);
            }
        } else if (this._log.isWarnEnabled()) {
            String message = String.format("Record does not contain mapping for given key. _recordid=%s, key=%s", id, name);
            this._log.warn((Object)message);
        }
    }

    private SolrInputDocument prepareSolrDocument(Record record) {
        SolrInputDocument document = new SolrInputDocument();
        String id = record.getId();
        document.addField("_recordid", (Object)id);
        UpdateParams params = new UpdateParams(SolrParams.getSolrParams(record));
        Float documentBoost = params.getDocumentBoost(false);
        if (documentBoost != null) {
            document.setDocumentBoost(documentBoost.floatValue());
        }
        return document;
    }

    private boolean isSystemKey(String key) {
        return StringUtils.startsWith((String)key, (String)"_");
    }

    public static enum Type {
        ATTACHMENT,
        ATTRIBUTE;


        public static Type get(String label) {
            return Type.valueOf(label.toUpperCase());
        }
    }
}

