/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.update;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.ipc.IpcAnyWriter;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.util.ResultCollector;
import org.eclipse.smila.solr.SolrServerService;
import org.eclipse.smila.solr.SolrUtils;
import org.eclipse.smila.solr.params.UpdateParams;
import org.eclipse.smila.solr.update.SolrDocumentConverter;
import org.eclipse.smila.utils.service.ServiceUtils;

public class SolrUpdatePipelet
implements Pipelet {
    public static final String PROCESS_AS_BUNCH = "processAsBunch";
    public static final boolean PROCESS_AS_BUNCH_DEFAULT = false;
    private final Log _log = LogFactory.getLog(this.getClass());
    private SolrServerService _servers;
    private AnyMap _configuration;

    public void configure(AnyMap configuration) throws ProcessingException {
        this._configuration = configuration;
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        UpdateParams params = new UpdateParams(blackboard, this._configuration);
        boolean dropOnError = params.getBooleanParameter("_dropOnError", false);
        ResultCollector results = new ResultCollector((ParameterAccessor)params, this._log, dropOnError);
        boolean processAsBunch = params.getBooleanParameter(PROCESS_AS_BUNCH, false);
        if (processAsBunch) {
            this.processAsBunch(blackboard, recordIds, params, results);
        } else {
            this.processAsRecord(blackboard, recordIds, params, results);
        }
        return results.getResultIds();
    }

    private void processAsRecord(Blackboard blackboard, String[] recordIds, UpdateParams params, ResultCollector results) throws ProcessingException {
        String[] stringArray = recordIds;
        int n = recordIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            params.setCurrentRecord(id);
            try {
                String index = params.getIndexName();
                if (index == null) {
                    throw new NullArgumentException("indexname");
                }
                Record record = blackboard.getRecord(id);
                SolrServer server = this.getServer(index);
                UpdateParams.Operation operation = params.getOperation();
                int commitWithinMs = params.getCommitWithinMs(true);
                UpdateResponse response = null;
                switch (operation) {
                    case ADD: {
                        SolrInputDocument document = this.convertToSolrInputDocument(record, params);
                        response = server.add(document, commitWithinMs);
                        break;
                    }
                    case DELETE_BY_ID: {
                        response = server.deleteById(id, commitWithinMs);
                        break;
                    }
                    case DELETE_BY_QUERY: {
                        String query = params.getDeleteQeuery();
                        if (query == null) {
                            throw new ProcessingException("Parameter 'deleteQuery' is required when using operation DELETE_BY_QUERY");
                        }
                        response = server.deleteByQuery(query, commitWithinMs);
                        break;
                    }
                    default: {
                        throw new NotImplementedException(operation.toString());
                    }
                }
                this.handleResponse(response, id);
                results.addResult(id);
            }
            catch (Exception exception) {
                results.addFailedResult(id, exception);
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processAsBunch(Blackboard blackboard, String[] ids, UpdateParams params, ResultCollector results) throws ProcessingException {
        serversAndOperations = this.collectServersAndOperations(ids, params);
        for (String index : serversAndOperations.keySet()) {
            operations = serversAndOperations.get(index);
            block7: for (UpdateParams.Operation operation : operations.keySet()) {
                records = operations.get((Object)operation);
                commitWithinMs = this.calculateLowestCommitWithinMs(records, params);
                try {
                    server = this.getServer(index);
                    switch (SolrUpdatePipelet.$SWITCH_TABLE$org$eclipse$smila$solr$params$UpdateParams$Operation()[operation.ordinal()]) {
                        case 1: {
                            documents = new ArrayList<SolrInputDocument>();
                            for (String id : records) {
                                params.setCurrentRecord(id);
                                record = blackboard.getRecord(id);
                                document = this.convertToSolrInputDocument(record, params);
                                documents.add(document);
                            }
                            response = server.add(documents, commitWithinMs);
                            break;
                        }
                        case 2: {
                            response = server.deleteById((List)records, commitWithinMs);
                            break;
                        }
                        default: {
                            throw new NotImplementedException(operation.toString());
                        }
                    }
                    this.handleResponse(response, new String[0]);
                    for (String id : records) {
                        results.addResult(id);
                    }
                    continue;
                }
                catch (Exception exception) {
                    ** for (id : records)
                }
lbl-1000:
                // 1 sources

                {
                    results.addFailedResult(id, exception);
                    continue;
lbl36:
                    // 1 sources

                }
            }
        }
    }

    private Map<String, Map<UpdateParams.Operation, Collection<String>>> collectServersAndOperations(String[] ids, UpdateParams params) {
        HashMap<String, Map<UpdateParams.Operation, Collection<String>>> servers = new HashMap<String, Map<UpdateParams.Operation, Collection<String>>>();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                String id = stringArray[n2];
                params.setCurrentRecord(id);
                String server = params.getIndexName();
                HashMap<UpdateParams.Operation, ArrayList<String>> operations = (HashMap<UpdateParams.Operation, ArrayList<String>>)servers.get(server);
                if (operations == null) {
                    operations = new HashMap<UpdateParams.Operation, ArrayList<String>>();
                    servers.put(server, operations);
                }
                try {
                    UpdateParams.Operation operation = params.getOperation();
                    ArrayList<String> records = (ArrayList<String>)operations.get((Object)operation);
                    if (records == null) {
                        records = new ArrayList<String>();
                        operations.put(operation, records);
                    }
                    records.add(id);
                }
                catch (IllegalArgumentException exception) {
                    if (!this._log.isWarnEnabled()) break block5;
                    this._log.warn((Object)"Unknown operation.", (Throwable)exception);
                }
            }
            ++n2;
        }
        return servers;
    }

    private int calculateLowestCommitWithinMs(Collection<String> records, UpdateParams params) {
        int commitWithinMs = -1;
        for (String id : records) {
            params.setCurrentRecord(id);
            Integer param = params.getCommitWithinMs(false);
            if (param == null) continue;
            int n = commitWithinMs = commitWithinMs == -1 || commitWithinMs > param ? param : commitWithinMs;
        }
        return commitWithinMs;
    }

    private SolrInputDocument convertToSolrInputDocument(Record record, UpdateParams params) throws UnsupportedEncodingException {
        SolrInputDocument document;
        AnyMap mapping = params.getMapping(false);
        if (mapping != null) {
            document = new SolrDocumentConverter().toSolrDocument(record, mapping);
        } else {
            boolean attachments = params.getAttachments(true);
            document = new SolrDocumentConverter().toSolrDocument(record, attachments);
        }
        return document;
    }

    private void handleResponse(UpdateResponse response, String ... id) throws ProcessingException {
        if (SolrUtils.isErrorResponse((SolrResponseBase)response)) {
            String message = String.format("Error returned by Solr (status=%s).", response.getStatus());
            if (this._log.isDebugEnabled()) {
                AnyMap error = SolrUtils.parseNamedList(response.getResponse());
                try {
                    String json = new IpcAnyWriter(true).writeJsonObject((Any)error);
                    this._log.debug((Object)(String.valueOf(message) + "\n" + json));
                }
                catch (IOException iOException) {}
            }
            throw new ProcessingException(message);
        }
        if (this._log.isInfoEnabled()) {
            String message = String.format("processed record with ids: [%s]", StringUtils.join((Object[])id, (String)", "));
            this._log.info((Object)message);
        }
    }

    private SolrServer getServer(String name) throws SolrServerException, InterruptedException {
        if (this._servers == null) {
            this._servers = (SolrServerService)ServiceUtils.getService(SolrServerService.class);
        }
        return this._servers.getServer(name);
    }
}

