/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.xml.stax;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.IOUtils;
import org.eclipse.smila.utils.xml.stax.XmlSnippetHandler;

public class XmlSnippetSplitter {
    private final XMLInputFactory _inputFactory = XMLInputFactory.newInstance();
    private final XMLOutputFactory _outputFactory = XMLOutputFactory.newInstance();
    private final XmlSnippetHandler _snippetHandler;
    private final QName _begin;
    private final QName _end;

    public XmlSnippetSplitter(XmlSnippetHandler snippetHandler, QName begin, QName end) {
        if (snippetHandler == null) {
            throw new IllegalArgumentException("parameter snippetHandler is null");
        }
        if (begin == null) {
            throw new IllegalArgumentException("parameter begin is null");
        }
        if (end == null) {
            throw new IllegalArgumentException("parameter end is null");
        }
        this._snippetHandler = snippetHandler;
        this._begin = begin;
        this._end = end;
    }

    public void read(InputStream inputStream) throws XMLStreamException {
        if (inputStream != null) {
            try {
                XMLEventReader eventReader = this._inputFactory.createXMLEventReader(inputStream);
                this.parse(eventReader);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
    }

    private void parse(XMLEventReader eventReader) throws XMLStreamException {
        ByteArrayOutputStream outputStream = null;
        try (XMLEventWriter eventWriter = null;){
            ArrayList<StartElement> parents = new ArrayList<StartElement>();
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                if (this.isSnippetBegin(event)) {
                    outputStream = new ByteArrayOutputStream();
                    eventWriter = this._outputFactory.createXMLEventWriter(outputStream, "UTF-8");
                    eventWriter.add(event);
                    this.writeNamespaces(event.asStartElement(), parents, eventWriter);
                } else if (eventWriter != null) {
                    if (this.isSnippetEnd(event)) {
                        eventWriter.add(event);
                        eventWriter.close();
                        this._snippetHandler.handleSnippet(outputStream.toByteArray());
                        eventWriter = null;
                        outputStream = null;
                    } else {
                        eventWriter.add(event);
                    }
                }
                if (event.isStartElement()) {
                    parents.add(event.asStartElement());
                    continue;
                }
                if (!event.isEndElement()) continue;
                parents.remove(parents.size() - 1);
            }
        }
    }

    private void writeNamespaces(StartElement element, List<StartElement> parents, XMLEventWriter eventWriter) throws XMLStreamException {
        HashMap<String, Namespace> prefixes = null;
        for (StartElement parent : parents) {
            Iterator<Namespace> namespaces = parent.getNamespaces();
            while (namespaces.hasNext()) {
                if (prefixes == null) {
                    prefixes = new HashMap<String, Namespace>();
                }
                Namespace namespace = namespaces.next();
                prefixes.put(namespace.getPrefix(), namespace);
            }
        }
        if (prefixes != null) {
            Iterator<Namespace> namespaces = element.getNamespaces();
            while (namespaces.hasNext()) {
                prefixes.remove(namespaces.next().getPrefix());
            }
            for (Namespace namespace : prefixes.values()) {
                eventWriter.add(namespace);
            }
        }
    }

    private boolean isSnippetBegin(XMLEvent event) {
        if (!event.isStartElement()) {
            return false;
        }
        QName name = event.asStartElement().getName();
        String ns = this._begin.getNamespaceURI();
        return this._begin.getLocalPart().equals(name.getLocalPart()) && (ns.isEmpty() || ns.equals(name.getNamespaceURI()));
    }

    private boolean isSnippetEnd(XMLEvent event) {
        if (!event.isEndElement()) {
            return false;
        }
        QName name = event.asEndElement().getName();
        String ns = this._end.getNamespaceURI();
        return this._end.getLocalPart().equals(name.getLocalPart()) && (ns.isEmpty() || ns.equals(name.getNamespaceURI()));
    }
}

