/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.scripting.internal;

import org.eclipse.smila.blackboard.BlackboardFactory;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.PipeletTracker;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.scripting.ScriptingEngineException;
import org.eclipse.smila.scripting.internal.AnyWrapper;
import org.eclipse.smila.scripting.internal.PipeletWrapper;
import org.eclipse.smila.scripting.internal.RecordWrapper;
import org.mozilla.javascript.Scriptable;

public class PipeletBuilder {
    private final PipeletTracker _pipeletTracker;
    private final BlackboardFactory _blackboardFactory;
    private final Scriptable _baseScope;

    public PipeletBuilder(PipeletTracker pipeletTracker, BlackboardFactory blackboardFactory, Scriptable baseScope) {
        this._pipeletTracker = pipeletTracker;
        this._blackboardFactory = blackboardFactory;
        this._baseScope = baseScope;
    }

    public PipeletWrapper create(String className, Object configuration) throws ScriptingEngineException {
        Class pipeletClass = (Class)this._pipeletTracker.getRegisteredPipelets().get(className);
        if (pipeletClass == null) {
            throw new ScriptingEngineException("Unknown pipelet class " + className);
        }
        try {
            Pipelet pipelet = (Pipelet)pipeletClass.newInstance();
            this.configurePipelet(pipelet, configuration);
            return new PipeletWrapper(pipelet, this._blackboardFactory, this._baseScope);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ScriptingEngineException("Error while creating instance for pipelet " + className, e);
        }
    }

    private void configurePipelet(Pipelet pipelet, Object configuration) throws ScriptingEngineException {
        Object anyConfig;
        if (configuration != null && (anyConfig = configuration instanceof Record ? ((Record)configuration).getMetadata() : (configuration instanceof RecordWrapper ? ((RecordWrapper)configuration).unwrap().getMetadata() : AnyWrapper.unwrapAny(configuration))) != null) {
            if (anyConfig instanceof AnyMap) {
                try {
                    pipelet.configure(anyConfig);
                }
                catch (ProcessingException e) {
                    throw new ScriptingEngineException("Error while configuring instance for pipelet " + pipelet.getClass(), e);
                }
            } else {
                throw new ScriptingEngineException("Configuration must be a Map object.");
            }
        }
    }
}

