/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.scripting.internal;

import java.util.ArrayList;
import java.util.UUID;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.blackboard.BlackboardFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.scripting.ScriptingEngineException;
import org.eclipse.smila.scripting.internal.RecordWrapper;
import org.mozilla.javascript.Scriptable;

public class PipeletWrapper {
    private final Pipelet _pipelet;
    private final BlackboardFactory _blackboardFactory;
    private final Scriptable _baseScope;

    public PipeletWrapper(Pipelet pipelet, BlackboardFactory blackboardFactory, Scriptable baseScope) {
        this._pipelet = pipelet;
        this._blackboardFactory = blackboardFactory;
        this._baseScope = baseScope;
    }

    public RecordWrapper[] process(Object input) throws ScriptingEngineException {
        Record[] records = RecordWrapper.asRecordArray(input);
        Record[] result = this.process(records);
        if (result != null) {
            RecordWrapper[] wrappedResult = new RecordWrapper[result.length];
            int i = 0;
            while (i < result.length) {
                wrappedResult[i] = new RecordWrapper(result[i], this._baseScope);
                ++i;
            }
            return wrappedResult;
        }
        return null;
    }

    private Record[] process(Record[] records) throws ScriptingEngineException {
        Blackboard blackboard = this._blackboardFactory.createTransientBlackboard();
        ArrayList<String> ids = new ArrayList<String>();
        try {
            Record[] recordArray = records;
            int n = records.length;
            int n2 = 0;
            while (n2 < n) {
                Record record = recordArray[n2];
                if (record.getId() == null) {
                    record.setId(UUID.randomUUID().toString());
                }
                blackboard.setRecord(record);
                ids.add(record.getId());
                ++n2;
            }
            String[] recordIds = ids.toArray(new String[0]);
            String[] resultIds = this._pipelet.process(blackboard, recordIds);
            ArrayList<Record> result = new ArrayList<Record>();
            String[] stringArray = resultIds;
            int n3 = resultIds.length;
            int n4 = 0;
            while (n4 < n3) {
                String id = stringArray[n4];
                result.add(blackboard.getRecord(id));
                ++n4;
            }
            Record[] recordArray2 = result.toArray(new Record[0]);
            return recordArray2;
        }
        catch (RuntimeException | BlackboardAccessException | ProcessingException e) {
            throw new ScriptingEngineException("Error while calling Pipelet " + this._pipelet.getClass().getSimpleName(), e);
        }
        finally {
            blackboard.unload();
        }
    }
}

