/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.scripting.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.util.AnyUtil;
import org.eclipse.smila.scripting.internal.AnyMapWrapper;
import org.eclipse.smila.scripting.internal.AttachmentWrapper;
import org.eclipse.smila.scripting.internal.ObjectWrapperBase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

public class RecordWrapper
extends ObjectWrapperBase {
    private static final String PROPERTY_ID = "$id";
    private static final String PROPERTY_METADATA = "$metadata";
    private static final String PROPERTY_ATTACHMENTS = "$attachments";
    private final Record _record;
    private final AnyMapWrapper _metadata;
    private final AttachmentWrapper _attachments;

    public RecordWrapper(Record record, Scriptable parentScope) {
        super(parentScope);
        this._record = record;
        this._metadata = new AnyMapWrapper(this._record.getMetadata(), parentScope);
        this._attachments = new AttachmentWrapper(this._record, parentScope);
    }

    public static Record asRecord(Object input) {
        if (input instanceof Wrapper) {
            input = ((Wrapper)input).unwrap();
        }
        if (input instanceof Record) {
            return (Record)input;
        }
        if (input instanceof Map) {
            AnyMap anyMap = (AnyMap)AnyUtil.objectToAny((Object)input);
            Record record = DataFactory.DEFAULT.createRecord(anyMap);
            if (record.getId() == null) {
                record.setId(UUID.randomUUID().toString());
            }
            return record;
        }
        throw new IllegalArgumentException("Cannot convert object to record: " + input);
    }

    public static Record[] asRecordArray(Object input) {
        if (input instanceof Wrapper) {
            input = ((Wrapper)input).unwrap();
        }
        if (input instanceof Object[]) {
            input = Arrays.asList((Object[])input);
        }
        if (input instanceof List) {
            List<Object> inputList = input;
            Record[] records = new Record[inputList.size()];
            int i = 0;
            while (i < inputList.size()) {
                records[i] = RecordWrapper.asRecord(inputList.get(i));
                ++i;
            }
            return records;
        }
        return new Record[]{RecordWrapper.asRecord(input)};
    }

    public Record unwrap() {
        return this._record;
    }

    public String getClassName() {
        return "RecordWrapper";
    }

    public Object get(String name, Scriptable start) {
        switch (name) {
            case "$id": {
                return this._record.getId();
            }
            case "$metadata": {
                return this._metadata;
            }
            case "$attachments": {
                return this._attachments;
            }
        }
        return this._metadata.get(name, start);
    }

    public Object get(int index, Scriptable start) {
        return this._metadata.get(index, start);
    }

    public void put(String name, Scriptable start, Object value) {
        switch (name) {
            case "$id": {
                this._record.setId(value.toString());
                break;
            }
            case "$metadata": 
            case "$attachments": {
                Context.reportRuntimeError((String)("Cannot set property " + name));
                break;
            }
            default: {
                this._metadata.put(name, start, value);
            }
        }
    }

    public void put(int index, Scriptable start, Object value) {
        this._metadata.put(index, start, value);
    }

    public void delete(String name) {
        switch (name) {
            case "$metadata": 
            case "$attachments": 
            case "$id": {
                Context.reportRuntimeError((String)("Cannot delete property " + name));
                break;
            }
            default: {
                this._metadata.delete(name);
            }
        }
    }

    public void delete(int index) {
        this._metadata.delete(index);
    }

    public boolean has(String name, Scriptable start) {
        return this._metadata.has(name, start);
    }

    public boolean has(int index, Scriptable start) {
        return this._metadata.has(index, start);
    }

    public Object[] getIds() {
        return this._metadata.getIds();
    }
}

