/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.jdbc;

import java.util.Locale;
import org.eclipse.smila.common.logging.MessageCollector;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.importing.crawler.jdbc.JdbcCrawlerWorker;
import org.eclipse.smila.importing.util.CrawlingContext;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.TaskLogWarn;

public final class JdbcCrawlingContext
extends CrawlingContext {
    private final long _maxRecordsPerBulk;
    private final long _maxAttachmentSize;
    private final String _dbUrl;
    private final AnyMap _dbPropertiess;
    private final String _crawlSql;
    private final String _splitLimitsSql;
    private final Long _splitIncrement;
    private Any _idColumns;
    private final Any _deltaColumns;
    private final MessageCollector _messages;

    public JdbcCrawlingContext(TaskContext taskContext) {
        super(taskContext, true);
        AnyMap taskParameters = taskContext.getTaskParameters();
        this._maxRecordsPerBulk = this.getNonNegativeParameter(taskParameters, "maxRecordsPerBulk", JdbcCrawlerWorker.MAX_RECORDS_PER_BULK_DEFAULT);
        this._maxAttachmentSize = this.getNonNegativeParameter(taskParameters, "maxAttachmentSize", JdbcCrawlerWorker.MAX_ATTACHMENT_SIZE_DEFAULT);
        if (this._maxRecordsPerBulk <= 0L) {
            throw new IllegalArgumentException("Task parameter maxRecordsPerBulk must be greater than 0");
        }
        if (this._maxAttachmentSize <= 0L) {
            throw new IllegalArgumentException("Task parameter maxAttachmentSize must be greater than 0");
        }
        this._dbUrl = taskParameters.getStringValue("dbUrl");
        if (this._dbUrl == null || this._dbUrl.trim().length() == 0) {
            throw new IllegalArgumentException("Parameter 'dbUrl' of task " + taskContext.getTask().getTaskId() + " is null or empty");
        }
        this._dbPropertiess = taskParameters.getMap("dbProps");
        if (this._dbPropertiess == null || this._dbPropertiess.isEmpty()) {
            throw new IllegalArgumentException("Parameter 'dbProps' of task " + taskContext.getTask().getTaskId() + " is null or empty");
        }
        this._crawlSql = taskParameters.getStringValue("crawlSql");
        if (this._crawlSql == null || this._crawlSql.trim().length() == 0) {
            throw new IllegalArgumentException("Parameter 'crawlSql' of task " + taskContext.getTask().getTaskId() + " is null or empty");
        }
        this._splitIncrement = taskParameters.getLongValue("splitIncrement");
        this._splitLimitsSql = taskParameters.getStringValue("splitLimitsSql");
        this.checkSplittingParameters(taskContext);
        this._idColumns = (Any)taskParameters.get((Object)"idColumns");
        if (this._idColumns == null || this._idColumns.isEmpty()) {
            throw new IllegalArgumentException("Parameter 'idColumns' of task " + taskContext.getTask().getTaskId() + " is null or empty");
        }
        this._idColumns = this.normalizeColumnNames(this._idColumns);
        this._deltaColumns = this.normalizeColumnNames((Any)taskParameters.get((Object)"deltaColumns"));
        this._messages = new TaskLogWarn(taskContext.getLog());
    }

    public long getMaxRecordsPerBulk() {
        return this._maxRecordsPerBulk;
    }

    public long getMaxAttachmentSize() {
        return this._maxAttachmentSize;
    }

    public String getDbUrl() {
        return this._dbUrl;
    }

    public AnyMap getDbProperties() {
        return this._dbPropertiess;
    }

    public String getCrawlSql() {
        return this._crawlSql;
    }

    public String getSplitLimitsSql() {
        return this._splitLimitsSql;
    }

    public Long getSplitIncrement() {
        return this._splitIncrement;
    }

    public Any getIdColumns() {
        return this._idColumns;
    }

    public Any getDeltaColumns() {
        return this._deltaColumns;
    }

    private Any normalizeColumnNames(Any columnNames) {
        if (columnNames == null) {
            return null;
        }
        if (columnNames.isString()) {
            return DataFactory.DEFAULT.createStringValue(columnNames.asValue().asString().toUpperCase(Locale.ENGLISH));
        }
        AnySeq normalizedNames = DataFactory.DEFAULT.createAnySeq();
        for (Any column : columnNames) {
            normalizedNames.add(column.asValue().asString().toUpperCase(Locale.ENGLISH));
        }
        return normalizedNames;
    }

    public MessageCollector getMessages() {
        return this._messages;
    }

    private void checkSplittingParameters(TaskContext taskContext) {
        boolean ok = true;
        if (this._splitIncrement != null && this._splitIncrement > 0L) {
            ok = this._splitLimitsSql != null && this._splitLimitsSql.trim().length() > 0;
        } else {
            boolean bl = ok = this._splitLimitsSql == null || this._splitLimitsSql.trim().length() == 0;
        }
        if (!ok) {
            throw new IllegalArgumentException("Parameter 'splitIncrement' and 'splitLimitsSql' of task " + taskContext.getTask().getTaskId() + " must both be set or both be null or empty");
        }
    }
}

