/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.management.jmx.client.osgi;

import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.smila.management.jmx.client.cmd.CmdConsoleImpl;
import org.eclipse.smila.management.jmx.client.config.CmdConfigType;
import org.eclipse.smila.management.jmx.client.config.ConnectionConfigType;
import org.eclipse.smila.management.jmx.client.config.JmxClientConfigType;
import org.eclipse.smila.management.jmx.client.helpers.ConfigHelper;
import org.eclipse.smila.management.jmx.client.helpers.ConsoleArguments;
import org.eclipse.smila.management.jmx.client.osgi.OSGiConfigLoader;
import org.eclipse.smila.utils.config.ConfigUtils;

public class SMILACommandProvider
implements CommandProvider {
    public static final String BUNDLE_ID = "org.eclipse.smila.management.jmx.client";
    private final Log _log = LogFactory.getLog(this.getClass());

    public String getHelp() {
        StringBuilder help = new StringBuilder("--- SMILA commands ---\n");
        help.append("\tsmila - invoke SMILA JMX management operation\n");
        help.append("Usage:\tsmila <operation> <parameter 1> <parameter N> ").append("[-c:<alternate connection>] [-f:<alternate configuration file name>}\n");
        try {
            InputStream configStream = ConfigUtils.getConfigStream((String)BUNDLE_ID, (String)"config.xml");
            JmxClientConfigType config = OSGiConfigLoader.load(configStream);
            help.append(ConfigHelper.createHelpString(config, "smila"));
        }
        catch (Exception ex) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)"Failed to load default config file, cannot produce command samples.", (Throwable)ex);
            }
            help.append("\tFailed to load default config file, cannot produce command samples.");
        }
        return help.toString();
    }

    public void _smila(CommandInterpreter intp) {
        ArrayList<String> args = new ArrayList<String>();
        String arg = null;
        while ((arg = intp.nextArgument()) != null) {
            args.add(arg);
        }
        ConsoleArguments arguments = null;
        try {
            arguments = ConsoleArguments.parse(args.toArray(new String[args.size()]));
        }
        catch (Throwable e) {
            intp.println((Object)e.toString());
            return;
        }
        String validateMessage = arguments.validate();
        if (validateMessage != null) {
            intp.println((Object)validateMessage);
            return;
        }
        try {
            InputStream configStream = ConfigUtils.getConfigStream((String)BUNDLE_ID, (String)arguments.getConfiguration());
            JmxClientConfigType config = OSGiConfigLoader.load(configStream);
            ConnectionConfigType connectionConfig = ConfigHelper.findConnectionConfig(arguments, config);
            CmdConfigType cmdConfig = ConfigHelper.findCmdConfig(arguments, config);
            try {
                CmdConsoleImpl console = new CmdConsoleImpl();
                console.execute(cmdConfig, connectionConfig, arguments.getParameters());
            }
            catch (Exception exception) {
                return;
            }
        }
        catch (Exception e) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)"error executing smila osgi command", (Throwable)e);
            }
            intp.println((Object)e.toString());
        }
    }
}

