/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.servlet;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.search.api.helper.QueryBuilder;
import org.eclipse.smila.search.servlet.ARequestParser;
import org.eclipse.smila.utils.collections.MultiValueMap;

public class MultiPartRequestParser
extends ARequestParser {
    private final MultiValueMap<String, String> parameters = new MultiValueMap();
    private final Map<String, byte[]> attachments = new HashMap<String, byte[]>();
    private final AnyMap attachmentFileNames = DataFactory.DEFAULT.createAnyMap();

    public String getSingleParameterValue(String paramName) {
        String result = null;
        if (this.parameters.containsKey((Object)paramName)) {
            result = (String)((List)this.parameters.get((Object)paramName)).get(0);
        }
        return result;
    }

    public void initialParse(List<FileItem> items) {
        int i = 0;
        while (i < items.size()) {
            FileItem item = items.get(i);
            String fieldName = item.getFieldName();
            if (item.isFormField()) {
                this.parameters.add((Object)fieldName, (Object)item.getString());
            } else if (item.getSize() > 0L) {
                this.attachments.put(fieldName, item.get());
                this.attachmentFileNames.put(fieldName, (Any)DataFactory.DEFAULT.createStringValue(item.getName()));
            }
            ++i;
        }
    }

    public QueryBuilder parse() {
        QueryBuilder builder = new QueryBuilder();
        for (String paramName : this.parameters.keySet()) {
            List values = (List)this.parameters.get((Object)paramName);
            if (values == null || values.size() <= 0) continue;
            this.processParameter(builder, paramName, values.toArray(new String[values.size()]));
        }
        for (String attachmentName : this.attachments.keySet()) {
            byte[] content = this.attachments.get(attachmentName);
            if (content == null || content.length <= 0) continue;
            builder.setAttachment(attachmentName, content);
        }
        if (!this.attachmentFileNames.isEmpty()) {
            builder.getQuery().getMetadata().put("attachmentFileNames", (Any)this.attachmentFileNames);
        }
        this.setupQuery(builder);
        return builder;
    }
}

