/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.definitions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.smila.common.definitions.AccessAny;
import org.eclipse.smila.common.definitions.DefinitionBase;
import org.eclipse.smila.common.exceptions.InvalidDefinitionException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.jobmanager.definitions.JobRunMode;
import org.eclipse.smila.jobmanager.definitions.WorkflowAction;
import org.eclipse.smila.jobmanager.exceptions.InvalidConfigException;

public class WorkflowDefinition
extends DefinitionBase {
    public static final String KEY_WORKFLOWS = "workflows";
    public static final String KEY_PARAMETERS = "parameters";
    public static final String KEY_VALUE = "value";
    public static final String KEY_START_ACTION = "startAction";
    public static final String KEY_ACTIONS = "actions";
    public static final String KEY_MODES = "modes";
    private final AnyMap _parameters;
    private final List<JobRunMode> _modes;
    private final WorkflowAction _startAction;
    private final Collection<WorkflowAction> _actions;

    public WorkflowDefinition(AnyMap workflow) throws Exception {
        super(workflow);
        this._parameters = this._definitionMap.getMap(KEY_PARAMETERS);
        AnySeq modesAny = this._definitionMap.getSeq(KEY_MODES);
        try {
            this._modes = JobRunMode.parseModes(modesAny);
        }
        catch (InvalidDefinitionException ex) {
            throw new InvalidDefinitionException("Workflow '" + this._name + "': " + ex.getMessage());
        }
        AnyMap startActionAny = (AnyMap)AccessAny.get((AnyMap)this._definitionMap, (String)KEY_START_ACTION, (Any.ValueType)Any.ValueType.MAP);
        if (startActionAny == null) {
            throw new InvalidConfigException("Workflow " + this._name + " does not define a startAction.");
        }
        this._startAction = new WorkflowAction(startActionAny, 0);
        AnySeq actionsAny = (AnySeq)AccessAny.get((AnyMap)this._definitionMap, (String)KEY_ACTIONS, (Any.ValueType)Any.ValueType.SEQ);
        if (actionsAny != null) {
            int position = 1;
            this._actions = new ArrayList<WorkflowAction>();
            for (Any actionAny : actionsAny) {
                if (!actionAny.isMap()) continue;
                this._actions.add(new WorkflowAction((AnyMap)actionAny, position++));
            }
        } else {
            this._actions = null;
        }
    }

    public static WorkflowDefinition parseWorkflow(AnyMap workflowAny) throws InvalidDefinitionException {
        WorkflowDefinition workflow = null;
        try {
            workflow = new WorkflowDefinition(workflowAny);
        }
        catch (InvalidDefinitionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InvalidDefinitionException("Invalid any structure", (Throwable)ex);
        }
        return workflow;
    }

    public AnyMap getParameters() {
        return this._parameters;
    }

    public List<JobRunMode> getJobRunModes() {
        return AccessAny.copyCollection(this._modes);
    }

    public JobRunMode getDefaultJobRunMode() {
        if (this._modes == null) {
            return null;
        }
        return this.getJobRunModes().get(0);
    }

    public WorkflowAction getStartAction() {
        return this._startAction;
    }

    public Collection<WorkflowAction> getActions() {
        return AccessAny.copyCollection(this._actions);
    }

    public AnyMap toAny(boolean includingAdditionalAttributes) {
        try {
            AnyMap workflowAny = super.toAny(includingAdditionalAttributes);
            if (!includingAdditionalAttributes) {
                if (this._modes != null) {
                    workflowAny.put(KEY_MODES, (Any)JobRunMode.toAny(this._modes));
                }
                if (this._parameters != null) {
                    workflowAny.put(KEY_PARAMETERS, (Any)this._parameters);
                }
                if (this._startAction != null) {
                    workflowAny.put(KEY_START_ACTION, this._startAction.toAny());
                }
                if (this._actions != null) {
                    AnySeq actionsAny = DataFactory.DEFAULT.createAnySeq();
                    for (WorkflowAction action : this._actions) {
                        actionsAny.add((Object)action.toAny());
                    }
                    workflowAny.put(KEY_ACTIONS, (Any)actionsAny);
                }
            }
            return workflowAny;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to create Any object for workflow " + this._name, ex);
        }
    }

    public Collection<String> getReferencedBuckets() {
        HashSet<String> result = new HashSet<String>();
        ArrayList<WorkflowAction> actions = new ArrayList<WorkflowAction>();
        if (this._startAction != null) {
            actions.add(this._startAction);
        }
        if (this._actions != null) {
            actions.addAll(this._actions);
        }
        for (WorkflowAction workflowAction : actions) {
            if (workflowAction.getInput() != null) {
                result.addAll(workflowAction.getInput().values());
            }
            if (workflowAction.getOutput() == null) continue;
            result.addAll(workflowAction.getOutput().values());
        }
        return result;
    }

    public Collection<String> getReferencedWorkers() {
        HashSet<String> result = new HashSet<String>();
        if (this._startAction != null) {
            result.add(this._startAction.getWorker());
        }
        if (this._actions != null) {
            for (WorkflowAction workflowAction : this._actions) {
                result.add(workflowAction.getWorker());
            }
        }
        return result;
    }

    public boolean isNonForking() {
        HashSet<String> inputs = new HashSet<String>();
        if (this._startAction.getInput() != null) {
            inputs.addAll(this._startAction.getInput().values());
        }
        if (this._actions != null) {
            for (WorkflowAction action : this._actions) {
                if (action.getInput() == null) continue;
                for (String input : action.getInput().values()) {
                    if (inputs.contains(input)) {
                        return false;
                    }
                    inputs.add(input);
                }
            }
        }
        return true;
    }
}

