/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.taskgenerator;

import java.util.List;
import java.util.UUID;
import org.eclipse.smila.jobmanager.JobRun;
import org.eclipse.smila.jobmanager.definitions.JobDefinition;
import org.eclipse.smila.jobmanager.definitions.WorkerDefinition;
import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskworker.input.InputMode;

public abstract class TaskGenerationUtil {
    public static void setAdditionalTaskProperties(List<Task> tasks, JobRun jobRun, String workflowRunId, WorkerDefinition worker, int actionPosition) {
        String qualifierSlot = null;
        for (WorkerDefinition.Input input : worker.getInput()) {
            if (!input.getModes().contains(InputMode.QUALIFIER)) continue;
            qualifierSlot = input.getName();
        }
        for (Task task : tasks) {
            String deliverDelay;
            List inputBulks;
            task.getProperties().put("workflowRunId", workflowRunId);
            task.getProperties().put("jobRunId", jobRun.getJobRunId());
            task.getProperties().put("jobName", jobRun.getJobName());
            task.getProperties().put("actionPosition", Integer.toString(actionPosition));
            if (qualifierSlot != null && (inputBulks = (List)task.getInputBulks().get(qualifierSlot)) != null && !inputBulks.isEmpty()) {
                BulkInfo firstBulk = (BulkInfo)inputBulks.get(0);
                task.setQualifier(firstBulk.getObjectName());
            }
            if (!task.getParameters().containsKey((Object)"_sessionId")) {
                task.getParameters().put("_sessionId", UUID.randomUUID().toString());
            }
            if ((deliverDelay = TaskGenerationUtil.getDeliverDelay(jobRun, worker.getName())) == null) continue;
            task.getProperties().put("deliveryDelay", deliverDelay);
        }
    }

    private static String getDeliverDelay(JobRun jobRun, String workerName) {
        String deliverDelay = null;
        JobDefinition jobDefinition = jobRun.getJobDefinition();
        if (jobDefinition.getTaskDelayWorkers().contains(workerName)) {
            deliverDelay = Long.toString(jobDefinition.getTaskDelay());
        }
        return deliverDelay;
    }
}

