/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.feed;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.importing.crawler.feed.FeedCrawlerWorker;
import org.eclipse.smila.importing.util.CrawlingContext;
import org.eclipse.smila.taskworker.TaskContext;

public class FeedCrawlingContext
extends CrawlingContext {
    private final long _maxRecordsPerBulk;
    private final Any _feedUrls;
    private final Any _deltaProperties;

    public FeedCrawlingContext(TaskContext taskContext) {
        super(taskContext, false);
        AnyMap taskParameters = taskContext.getTaskParameters();
        this._maxRecordsPerBulk = this.getNonNegativeParameter(taskParameters, "maxRecordsPerBulk", FeedCrawlerWorker.MAX_RECORDS_PER_BULK_DEFAULT);
        if (this._maxRecordsPerBulk == 0L) {
            throw new IllegalArgumentException("Task parameter maxRecordsPerBulk must be greater than 0");
        }
        this._feedUrls = (Any)taskParameters.get((Object)"feedUrls");
        if (this._feedUrls == null || this._feedUrls.isEmpty()) {
            throw new IllegalArgumentException("Parameter 'feedUrls' of task " + taskContext.getTask().getTaskId() + " is null or empty");
        }
        this._deltaProperties = (Any)taskParameters.get((Object)"deltaProperties");
    }

    public long getMaxRecordsPerBulk() {
        return this._maxRecordsPerBulk;
    }

    public Any getFeedUrls() {
        return this._feedUrls;
    }

    public Any getDeltaProperties() {
        return this._deltaProperties;
    }
}

