/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.common.language.Language;
import org.eclipse.smila.common.language.LanguageIdentifyService;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.util.ResultCollector;
import org.eclipse.smila.utils.service.ServiceUtils;

public class LanguageIdentifyPipelet
implements Pipelet {
    public static final String CONTENT_ATTRIBUTE = "ContentAttribute";
    public static final String LANGUAGE_ATTRIBUTE = "LanguageAttribute";
    public static final String DEFAULT_LANGUAGE = "DefaultLanguage";
    public static final String ALTERNATIVE_NAME_ATTRIBUTE = "AlternativeNameAttribute";
    public static final String DEFAULT_ALTERNATIVE_NAME = "DefaultAlternativeName";
    public static final String USE_CERTAIN_LANGUAGES_ONLY = "UseCertainLanguagesOnly";
    private final Log _log = LogFactory.getLog(this.getClass());
    private AnyMap _configuration;
    private LanguageIdentifyService _languageIdentifier;

    public void configure(AnyMap configuration) throws ProcessingException {
        this._configuration = configuration;
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        LanguageIdentifyService identifier = this.getLanguageIdentifier();
        ParameterAccessor paramAccessor = new ParameterAccessor(blackboard, this._configuration);
        ResultCollector resultCollector = new ResultCollector(paramAccessor, this._log, false);
        String[] stringArray = recordIds;
        int n = recordIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            try {
                paramAccessor.setCurrentRecord(id);
                Parameters parameters = new Parameters(paramAccessor);
                this.identifyAndStore(blackboard, id, identifier, parameters);
                resultCollector.addResult(id);
            }
            catch (Exception ex) {
                resultCollector.addFailedResult(id, ex);
            }
            ++n2;
        }
        return resultCollector.getResultIds();
    }

    private synchronized LanguageIdentifyService getLanguageIdentifier() throws ProcessingException {
        if (this._languageIdentifier == null) {
            try {
                this._languageIdentifier = (LanguageIdentifyService)ServiceUtils.getService(LanguageIdentifyService.class);
            }
            catch (Exception ex) {
                this._log.warn((Object)"Error while waiting for LanguageIdentifier service to come up.", (Throwable)ex);
            }
            if (this._languageIdentifier == null) {
                throw new ProcessingException("No LanguageIdentifier service available, giving up");
            }
        }
        return this._languageIdentifier;
    }

    private void identifyAndStore(Blackboard blackboard, String id, LanguageIdentifyService identifier, Parameters p) throws BlackboardAccessException {
        AnyMap metaData = blackboard.getMetadata(id);
        if (metaData.containsKey((Object)p._contentAttributeName)) {
            String text = metaData.getStringValue(p._contentAttributeName);
            Language identifiedLanguage = identifier.identify(text);
            if (identifiedLanguage != null) {
                if (identifiedLanguage.isCertain() || !p._useCertainLanguagesOnly) {
                    this.storeIdentifiedLanguage(id, identifiedLanguage, metaData, p);
                } else {
                    if (this._log.isInfoEnabled()) {
                        this._log.info((Object)("Detected language '" + identifiedLanguage.getIsoLanguage() + "' for Id '" + id + "' is not certain. Detected language is not used."));
                    }
                    this.setDefaultLanguage(id, metaData, p);
                }
            } else {
                if (this._log.isWarnEnabled()) {
                    this._log.warn((Object)("Unable to identify Language for Id '" + id + "'."));
                }
                this.setDefaultLanguage(id, metaData, p);
            }
        } else {
            if (this._log.isWarnEnabled()) {
                this._log.warn((Object)("Unable to identify Language for Id '" + id + "'. No input value found for '" + CONTENT_ATTRIBUTE + "'"));
            }
            this.setDefaultLanguage(id, metaData, p);
        }
    }

    private void storeIdentifiedLanguage(String id, Language identifiedLanguage, AnyMap metaData, Parameters p) {
        String language = identifiedLanguage.getIsoLanguage();
        String alternativeName = identifiedLanguage.getAlternativeName();
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("Detected language '" + language + "' for Id '" + id + "'."));
        }
        if (p._languageAttributeName != null) {
            metaData.put(p._languageAttributeName, language);
        }
        if (alternativeName != null && p._alternativeNameAttributeName != null) {
            metaData.put(p._alternativeNameAttributeName, alternativeName);
        }
    }

    private void setDefaultLanguage(String id, AnyMap metaData, Parameters p) {
        if (p._defaultLanguage != null) {
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("Using default language '" + p._defaultLanguage + "' for Id '" + id + "'."));
            }
            metaData.put(p._languageAttributeName, p._defaultLanguage);
        }
        if (p._defaultAlternativeName != null) {
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("Using default alternativeName '" + p._defaultAlternativeName + "' for Id '" + id + "'."));
            }
            metaData.put(p._alternativeNameAttributeName, p._defaultAlternativeName);
        }
    }

    private static class Parameters {
        private final String _contentAttributeName;
        private final String _languageAttributeName;
        private final String _defaultLanguage;
        private final String _alternativeNameAttributeName;
        private final String _defaultAlternativeName;
        private final boolean _useCertainLanguagesOnly;

        Parameters(ParameterAccessor paramAccessor) throws ProcessingException {
            this._contentAttributeName = paramAccessor.getRequiredParameter(LanguageIdentifyPipelet.CONTENT_ATTRIBUTE);
            this._languageAttributeName = paramAccessor.getParameter(LanguageIdentifyPipelet.LANGUAGE_ATTRIBUTE, null);
            this._defaultLanguage = paramAccessor.getParameter(LanguageIdentifyPipelet.DEFAULT_LANGUAGE, null);
            this._alternativeNameAttributeName = paramAccessor.getParameter(LanguageIdentifyPipelet.ALTERNATIVE_NAME_ATTRIBUTE, null);
            this._defaultAlternativeName = paramAccessor.getParameter(LanguageIdentifyPipelet.DEFAULT_ALTERNATIVE_NAME, null);
            this._useCertainLanguagesOnly = paramAccessor.getBooleanParameter(LanguageIdentifyPipelet.USE_CERTAIN_LANGUAGES_ONLY, Boolean.valueOf(false));
            if (this._languageAttributeName == null && this._alternativeNameAttributeName == null) {
                throw new ProcessingException("One of the config properties LanguageAttribute or AlternativeNameAttribute have to be specified!");
            }
        }
    }
}

