/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.MessageDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.engine.MessageExchangeImpl;
import org.apache.ode.bpel.engine.MessageImpl;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.rapi.PartnerLinkModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MyRoleMessageExchangeImpl
extends MessageExchangeImpl
implements MyRoleMessageExchange {
    private static final Log __log = LogFactory.getLog(MyRoleMessageExchangeImpl.class);
    protected final QName _callee;
    protected MyRoleMessageExchange.CorrelationStatus _cstatus;
    protected String _clientId;

    public MyRoleMessageExchangeImpl(ODEProcess oDEProcess, String string, PartnerLinkModel partnerLinkModel, Operation operation, QName qName) {
        super(oDEProcess, null, string, partnerLinkModel, partnerLinkModel != null ? partnerLinkModel.getMyRolePortType() : null, operation);
        this._callee = qName;
    }

    public MyRoleMessageExchange.CorrelationStatus getCorrelationStatus() {
        return this._cstatus;
    }

    @Override
    void load(MessageExchangeDAO messageExchangeDAO) {
        super.load(messageExchangeDAO);
        this._cstatus = messageExchangeDAO.getCorrelationStatus() == null ? null : MyRoleMessageExchange.CorrelationStatus.valueOf((String)messageExchangeDAO.getCorrelationStatus());
        this._clientId = messageExchangeDAO.getPartnersKey();
    }

    @Override
    public void save(MessageExchangeDAO messageExchangeDAO) {
        super.save(messageExchangeDAO);
        messageExchangeDAO.setCorrelationStatus(this._cstatus == null ? null : this._cstatus.toString());
        messageExchangeDAO.setPartnersKey(this._clientId);
        messageExchangeDAO.setCallee(this._callee);
        if (this._changes.contains((Object)MessageExchangeImpl.Change.REQUEST)) {
            this._changes.remove((Object)MessageExchangeImpl.Change.REQUEST);
            MessageDAO messageDAO = messageExchangeDAO.createMessage(this._request.getType());
            messageDAO.setData(this._request.getMessage());
            messageDAO.setHeader(this._request.getHeader());
            messageExchangeDAO.setRequest(messageDAO);
        }
    }

    public MessageExchange.FailureType getFailureType() {
        if (this.getStatus() != MessageExchange.Status.ACK || this.getAckType() != MessageExchange.AckType.FAILURE) {
            throw new IllegalStateException("MessageExchange did not fail!");
        }
        return this._failureType;
    }

    public String getClientId() {
        return this._clientId;
    }

    public Future<MessageExchange.Status> invokeAsync() {
        throw new BpelEngineException("Unsupported InvocationStyle");
    }

    public MessageExchange.Status invokeBlocking() throws BpelEngineException, TimeoutException {
        throw new BpelEngineException("Unsupported InvocationStyle");
    }

    public void invokeReliable() {
        throw new BpelEngineException("Unsupported InvocationStyle");
    }

    public MessageExchange.Status invokeTransacted() throws BpelEngineException {
        throw new BpelEngineException("Unsupported InvocationStyle");
    }

    public void setRequest(Message message) {
        this._request = (MessageImpl)message;
        this._changes.add(MessageExchangeImpl.Change.REQUEST);
    }

    public QName getServiceName() {
        return this._callee;
    }

    @Override
    public String toString() {
        try {
            return "{MyRoleMex#" + this._mexId + " [Client " + this._clientId + "] calling " + this._callee + "." + this.getOperationName() + "(...)}";
        }
        catch (Throwable throwable) {
            return "{MyRoleMex#???}";
        }
    }

    public void complete() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageExchangeDAO doInvoke() {
        if (this.getStatus() != MessageExchange.Status.NEW) {
            throw new IllegalStateException("Invalid state: " + this.getStatus());
        }
        this.request();
        MessageExchangeDAO messageExchangeDAO = this._process.createMessageExchange(this.getMessageExchangeId(), 'M');
        this.save(messageExchangeDAO);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("invoke() EPR= " + this._epr + " ==> " + this._process));
        }
        try {
            this._process.invokeProcess(messageExchangeDAO);
        }
        finally {
            if (messageExchangeDAO.getStatus() == MessageExchange.Status.ACK) {
                this._failureType = messageExchangeDAO.getFailureType();
                this._fault = messageExchangeDAO.getFault();
                this._explanation = messageExchangeDAO.getFaultExplanation();
                this.ack(messageExchangeDAO.getAckType());
            }
        }
        return messageExchangeDAO;
    }

    protected Message cloneMessage(Message message) {
        Message message2 = this.createMessage(message.getType());
        message2.setMessage((Element)message.getMessage().cloneNode(true));
        Map map = message.getHeaderParts();
        for (Object object : map.keySet()) {
            message2.setHeaderPart((String)object, (Element)((Node)map.get(object)).cloneNode(true));
        }
        Map map2 = message.getHeaderParts();
        for (String string : map2.keySet()) {
            message2.setHeaderPart(string, (Element)((Node)map2.get(string)).cloneNode(true));
        }
        return message2;
    }

    protected abstract void onAsyncAck(MessageExchangeDAO var1);
}

